/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rwt.AdapterFactory;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.AdapterManager;

public class AdapterManagerImpl
extends SessionSingletonBase
implements AdapterManager {
    private final Map registry = new HashMap();
    private final Map factoryCache = new HashMap();
    private final AdapterFactory nullFactory = new NullFactory();
    static /* synthetic */ Class class$0;

    private AdapterManagerImpl() {
    }

    public static AdapterManager getInstance() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.AdapterManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AdapterManager)AdapterManagerImpl.getInstance(clazz);
    }

    public Object getAdapter(Object adaptable, Class adapter) {
        Object result = null;
        Object hash = this.calculateHash(adaptable, adapter);
        AdapterFactory cachedFactory = (AdapterFactory)this.factoryCache.get(hash);
        result = cachedFactory != null ? cachedFactory.getAdapter(adaptable, adapter) : this.doGetAdapter(adaptable, adapter, hash);
        return result;
    }

    private Object calculateHash(Object adaptable, Class adapter) {
        Class<?> adaptableClass = adaptable.getClass();
        int hash = 23273 + adaptableClass.hashCode() * 37 + adapter.hashCode();
        return new Integer(hash);
    }

    private Object doGetAdapter(Object adaptable, Class adapter, Object hash) {
        Object result = null;
        Class[] keys = new Class[this.registry.size()];
        this.registry.keySet().toArray(keys);
        int i = 0;
        while (result == null && i < keys.length) {
            if (keys[i].isAssignableFrom(adaptable.getClass())) {
                List factoryList = (List)this.registry.get(keys[i]);
                AdapterFactory[] factories = new AdapterFactory[factoryList.size()];
                factoryList.toArray(factories);
                int j = 0;
                while (result == null && j < factories.length) {
                    Class[] adapters = factories[j].getAdapterList();
                    int k = 0;
                    while (result == null && k < adapters.length) {
                        if (adapter.isAssignableFrom(adapters[k])) {
                            result = factories[j].getAdapter(adaptable, adapter);
                            this.factoryCache.put(hash, factories[j]);
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (result == null) {
            this.factoryCache.put(hash, this.nullFactory);
        }
        return result;
    }

    public void registerAdapters(AdapterFactory factory, Class adaptable) {
        if (this.registry.containsKey(adaptable)) {
            List factories = (List)this.registry.get(adaptable);
            if (!factories.contains(factory)) {
                factories.add(factory);
            }
        } else {
            ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>();
            factories.add(factory);
            this.registry.put(adaptable, factories);
        }
        this.factoryCache.clear();
    }

    public void deregisterAdapters(AdapterFactory factory, Class adaptable) {
        List factories;
        if (this.registry.containsKey(adaptable) && (factories = (List)this.registry.get(adaptable)).contains(factory)) {
            factories.remove(factory);
        }
        this.factoryCache.clear();
    }

    private static class NullFactory
    implements AdapterFactory {
        private static final Class[] EMPTY = new Class[0];

        private NullFactory() {
        }

        public Object getAdapter(Object adaptable, Class adapter) {
            return null;
        }

        public Class[] getAdapterList() {
            return EMPTY;
        }
    }
}

