/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.browser.Default;
import org.eclipse.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.lifecycle.RWTLifeCycleServiceHandlerSync;
import org.eclipse.rwt.internal.resources.ResourceManager;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.LifeCycleServiceHandler;
import org.eclipse.rwt.internal.service.TemplateHolder;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.internal.util.EntitiesUtil;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;

public final class LifeCycleServiceHandlerConfigurer
implements LifeCycleServiceHandler.ILifeCycleServiceHandlerConfigurer {
    private static final String PACKAGE_NAME;
    private static final String FOLDER;
    private static final String INDEX_TEMPLATE;
    private static int probeCount;
    private static long lastModified;
    private static final LifeCycleServiceHandler.LifeCycleServiceHandlerSync syncHandler;
    private static TemplateHolder template;
    private static final List registeredBrandings;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.LifeCycleServiceHandlerConfigurer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PACKAGE_NAME = clazz.getPackage().getName();
        FOLDER = PACKAGE_NAME.replace('.', '/');
        INDEX_TEMPLATE = String.valueOf(FOLDER) + "/rwt-index.html";
        lastModified = System.currentTimeMillis();
        syncHandler = new RWTLifeCycleServiceHandlerSync();
        registeredBrandings = new ArrayList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TemplateHolder getTemplateOfStartupPage() throws IOException {
        LifeCycleServiceHandlerConfigurer.readContent();
        template.reset();
        LifeCycleServiceHandlerConfigurer.setDummyBrowser();
        try {
            template.replace(TemplateHolder.VAR_LIBRARIES, LifeCycleServiceHandlerConfigurer.getLibraries());
            template.replace(TemplateHolder.VAR_APPSCRIPT, LifeCycleServiceHandlerConfigurer.getAppScript());
            LifeCycleServiceHandlerConfigurer.applyBranding();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            LifeCycleServiceHandlerConfigurer.removeDummyBrowser();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        LifeCycleServiceHandlerConfigurer.removeDummyBrowser();
        return template;
    }

    public synchronized boolean isStartupPageModifiedSince() {
        boolean result;
        int currentProbeCount = TextSizeDetermination.getProbeCount();
        if (probeCount != currentProbeCount) {
            lastModified = System.currentTimeMillis();
            probeCount = currentProbeCount;
        }
        HttpServletRequest request = ContextProvider.getRequest();
        HttpServletResponse response = ContextProvider.getResponse();
        response.addHeader("Cache-Control", "max-age=0, no-cache, must-revalidate, no-store");
        long dateHeader = request.getDateHeader("If-Modified-Since");
        if (dateHeader + 1000L < lastModified) {
            result = true;
            response.addDateHeader("Last-Modified", lastModified);
        } else {
            result = false;
            response.setStatus(304);
        }
        return result;
    }

    public LifeCycleServiceHandler.LifeCycleServiceHandlerSync getSynchronizationHandler() {
        return syncHandler;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readContent() throws IOException {
        if (template != null) return;
        InputStream stream = LifeCycleServiceHandlerConfigurer.loadTemplateFile();
        InputStreamReader isr = new InputStreamReader(stream, "ISO-8859-1");
        BufferedReader reader = new BufferedReader(isr);
        try {
            String line = reader.readLine();
            StringBuffer buffer = new StringBuffer();
            while (true) {
                block4: {
                    if (line != null) break block4;
                    template = new TemplateHolder(buffer.toString());
                    break;
                }
                buffer.append(line);
                buffer.append("\n");
                line = reader.readLine();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            reader.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        reader.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InputStream loadTemplateFile() throws IOException {
        InputStream result = null;
        IResourceManager manager = ResourceManager.getInstance();
        ClassLoader buffer = manager.getContextLoader();
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.rwt.internal.service.LifeCycleServiceHandlerConfigurer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        manager.setContextLoader(clazz.getClassLoader());
        try {
            result = manager.getResourceAsStream(INDEX_TEMPLATE);
            if (result == null) {
                String text = "Failed to load Browser Survey HTML Page. Resource {0} could not be found.";
                Object[] param = new Object[]{INDEX_TEMPLATE};
                String msg = MessageFormat.format(text, param);
                throw new IOException(msg);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            manager.setContextLoader(buffer);
            throw throwable;
        }
        {
            Object var6_8 = null;
            manager.setContextLoader(buffer);
            return result;
        }
    }

    private static String getAppScript() throws IOException {
        String string;
        LifeCycleServiceHandlerConfigurer.fakeWriter();
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HtmlResponseWriter writer = stateInfo.getResponseWriter();
        writer.startElement("script", null);
        writer.writeText("safd", null);
        writer.clearBody();
        try {
            DisplayUtil.writeAppScript("w1");
            string = LifeCycleServiceHandlerConfigurer.getContent(writer);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            LifeCycleServiceHandlerConfigurer.restoreWriter();
            throw throwable;
        }
        LifeCycleServiceHandlerConfigurer.restoreWriter();
        return string;
    }

    private static void fakeWriter() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HtmlResponseWriter original = stateInfo.getResponseWriter();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.LifeCycleServiceHandlerConfigurer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String key = clazz.getName();
        stateInfo.setAttribute(key, original);
        HtmlResponseWriter fake = new HtmlResponseWriter();
        stateInfo.setResponseWriter(fake);
    }

    private static void restoreWriter() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.LifeCycleServiceHandlerConfigurer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String key = clazz.getName();
        HtmlResponseWriter writer = (HtmlResponseWriter)stateInfo.getAttribute(key);
        stateInfo.setResponseWriter(writer);
    }

    private static void setDummyBrowser() {
        String id = "com_w4t_detected_session_browser";
        ContextProvider.getSession().setAttribute(id, new Default(true));
    }

    private static void removeDummyBrowser() {
        String id = "com_w4t_detected_session_browser";
        ContextProvider.getSession().setAttribute(id, null);
    }

    private static String getLibraries() throws IOException {
        String string;
        LifeCycleServiceHandlerConfigurer.fakeWriter();
        try {
            DisplayUtil.writeLibraries();
            string = LifeCycleServiceHandlerConfigurer.getContent(ContextProvider.getStateInfo().getResponseWriter());
            Object var0_1 = null;
        }
        catch (Throwable throwable) {
            Object var0_2 = null;
            LifeCycleServiceHandlerConfigurer.restoreWriter();
            throw throwable;
        }
        LifeCycleServiceHandlerConfigurer.restoreWriter();
        return string;
    }

    private static String getContent(HtmlResponseWriter writer) {
        StringBuffer msg = new StringBuffer();
        int i = 0;
        while (i < writer.getBodySize()) {
            msg.append(writer.getBodyToken(i));
            ++i;
        }
        return msg.toString();
    }

    private static void applyBranding() throws IOException {
        AbstractBranding branding = BrandingUtil.findBranding();
        LifeCycleServiceHandlerConfigurer.registerBrandingResources(branding);
        HttpServletRequest request = ContextProvider.getRequest();
        String entryPoint = request.getParameter("startup");
        if (entryPoint == null && ((entryPoint = branding.getDefaultEntryPoint()) == null || "".equals(entryPoint))) {
            entryPoint = "default";
        }
        if (branding.getThemeId() != null) {
            ThemeUtil.setCurrentThemeId(branding.getThemeId());
        }
        BrandingUtil.replacePlaceholder(template, TemplateHolder.VAR_BODY, branding.getBody());
        BrandingUtil.replacePlaceholder(template, TemplateHolder.VAR_TITLE, branding.getTitle());
        String headers = BrandingUtil.headerMarkup(branding);
        BrandingUtil.replacePlaceholder(template, TemplateHolder.VAR_HEADERS, headers);
        String encodedEntryPoint = EntitiesUtil.encodeHTMLEntities(entryPoint);
        BrandingUtil.replacePlaceholder(template, TemplateHolder.VAR_STARTUP, encodedEntryPoint);
        String script = BrandingUtil.exitMessageScript(branding);
        BrandingUtil.replacePlaceholder(template, TemplateHolder.VAR_EXIT_CONFIRMATION, script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerBrandingResources(AbstractBranding branding) throws IOException {
        List list = registeredBrandings;
        synchronized (list) {
            if (!registeredBrandings.contains(branding)) {
                branding.registerResources();
                registeredBrandings.add(branding);
            }
        }
    }
}

