/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.util.HashSet;
import org.eclipse.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rwt.internal.theme.QxBoolean;
import org.eclipse.rwt.internal.theme.QxIdentifier;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.ThemeCssValuesMap;
import org.eclipse.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rwt.internal.theme.css.IStylePropertyMap;
import org.eclipse.rwt.internal.theme.css.StyleRule;
import org.eclipse.rwt.internal.theme.css.StyleSheet;

public final class Theme {
    private final String name;
    private StyleSheet styleSheet;
    private QxType[] values;
    private ThemeCssValuesMap valuesMap;
    private String jsId;

    public Theme(String name, StyleSheet styleSheet) {
        this.checkName(name);
        this.name = name;
        this.styleSheet = styleSheet;
        this.readValuesFromStyleSheet();
    }

    public void initValuesMap(ThemeableWidget[] themeableWidgets) {
        this.valuesMap = new ThemeCssValuesMap();
        int i = 0;
        while (i < themeableWidgets.length) {
            ThemeableWidget themeableWidget = themeableWidgets[i];
            IThemeCssElement[] elements = themeableWidget.elements;
            if (themeableWidget.elements != null) {
                int j = 0;
                while (j < elements.length) {
                    this.valuesMap.initElement(elements[j], this.styleSheet);
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setJsId(String jsId) {
        this.jsId = jsId;
    }

    public String getName() {
        return this.name;
    }

    public String getJsId() {
        return this.jsId;
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public QxType[] getValues() {
        return this.values;
    }

    public ThemeCssValuesMap getValuesMap() {
        return this.valuesMap;
    }

    public static String createCssKey(QxType value) {
        String result = value instanceof QxIdentifier || value instanceof QxBoolean ? value.toDefaultString() : Integer.toHexString(value.hashCode());
        return result;
    }

    private void checkName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("empty argument");
        }
    }

    private void readValuesFromStyleSheet() {
        HashSet<QxType> valueSet = new HashSet<QxType>();
        StyleRule[] styleRules = this.styleSheet.getStyleRules();
        int i = 0;
        while (i < styleRules.length) {
            StyleRule styleRule = styleRules[i];
            IStylePropertyMap propertyMap = styleRule.getProperties();
            String[] propertyNames = propertyMap.getProperties();
            int j = 0;
            while (j < propertyNames.length) {
                String propertyName = propertyNames[j];
                QxType value = propertyMap.getValue(propertyName);
                if (value != null) {
                    valueSet.add(value);
                }
                ++j;
            }
            ++i;
        }
        this.values = valueSet.toArray(new QxType[valueSet.size()]);
    }
}

