/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.rwt.internal.theme.css.StyleSheet;

public class ThemeCssValuesMap {
    private final Map map = new HashMap();

    public void initElement(IThemeCssElement element, StyleSheet styleSheet) {
        String elementName = element.getName();
        String[] properties = element.getProperties();
        int i = 0;
        while (i < properties.length) {
            String propertyName = properties[i];
            ConditionalValue[] values = styleSheet.getValues(elementName, propertyName);
            ConditionalValue[] filteredValues = this.filterValues(values, element);
            this.add(elementName, propertyName, filteredValues);
            ++i;
        }
    }

    public ConditionalValue[] getValues(String elementName, String propertyName) {
        ConditionalValue[] result = (ConditionalValue[])this.map.get(new Key(elementName, propertyName));
        if (result == null) {
            result = (ConditionalValue[])this.map.get(new Key("*", propertyName));
        }
        return result;
    }

    private ConditionalValue[] filterValues(ConditionalValue[] values, IThemeCssElement element) {
        ArrayList<ConditionalValue> resultList = new ArrayList<ConditionalValue>();
        Object[] latestConstraint = null;
        int j = 0;
        while (j < values.length) {
            ConditionalValue value = values[j];
            if (!Arrays.equals(latestConstraint, value.constraints) && ThemeCssValuesMap.matches(element, value.constraints)) {
                resultList.add(value);
                latestConstraint = value.constraints;
            }
            ++j;
        }
        ConditionalValue[] result = new ConditionalValue[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    private void add(String elementName, String propertyName, ConditionalValue[] values) {
        this.map.put(new Key(elementName, propertyName), values);
    }

    private static boolean matches(IThemeCssElement element, String[] constraints) {
        boolean passed = true;
        if (!"*".equals(element.getName())) {
            int k = 0;
            while (k < constraints.length && passed) {
                String constraint = constraints[k];
                if (constraint.charAt(0) == ':') {
                    passed &= ThemeCssValuesMap.contains(element.getStates(), constraint.substring(1));
                } else if (constraint.charAt(0) == '[') {
                    passed &= ThemeCssValuesMap.contains(element.getStyles(), constraint.substring(1));
                }
                ++k;
            }
        }
        return passed;
    }

    private static boolean contains(String[] elements, String string) {
        boolean result = false;
        int i = 0;
        while (i < elements.length && !result) {
            if (string.equals(elements[i])) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private static class Key {
        private final String element;
        private final String property;
        private final int hashCode;

        public Key(String element, String property) {
            this.element = element;
            this.property = property;
            this.hashCode = element.hashCode() ^ property.hashCode();
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj.getClass() == this.getClass()) {
                Key other = (Key)obj;
                result = this.element.equals(other.element) && this.property.equals(other.property);
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

