/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme.css;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.rwt.internal.theme.css.IStylePropertyMap;
import org.eclipse.rwt.internal.theme.css.SelectorExt;
import org.eclipse.rwt.internal.theme.css.Specific;
import org.eclipse.rwt.internal.theme.css.StyleRule;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public final class StyleSheet {
    private static final SelectorWrapperComparator COMPARATOR = new SelectorWrapperComparator();
    private final StyleRule[] styleRules;
    private SelectorWrapper[] selectorWrappers;

    public StyleSheet(StyleRule[] styleRules) {
        this.styleRules = styleRules;
        this.createSelectorWrappers();
    }

    public StyleRule[] getStyleRules() {
        return this.styleRules;
    }

    public ConditionalValue[] getValues(String elementName, String propertyName) {
        ArrayList<ConditionalValue> buffer = new ArrayList<ConditionalValue>();
        int i = 0;
        while (i < this.selectorWrappers.length) {
            QxType value;
            SelectorWrapper selectorWrapper = this.selectorWrappers[i];
            String selectorElement = ((SelectorExt)((Object)selectorWrapper.selector)).getElementName();
            if ((selectorElement == null || selectorElement.equals(elementName)) && (value = selectorWrapper.propertyMap.getValue(propertyName)) != null) {
                String[] constraints = ((SelectorExt)((Object)selectorWrapper.selector)).getConstraints();
                ConditionalValue condValue = new ConditionalValue(constraints, value);
                buffer.add(condValue);
            }
            ++i;
        }
        ConditionalValue[] result = new ConditionalValue[buffer.size()];
        buffer.toArray(result);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        StyleRule[] styleRules = this.getStyleRules();
        int i = 0;
        while (i < styleRules.length) {
            StyleRule styleRule = styleRules[i];
            SelectorList selectors = styleRule.getSelectors();
            int length = selectors.getLength();
            int j = 0;
            while (j < length) {
                if (j > 0) {
                    buffer.append(",");
                }
                if (i > 0) {
                    buffer.append("\n");
                }
                buffer.append(selectors.item(j));
                ++j;
            }
            buffer.append("\n");
            buffer.append(styleRule.getProperties());
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    private void createSelectorWrappers() {
        ArrayList<SelectorWrapper> selectorWrappersList = new ArrayList<SelectorWrapper>();
        int i_rule = 0;
        while (i_rule < this.styleRules.length) {
            StyleRule styleRule = this.styleRules[i_rule];
            SelectorList selectors = styleRule.getSelectors();
            IStylePropertyMap properties = styleRule.getProperties();
            int length = selectors.getLength();
            int i_sel = 0;
            while (i_sel < length) {
                Selector selector = selectors.item(i_sel);
                SelectorWrapper selectorWrapper = new SelectorWrapper(selector, properties, i_rule);
                selectorWrappersList.add(selectorWrapper);
                ++i_sel;
            }
            ++i_rule;
        }
        Collections.sort(selectorWrappersList, COMPARATOR);
        Collections.reverse(selectorWrappersList);
        this.selectorWrappers = new SelectorWrapper[selectorWrappersList.size()];
        selectorWrappersList.toArray(this.selectorWrappers);
    }

    static class SelectorWrapper {
        public final Selector selector;
        public final IStylePropertyMap propertyMap;
        public final int position;

        public SelectorWrapper(Selector selector, IStylePropertyMap propertyMap, int position) {
            this.selector = selector;
            this.position = position;
            this.propertyMap = propertyMap;
        }
    }

    private static class SelectorWrapperComparator
    implements Comparator {
        private SelectorWrapperComparator() {
        }

        public int compare(Object object1, Object object2) {
            int specificity2;
            int result = 0;
            SelectorWrapper selectorWrapper1 = (SelectorWrapper)object1;
            SelectorWrapper selectorWrapper2 = (SelectorWrapper)object2;
            int specificity1 = ((Specific)((Object)selectorWrapper1.selector)).getSpecificity();
            if (specificity1 > (specificity2 = ((Specific)((Object)selectorWrapper2.selector)).getSpecificity())) {
                result = 1;
            } else if (specificity1 < specificity2) {
                result = -1;
            } else if (selectorWrapper1.position > selectorWrapper2.position) {
                result = 1;
            } else if (selectorWrapper1.position < selectorWrapper2.position) {
                result = -1;
            }
            return result;
        }
    }
}

