/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.custom.ccombokit.CComboThemeAdapter;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.ListModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class CCombo
extends Composite {
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    private static final int LIST_ITEM_PADDING = 3;
    private static final double LINE_HEIGHT_FACTOR = 1.2;
    public static final int LIMIT = Integer.MAX_VALUE;
    private final ListModel model;
    private String text = "";
    private int textLimit = Integer.MAX_VALUE;
    private final Point selection = new Point(0, 0);
    private int visibleCount = 5;
    private boolean editable;
    private boolean dropped = false;
    static /* synthetic */ Class class$0;

    public CCombo(Composite parent, int style) {
        super(parent, CCombo.checkStyle(style));
        this.editable = (style & 8) == 0;
        this.model = new ListModel(true);
    }

    public int getStyle() {
        int result = super.getStyle();
        result &= 0xFFFFFFF7;
        if (!this.editable) {
            result |= 8;
        }
        return result;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.model.getSelectionIndex();
    }

    public void select(int index) {
        this.checkWidget();
        this.model.setSelection(index);
        this.updateText();
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index == this.model.getSelectionIndex()) {
            this.model.setSelection(-1);
        }
        this.updateText();
    }

    public void deselectAll() {
        this.checkWidget();
        this.text = "";
        this.model.deselectAll();
        this.updateText();
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error(4);
        }
        int validatedStart = this.selection.x;
        int validatedEnd = this.selection.y;
        int start = selection.x;
        int end = selection.y;
        if (start >= 0 && end >= start) {
            validatedStart = Math.min(start, this.text.length());
            validatedEnd = Math.min(end, this.text.length());
        } else if (end >= 0 && start > end) {
            validatedStart = Math.min(end, this.text.length());
            validatedEnd = Math.min(start, this.text.length());
        }
        this.selection.x = validatedStart;
        this.selection.y = validatedEnd;
    }

    public Point getSelection() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            SWT.error(7);
        }
        this.textLimit = limit > 0 ? limit : Integer.MAX_VALUE;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTextHeight() {
        this.checkWidget();
        Font font = this.getFont();
        int fontSize = font.getFontData()[0].getHeight();
        return (int)Math.floor((double)fontSize * 1.2);
    }

    public void clearSelection() {
        this.checkWidget();
        this.selection.x = 0;
        this.selection.y = 0;
    }

    public void add(String string) {
        this.checkWidget();
        this.model.add(string);
    }

    public void add(String string, int index) {
        this.checkWidget();
        this.model.add(string, index);
    }

    public void remove(int index) {
        this.checkWidget();
        int selectionIndex = this.getSelectionIndex();
        if (selectionIndex == index) {
            this.deselect(index);
        }
        this.model.remove(index);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        int selectionIndex = this.getSelectionIndex();
        String[] items = this.model.getItems();
        int i = start;
        while (i <= end) {
            int indexTemp = this.indexOf(items[i]);
            if (selectionIndex == indexTemp) {
                this.deselect(indexTemp);
            }
            ++i;
        }
        this.model.remove(start, end);
    }

    public void remove(String string) {
        this.checkWidget();
        int indexOfThisString = this.indexOf(string);
        int selectionIndex = this.getSelectionIndex();
        if (selectionIndex == indexOfThisString) {
            this.deselect(indexOfThisString);
        }
        this.model.remove(string);
    }

    public void removeAll() {
        this.checkWidget();
        this.deselectAll();
        this.model.removeAll();
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        this.model.setItem(index, string);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        this.model.setItems(items);
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.model.getItem(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.model.getItemCount();
    }

    public int getItemHeight() {
        this.checkWidget();
        int charHeight = TextSizeDetermination.getCharHeight(this.getFont());
        int padding = 6;
        return charHeight + padding;
    }

    public String[] getItems() {
        this.checkWidget();
        return this.model.getItems();
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count >= 0) {
            this.visibleCount = count;
        }
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    public void setListVisible(boolean visible) {
        this.checkWidget();
        this.dropped = visible;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.dropped;
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (start < 0 || start >= this.model.getItemCount()) {
            return -1;
        }
        int i = start;
        while (i < this.model.getItemCount()) {
            if (string.equals(this.model.getItem(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setText(String string) {
        String verifiedText;
        int style;
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (((style = super.getStyle()) & 8) != 0) {
            int index = this.indexOf(string);
            if (index == -1) {
                return;
            }
            this.select(index);
        }
        if ((verifiedText = this.verifyText(string, 0, this.text.length())) != null) {
            this.model.deselectAll();
            String[] items = this.model.getItems();
            int i = 0;
            while (i < items.length) {
                if (verifiedText.equals(items[i])) {
                    this.model.setSelection(i);
                    break;
                }
                ++i;
            }
            this.text = verifiedText.length() > this.textLimit ? verifiedText.substring(0, this.textLimit) : verifiedText;
            this.fireModifyEvent();
        }
    }

    public String getText() {
        this.checkWidget();
        String result = "";
        int style = super.getStyle();
        if ((style & 8) != 0) {
            int idx = this.model.getSelectionIndex();
            if (idx != -1) {
                result = this.model.getItem(idx);
            }
        } else {
            result = this.text;
        }
        return result;
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.editable = editable;
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.editable;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = TextSizeDetermination.getCharHeight(this.getFont());
        if (wHint == -1 || hHint == -1) {
            String[] items = this.model.getItems();
            int i = 0;
            while (i < items.length) {
                if (!"".equals(items[i])) {
                    Point extent = TextSizeDetermination.stringExtent(this.getFont(), items[i]);
                    width = Math.max(width, extent.x + 10);
                }
                ++i;
            }
        }
        Rectangle padding = this.getPadding();
        int buttonWidth = this.getButtonWidth();
        if (width != 0) {
            width += padding.width + buttonWidth;
        }
        if (height != 0) {
            height += padding.height;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += 2 * border, height += 2 * border);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        ModifyEvent.addListener(this, listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        ModifyEvent.removeListener(this, listener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        VerifyEvent.addListener(this, verifyListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        VerifyEvent.removeListener(this, verifyListener);
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    private String verifyText(String text, int start, int end) {
        VerifyEvent event = new VerifyEvent(this);
        event.text = text;
        event.start = start;
        event.end = end;
        event.processEvent();
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        String result = event.text;
        return result;
    }

    private void updateText() {
        int style = super.getStyle();
        if ((style & 8) == 0) {
            int selectionIndex = this.getSelectionIndex();
            if (selectionIndex != -1) {
                this.setText(this.getItem(selectionIndex));
            } else {
                this.setText("");
            }
        } else {
            this.fireModifyEvent();
        }
    }

    private void fireModifyEvent() {
        ModifyEvent modifyEvent = new ModifyEvent(this);
        modifyEvent.processEvent();
    }

    private Rectangle getPadding() {
        ThemeManager manager = ThemeManager.getInstance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.custom.CCombo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CComboThemeAdapter adapter = (CComboThemeAdapter)manager.getThemeAdapter(clazz);
        return adapter.getPadding(this);
    }

    private int getButtonWidth() {
        ThemeManager manager = ThemeManager.getInstance();
        CComboThemeAdapter adapter = (CComboThemeAdapter)manager.getThemeAdapter(this.getClass());
        return adapter.getButtonWidth(this);
    }

    private static int checkStyle(int style) {
        int mask = 0x2800808;
        return style & mask;
    }
}

