/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;

public class CTabItem
extends Item {
    static final int TOP_MARGIN = 2;
    static final int BOTTOM_MARGIN = 2;
    static final int LEFT_MARGIN = 4;
    static final int RIGHT_MARGIN = 4;
    static final int INTERNAL_SPACING = 4;
    static final String ELLIPSIS = "...";
    private final IWidgetFontAdapter widgetFontAdapter;
    final CTabFolder parent;
    private Control control;
    private String toolTipText;
    private Font font;
    String shortenedText;
    int shortenedTextWidth;
    boolean showing = false;
    boolean showClose;
    int x;
    int y;
    int width;
    int height;
    Rectangle closeRect = new Rectangle(0, 0, 0, 0);
    static /* synthetic */ Class class$0;

    public CTabItem(CTabFolder parent, int style) {
        this(parent, style, CTabItem.checkNull(parent).getItemCount());
    }

    public CTabItem(CTabFolder parent, int style, int index) {
        super(parent, CTabItem.checkStyle(style));
        this.showClose = (style & 0x40) != 0;
        this.parent = parent;
        this.widgetFontAdapter = new IWidgetFontAdapter(){

            public Font getUserFont() {
                return CTabItem.this.font;
            }
        };
        parent.createItem(this, index);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetFontAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object result = adapter == clazz ? this.widgetFontAdapter : super.getAdapter(adapter);
        return result;
    }

    public CTabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error(4);
        }
        if (!text.equals(this.getText())) {
            super.setText(text);
            this.shortenedText = null;
            this.shortenedTextWidth = 0;
            this.parent.updateItems();
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != this.getImage()) {
            super.setImage(image);
            if (!this.parent.updateTabHeight(false)) {
                this.parent.updateItems();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != this.font) {
            this.font = font;
            if (!this.parent.updateTabHeight(false)) {
                this.parent.updateItems();
            }
        }
    }

    public Font getFont() {
        this.checkWidget();
        Font result = this.font;
        if (this.font == null) {
            result = this.parent.getFont();
        }
        return result;
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                SWT.error(5);
            }
            if (control.getParent() != this.parent) {
                SWT.error(32);
            }
        }
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setVisible(false);
        }
        this.control = control;
        if (this.control != null) {
            int index = this.parent.indexOf(this);
            if (index == this.parent.getSelectionIndex()) {
                this.control.setBounds(this.parent.getClientArea());
                this.control.setVisible(true);
            } else {
                this.control.setVisible(false);
            }
        }
    }

    public void setToolTipText(String toolTipText) {
        this.checkWidget();
        this.toolTipText = toolTipText;
    }

    public String getToolTipText() {
        String text;
        this.checkWidget();
        String result = this.toolTipText;
        if (result == null && this.shortenedText != null && !this.shortenedText.equals(text = this.getText())) {
            result = text;
        }
        return result;
    }

    public void setShowClose(boolean close) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x40) == 0 && this.showClose != close) {
            this.showClose = close;
            this.parent.updateItems();
        }
    }

    public boolean getShowClose() {
        this.checkWidget();
        return this.showClose;
    }

    public boolean isShowing() {
        this.checkWidget();
        return this.showing;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.parent.destroyItem(this);
            super.dispose();
        }
    }

    int preferredHeight() {
        Image image = this.getImage();
        int h = image == null ? 0 : image.getBounds().height;
        String text = this.getText();
        if (this.font == null) {
            Font parentFont = this.getParent().getFont();
            h = Math.max(h, TextSizeDetermination.textExtent((Font)parentFont, (String)text, (int)0).y);
        } else {
            h = Math.max(h, TextSizeDetermination.textExtent((Font)this.font, (String)text, (int)0).y);
        }
        return h + 2 + 2;
    }

    int preferredWidth(boolean isSelected, boolean minimum) {
        if (this.isDisposed()) {
            return 0;
        }
        int w = 0;
        Image image = this.getImage();
        if (image != null && (isSelected || this.parent.showUnselectedImage)) {
            w += image.getBounds().width;
        }
        String text = null;
        if (minimum) {
            int minChars = this.parent.minChars;
            String string = text = minChars == 0 ? null : this.getText();
            if (text != null && text.length() > minChars) {
                if (this.useEllipses()) {
                    int end = minChars < ELLIPSIS.length() + 1 ? minChars : minChars - ELLIPSIS.length();
                    text = text.substring(0, end);
                    if (minChars > ELLIPSIS.length() + 1) {
                        text = String.valueOf(text) + ELLIPSIS;
                    }
                } else {
                    int end = minChars;
                    text = text.substring(0, end);
                }
            }
        } else {
            text = this.getText();
        }
        if (text != null) {
            if (w > 0) {
                w += 4;
            }
            w = this.font == null ? (w += TextSizeDetermination.stringExtent((Font)this.getFont(), (String)text).x) : (w += TextSizeDetermination.stringExtent((Font)this.getFont(), (String)text).x);
        }
        if ((this.parent.showClose || this.showClose) && (isSelected || this.parent.showUnselectedClose)) {
            if (w > 0) {
                w += 4;
            }
            w += 18;
        }
        return w + 4 + 4;
    }

    boolean useEllipses() {
        return this.parent.simple;
    }

    boolean showImage() {
        boolean result = false;
        if (this.parent.getSelection() == this) {
            Image image;
            int rightEdge = Math.min(this.x + this.width, this.parent.getRightItemEdge());
            int xDraw = this.x + 4;
            if (this.parent.single && (this.parent.showClose || this.showClose)) {
                xDraw += 18;
            }
            if ((image = this.getImage()) != null) {
                Rectangle imageBounds = image.getBounds();
                int maxImageWidth = rightEdge - xDraw - 4;
                if (!this.parent.single && this.closeRect.width > 0) {
                    maxImageWidth -= this.closeRect.width + 4;
                }
                if (imageBounds.width < maxImageWidth) {
                    result = true;
                }
            }
        } else {
            int xDraw = this.x + 4;
            Image image = this.getImage();
            if (image != null && this.parent.showUnselectedImage) {
                Rectangle imageBounds = image.getBounds();
                int maxImageWidth = this.x + this.width - xDraw - 4;
                if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
                    maxImageWidth -= this.closeRect.width + 4;
                }
                if (imageBounds.width < maxImageWidth) {
                    result = true;
                }
            }
        }
        return result;
    }

    String getShortenedText() {
        if (this.shortenedText == null) {
            int xDraw = this.x + 4;
            if (this.showImage()) {
                Rectangle imageBounds = this.getImage().getBounds();
                xDraw += imageBounds.width + 4;
            }
            int rightEdge = Math.min(this.x + this.width, this.parent.getRightItemEdge());
            int textWidth = rightEdge - xDraw - 4;
            if (!this.parent.single && this.closeRect.width > 0) {
                textWidth -= this.closeRect.width + 4;
            }
            if (textWidth > 0) {
                Font itemFont;
                Font font = itemFont = this.font == null ? this.parent.getFont() : this.font;
                if (this.shortenedText == null || this.shortenedTextWidth != textWidth) {
                    this.shortenedText = this.shortenText(itemFont, this.getText(), textWidth);
                    this.shortenedTextWidth = textWidth;
                }
            }
        }
        return this.shortenedText == null ? "" : this.shortenedText;
    }

    String shortenText(Font font, String text, int width) {
        return this.useEllipses() ? CTabItem.shortenText(font, text, width, ELLIPSIS) : CTabItem.shortenText(font, text, width, "");
    }

    static String shortenText(Font font, String text, int width, String ellipses) {
        if (Graphics.stringExtent((Font)font, (String)text).x <= width) {
            return text;
        }
        int ellipseWidth = Graphics.stringExtent((Font)font, (String)ellipses).x;
        int length = text.length();
        int end = length - 1;
        while (end > 0) {
            text = text.substring(0, end);
            int l = Graphics.stringExtent((Font)font, (String)text).x;
            if (l + ellipseWidth <= width) {
                return String.valueOf(text) + ellipses;
            }
            --end;
        }
        return text.substring(0, 1);
    }

    private static CTabFolder checkNull(CTabFolder parent) {
        if (parent == null) {
            SWT.error(4);
        }
        return parent;
    }

    private static int checkStyle(int style) {
        int result = 0;
        if ((style & 0x40) != 0) {
            result = 64;
        }
        return result;
    }
}

