/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import org.eclipse.rwt.internal.resources.ResourceManager;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.graphics.ImageData;
import org.eclipse.swt.internal.graphics.ImageDataCache;
import org.eclipse.swt.internal.graphics.ImageLoader;

public final class ResourceFactory {
    private static final Map colors = new HashMap();
    private static final Map fonts = new HashMap();
    private static final Map images = new HashMap();
    private static final Map cursors = new HashMap();
    private static final ImageDataCache imageDataCache = new ImageDataCache();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public static Color getColor(RGB rgb) {
        if (rgb == null) {
            SWT.error(4);
        }
        return ResourceFactory.getColor(rgb.red, rgb.green, rgb.blue);
    }

    public static Color getColor(int red, int green, int blue) {
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
            SWT.error(5);
        }
        int colorNr = red | green << 8 | blue << 16;
        return ResourceFactory.getColor(colorNr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Color getColor(int value) {
        Color result;
        Integer key = new Integer(value);
        Map map = colors;
        synchronized (map) {
            if (colors.containsKey(key)) {
                result = (Color)colors.get(key);
            } else {
                result = ResourceFactory.createColorInstance(value);
                colors.put(key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font getFont(String name, int height, int style) {
        ResourceFactory.validateFontParams(name, height);
        int checkedStyle = ResourceFactory.checkFontStyle(style);
        Integer key = new Integer(ResourceFactory.fontHashCode(name, height, checkedStyle));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Font");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Font result = (Font)fonts.get(key);
            if (result == null) {
                FontData fontData = new FontData(name, height, checkedStyle);
                result = ResourceFactory.createFontInstance(fontData);
                fonts.put(key, result);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return result;
        }
    }

    public static int fontHashCode(String name, int height, int style) {
        return name.hashCode() ^ height << 2 ^ style;
    }

    public static synchronized Image findImage(String path) {
        IResourceManager manager = ResourceManager.getInstance();
        return ResourceFactory.findImage(path, manager.getContextLoader());
    }

    public static synchronized Image findImage(String path, ClassLoader imageLoader) {
        if (path == null) {
            SWT.error(4);
        }
        if ("".equals(path)) {
            SWT.error(5);
        }
        Image result = images.containsKey(path) ? (Image)images.get(path) : ResourceFactory.createImage(path, imageLoader);
        return result;
    }

    public static synchronized Image findImage(String path, InputStream inputStream) {
        if (path == null) {
            SWT.error(4);
        }
        if ("".equals(path)) {
            SWT.error(5);
        }
        Image result = images.containsKey(path) ? (Image)images.get(path) : ResourceFactory.createImage(path, inputStream);
        return result;
    }

    public static synchronized Image findImage(ImageData imageData) {
        if (imageData == null) {
            SWT.error(4);
        }
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{imageData};
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int type = imageData.type != -1 ? imageData.type : 5;
        loader.save(outputStream, type);
        byte[] byteArray = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
        String path = "generated/" + ResourceFactory.hashCode(byteArray) + ResourceFactory.getImageFileExtension(type);
        Image result = images.containsKey(path) ? (Image)images.get(path) : ResourceFactory.createImage(path, inputStream);
        return result;
    }

    public static String getImagePath(Image image) {
        String result = ResourceFactory.getImageName(image);
        if (result != null) {
            result = ResourceManager.getInstance().getLocation(result);
        }
        return result;
    }

    private static synchronized String getImageName(Image image) {
        String result = null;
        Iterator it = images.entrySet().iterator();
        boolean found = false;
        while (!found && it.hasNext()) {
            Map.Entry entry = it.next();
            if (!entry.getValue().equals(image)) continue;
            result = (String)entry.getKey();
            found = true;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageData getImageData(Image image) {
        ImageData result = imageDataCache.getImageData(image);
        if (result == null) {
            block8: {
                IResourceManager manager = ResourceManager.getInstance();
                String imagePath = ResourceFactory.getImageName(image);
                if (imagePath != null) {
                    try {
                        InputStream inputStream = manager.getRegisteredContent(imagePath);
                        if (inputStream == null) break block8;
                        try {
                            result = new ImageData(inputStream);
                        }
                        catch (Throwable throwable) {
                            Object var5_7 = null;
                            inputStream.close();
                            throw throwable;
                        }
                        {
                            Object var5_8 = null;
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (result != null) {
                imageDataCache.putImageData(image, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cursor getCursor(int style) {
        Integer key = new Integer(style);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Cursor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Cursor result = (Cursor)cursors.get(key);
            if (result == null) {
                result = ResourceFactory.createCursorInstance(style);
                cursors.put(key, result);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return result;
        }
    }

    public static void clear() {
        colors.clear();
        fonts.clear();
        images.clear();
        cursors.clear();
    }

    static int colorsCount() {
        return colors.size();
    }

    static int fontsCount() {
        return fonts.size();
    }

    static int imagesCount() {
        return images.size();
    }

    static int cursorsCount() {
        return cursors.size();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Image createImage(String path, ClassLoader imageLoader) {
        Image result;
        IResourceManager manager = ResourceManager.getInstance();
        ClassLoader loaderBuffer = manager.getContextLoader();
        if (imageLoader != null) {
            manager.setContextLoader(imageLoader);
        }
        try {
            InputStream inputStream = manager.getResourceAsStream(path);
            result = ResourceFactory.createImage(path, inputStream);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            manager.setContextLoader(loaderBuffer);
            throw throwable;
        }
        {
            Object var6_8 = null;
            manager.setContextLoader(loaderBuffer);
            return result;
        }
    }

    private static Image createImage(String path, InputStream inputStream) {
        if (inputStream == null) {
            String txt = "Image ''{0}'' cannot be found.";
            String msg = MessageFormat.format(txt, path);
            SWT.error(5, new IllegalArgumentException(msg), msg);
        }
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        bis.mark(Integer.MAX_VALUE);
        Point size = null;
        try {
            size = ResourceFactory.readImageSize(bis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Image result = size != null ? ResourceFactory.createImageInstance(size.x, size.y) : ResourceFactory.createImageInstance(-1, -1);
        try {
            bis.reset();
        }
        catch (IOException shouldNotHappen) {
            String txt = "Could not reset input stream while reading image ''{0}''.";
            String msg = MessageFormat.format(txt, path);
            throw new RuntimeException(msg, shouldNotHappen);
        }
        IResourceManager manager = ResourceManager.getInstance();
        manager.register(path, bis);
        images.put(path, result);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Point readImageSize(InputStream input) throws IOException {
        Point result = null;
        boolean cacheBuffer = ImageIO.getUseCache();
        try {
            ImageIO.setUseCache(false);
            BufferedImage image = ImageIO.read(input);
            if (image != null) {
                int width = image.getWidth();
                int height = image.getHeight();
                result = new Point(width, height);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ImageIO.setUseCache(cacheBuffer);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        ImageIO.setUseCache(cacheBuffer);
        return result;
    }

    private static void validateFontParams(String name, int height) {
        if (name == null) {
            SWT.error(4);
        }
        if (height < 0) {
            SWT.error(5);
        }
    }

    private static int checkFontStyle(int style) {
        int result = 0;
        if ((style & 1) != 0) {
            result |= 1;
        }
        if ((style & 2) != 0) {
            result |= 2;
        }
        return result;
    }

    private static String getImageFileExtension(int type) {
        String result;
        switch (type) {
            case 0: 
            case 1: 
            case 7: {
                result = ".bmp";
                break;
            }
            case 2: {
                result = ".gif";
                break;
            }
            case 3: {
                result = ".ico";
                break;
            }
            case 4: {
                result = ".jpg";
                break;
            }
            case 5: {
                result = ".png";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    private static int hashCode(byte[] bytes) {
        int result;
        if (bytes == null) {
            result = 0;
        } else {
            result = 1;
            int i = 0;
            while (i < bytes.length) {
                result = 31 * result + bytes[i];
                ++i;
            }
        }
        return result;
    }

    private static Color createColorInstance(int colorNr) {
        Color result = null;
        try {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.swt.graphics.Color");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> colorClass = clazz;
            Class<?>[] classes = colorClass.getDeclaredClasses();
            Class<?> colorExtClass = classes[0];
            Class[] paramList = new Class[]{Integer.TYPE};
            Constructor<?> constr = colorExtClass.getDeclaredConstructor(paramList);
            constr.setAccessible(true);
            Object[] args = new Object[]{new Integer(colorNr)};
            result = (Color)constr.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate Color", e);
        }
        return result;
    }

    private static Font createFontInstance(FontData fontData) {
        Font result = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Font");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> fontClass = clazz;
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.swt.graphics.FontData");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class[] paramList = classArray;
            Constructor<?> constr = fontClass.getDeclaredConstructor(paramList);
            constr.setAccessible(true);
            result = (Font)constr.newInstance(fontData);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate Font", e);
        }
        return result;
    }

    private static Image createImageInstance(int width, int height) {
        Image result = null;
        try {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.swt.graphics.Image");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> imageClass = clazz;
            Class[] paramList = new Class[]{Integer.TYPE, Integer.TYPE};
            Constructor<?> constr = imageClass.getDeclaredConstructor(paramList);
            constr.setAccessible(true);
            result = (Image)constr.newInstance(new Integer(width), new Integer(height));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate Image", e);
        }
        return result;
    }

    private static Cursor createCursorInstance(int style) {
        Cursor result = null;
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Cursor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> cursorClass = clazz;
            Class[] paramList = new Class[]{Integer.TYPE};
            Constructor<?> constr = cursorClass.getDeclaredConstructor(paramList);
            constr.setAccessible(true);
            result = (Cursor)constr.newInstance(new Integer(style));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate Cursor", e);
        }
        return result;
    }

    private ResourceFactory() {
    }
}

