/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rwt.Adaptable;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.internal.events.ActivateEvent;
import org.eclipse.swt.internal.events.ActivateListener;
import org.eclipse.swt.internal.events.SetDataEvent;
import org.eclipse.swt.internal.events.SetDataListener;
import org.eclipse.swt.internal.events.ShowEvent;
import org.eclipse.swt.internal.events.ShowListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class UntypedEventAdapter
implements ControlListener,
DisposeListener,
SelectionListener,
FocusListener,
TreeListener,
ShellListener,
MenuListener,
ModifyListener,
SetDataListener,
VerifyListener,
MouseListener,
KeyListener,
TraverseListener,
ShowListener,
ActivateListener,
HelpListener {
    private final List listeners = new ArrayList();

    public void controlMoved(ControlEvent evt) {
        Event event = UntypedEventAdapter.createEvent(10, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void controlResized(ControlEvent evt) {
        Event event = UntypedEventAdapter.createEvent(11, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void widgetDisposed(DisposeEvent evt) {
        Event event = UntypedEventAdapter.createEvent(12, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void widgetDefaultSelected(SelectionEvent evt) {
        Event event = UntypedEventAdapter.createEvent(14, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void widgetSelected(SelectionEvent evt) {
        Event event = UntypedEventAdapter.createEvent(13, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void focusGained(FocusEvent evt) {
        Event event = UntypedEventAdapter.createEvent(15, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void focusLost(FocusEvent evt) {
        Event event = UntypedEventAdapter.createEvent(16, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void treeCollapsed(TreeEvent evt) {
        Event event = UntypedEventAdapter.createEvent(18, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void treeExpanded(TreeEvent evt) {
        Event event = UntypedEventAdapter.createEvent(17, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void shellActivated(ShellEvent evt) {
        Event event = UntypedEventAdapter.createEvent(26, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void shellClosed(ShellEvent evt) {
        Event event = UntypedEventAdapter.createEvent(21, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void shellDeactivated(ShellEvent evt) {
        Event event = UntypedEventAdapter.createEvent(27, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void menuHidden(MenuEvent evt) {
        Event event = UntypedEventAdapter.createEvent(23, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void menuShown(MenuEvent evt) {
        Event event = UntypedEventAdapter.createEvent(22, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void modifyText(ModifyEvent evt) {
        Event event = UntypedEventAdapter.createEvent(24, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void verifyText(VerifyEvent evt) {
        Event event = UntypedEventAdapter.createEvent(25, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void update(SetDataEvent evt) {
        Event event = UntypedEventAdapter.createEvent(36, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void mouseDown(MouseEvent evt) {
        Event event = UntypedEventAdapter.createEvent(3, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void mouseUp(MouseEvent evt) {
        Event event = UntypedEventAdapter.createEvent(4, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void mouseDoubleClick(MouseEvent evt) {
        Event event = UntypedEventAdapter.createEvent(8, evt.getSource());
        UntypedEventAdapter.copyFields(evt, event);
        this.dispatchEvent(event);
    }

    public void keyPressed(KeyEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(1, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
        typedEvent.doit = event.doit;
    }

    public void keyReleased(KeyEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(2, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void keyTraversed(TraverseEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(31, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
        typedEvent.doit = event.doit;
    }

    public void controlShown(ShowEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(22, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void controlHidden(ShowEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(23, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void activated(ActivateEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(26, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void deactivated(ActivateEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(27, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void helpRequested(HelpEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(28, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void addListener(Widget widget, int eventType, Listener listener) {
        boolean validEventType = true;
        switch (eventType) {
            case 10: 
            case 11: {
                ControlEvent.addListener(widget, this);
                break;
            }
            case 12: {
                DisposeEvent.addListener(widget, this);
                break;
            }
            case 13: 
            case 14: {
                SelectionEvent.addListener(widget, this);
                break;
            }
            case 15: 
            case 16: {
                FocusEvent.addListener(widget, this);
                break;
            }
            case 17: 
            case 18: {
                TreeEvent.addListener((Adaptable)widget, this);
                break;
            }
            case 26: 
            case 27: {
                if (widget instanceof Shell) {
                    ShellEvent.addListener(widget, this);
                    break;
                }
                ActivateEvent.addListener(widget, this);
                break;
            }
            case 21: {
                ShellEvent.addListener(widget, this);
                break;
            }
            case 23: {
                if (widget instanceof Control) {
                    ShowEvent.addListener(widget, this);
                    break;
                }
                MenuEvent.addListener(widget, this);
                break;
            }
            case 22: {
                if (widget instanceof Control) {
                    ShowEvent.addListener(widget, this);
                    break;
                }
                MenuEvent.addListener(widget, this);
                break;
            }
            case 24: {
                ModifyEvent.addListener(widget, this);
                break;
            }
            case 25: {
                VerifyEvent.addListener(widget, this);
                break;
            }
            case 36: {
                SetDataEvent.addListener(widget, this);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                MouseEvent.addListener(widget, this);
                break;
            }
            case 1: 
            case 2: {
                KeyEvent.addListener(widget, this);
                break;
            }
            case 31: {
                TraverseEvent.addListener((Adaptable)widget, this);
                break;
            }
            default: {
                validEventType = false;
            }
        }
        if (validEventType) {
            this.addListener(eventType, listener);
        }
    }

    void addListener(int eventType, Listener listener) {
        this.listeners.add(new Entry(eventType, listener));
    }

    public void removeListener(Widget widget, int eventType, Listener listener) {
        boolean validEventType = true;
        switch (eventType) {
            case 10: 
            case 11: {
                ControlEvent.removeListener(widget, this);
                break;
            }
            case 12: {
                DisposeEvent.removeListener(widget, this);
                break;
            }
            case 13: 
            case 14: {
                SelectionEvent.removeListener(widget, this);
                break;
            }
            case 15: 
            case 16: {
                FocusEvent.removeListener(widget, this);
                break;
            }
            case 17: 
            case 18: {
                TreeEvent.removeListener((Adaptable)widget, this);
                break;
            }
            case 26: 
            case 27: {
                if (widget instanceof Shell) {
                    ShellEvent.removeListener(widget, this);
                    break;
                }
                ActivateEvent.removeListener(widget, this);
                break;
            }
            case 21: {
                ShellEvent.removeListener(widget, this);
                break;
            }
            case 23: {
                if (widget instanceof Control) {
                    ShowEvent.removeListener(widget, this);
                    break;
                }
                MenuEvent.removeListener(widget, this);
                break;
            }
            case 22: {
                if (widget instanceof Control) {
                    ShowEvent.removeListener(widget, this);
                    break;
                }
                MenuEvent.removeListener(widget, this);
                break;
            }
            case 24: {
                ModifyEvent.removeListener(widget, this);
                break;
            }
            case 25: {
                VerifyEvent.removeListener(widget, this);
                break;
            }
            case 36: {
                SetDataEvent.removeListener(widget, this);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                MouseEvent.removeListener(widget, this);
                break;
            }
            case 1: 
            case 2: {
                KeyEvent.removeListener(widget, this);
                break;
            }
            case 31: {
                TraverseEvent.removeListener((Adaptable)widget, this);
                break;
            }
            default: {
                validEventType = false;
            }
        }
        if (validEventType) {
            this.removeListener(eventType, listener);
        }
    }

    void removeListener(int eventType, Listener listener) {
        Entry[] entries = this.getEntries();
        boolean found = false;
        int i = 0;
        while (!found && i < entries.length) {
            boolean bl = found = entries[i].listener == listener;
            if (found) {
                this.listeners.remove(entries[i]);
            }
            ++i;
        }
    }

    public Listener[] getListeners(int eventType) {
        Entry[] entries = this.getEntries();
        ArrayList<Listener> result = new ArrayList<Listener>();
        int i = 0;
        while (i < entries.length) {
            Entry entry = entries[i];
            if (entry.eventType == eventType) {
                result.add(entry.listener);
            }
            ++i;
        }
        return result.toArray(new Listener[0]);
    }

    public static void notifyListeners(int eventType, Event event) {
        TypedEvent typedEvent = null;
        switch (eventType) {
            case 10: 
            case 11: {
                typedEvent = new ControlEvent(event);
                break;
            }
            case 12: {
                typedEvent = new DisposeEvent(event);
                break;
            }
            case 13: 
            case 14: {
                typedEvent = new SelectionEvent(event);
                break;
            }
            case 15: 
            case 16: {
                typedEvent = new FocusEvent(event);
                break;
            }
            case 17: 
            case 18: {
                typedEvent = new TreeEvent(event);
                break;
            }
            case 26: 
            case 27: {
                if (event.widget instanceof Shell) {
                    typedEvent = new ShellEvent(event);
                    break;
                }
                typedEvent = new ActivateEvent(event);
                break;
            }
            case 21: {
                typedEvent = new ShellEvent(event);
                break;
            }
            case 22: 
            case 23: {
                if (event.widget instanceof Control) {
                    typedEvent = new ShowEvent(event);
                    break;
                }
                typedEvent = new MenuEvent(event);
                break;
            }
            case 24: {
                typedEvent = new ModifyEvent(event);
                break;
            }
            case 25: {
                typedEvent = new VerifyEvent(event);
                break;
            }
            case 36: {
                typedEvent = new SetDataEvent(event);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                typedEvent = new MouseEvent(event);
                break;
            }
            case 1: 
            case 2: {
                typedEvent = new KeyEvent(event);
                break;
            }
            case 31: {
                typedEvent = new TraverseEvent(event);
            }
        }
        if (typedEvent != null) {
            typedEvent.processEvent();
        }
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    private void dispatchEvent(Event event) {
        int eventType = event.type;
        Entry[] entries = this.getEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].eventType == eventType) {
                entries[i].listener.handleEvent(event);
            }
            ++i;
        }
    }

    private Entry[] getEntries() {
        Entry[] result = new Entry[this.listeners.size()];
        this.listeners.toArray(result);
        return result;
    }

    private static Event createEvent(int eventType, Object source) {
        Widget widget = (Widget)source;
        Event result = new Event();
        result.type = eventType;
        result.widget = widget;
        result.display = widget.getDisplay();
        return result;
    }

    private static void copyFields(TypedEvent from, Event to) {
        to.display = from.display;
        to.widget = from.widget;
        to.data = from.data;
    }

    private static void copyFields(SelectionEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.detail = from.detail;
        to.doit = from.doit;
        to.x = from.x;
        to.y = from.y;
        to.width = from.width;
        to.height = from.height;
        to.item = from.item;
        to.text = from.text;
    }

    private static void copyFields(TreeEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.detail = from.detail;
        to.doit = from.doit;
        to.x = from.x;
        to.y = from.y;
        to.height = from.height;
        to.width = from.width;
        to.item = from.item;
        to.text = from.text;
    }

    private static void copyFields(VerifyEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.start = from.start;
        to.end = from.end;
        to.doit = from.doit;
        to.text = from.text;
    }

    private static void copyFields(SetDataEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.index = from.index;
        to.item = from.item;
    }

    private static void copyFields(MouseEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.button = from.button;
        to.time = from.time;
        to.x = from.x;
        to.y = from.y;
    }

    private static void copyFields(ShellEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.doit = from.doit;
    }

    private static void copyFields(KeyEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.character = from.character;
        to.keyCode = from.keyCode;
        to.stateMask = from.stateMask;
        to.doit = from.doit;
    }

    private static void copyFields(TraverseEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.character = from.character;
        to.keyCode = from.keyCode;
        to.stateMask = from.stateMask;
        to.detail = from.detail;
        to.doit = from.doit;
    }

    private class Entry {
        final int eventType;
        final Listener listener;

        private Entry(int eventType, Listener listener) {
            this.eventType = eventType;
            this.listener = listener;
        }
    }
}

