/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.IDateTimeAdapter;
import org.eclipse.swt.internal.widgets.datetimekit.DateTimeThemeAdapter;
import org.eclipse.swt.widgets.Composite;

public class DateTime
extends Composite {
    private int V_PADDING = 1;
    private int H_PADDING = 6;
    private String[] monthNames;
    private String[] weekdayNames;
    private String[] weekdayShortNames;
    private String dateSeparator;
    private String datePattern;
    private final IDateTimeAdapter dateTimeAdapter = new DateTimeAdapter();
    private Calendar rightNow = Calendar.getInstance();
    private Rectangle weekdayTextFieldBounds;
    private Rectangle dayTextFieldBounds;
    private Rectangle monthTextFieldBounds;
    private Rectangle yearTextFieldBounds;
    private Rectangle separator0Bounds;
    private Rectangle separator1Bounds;
    private Rectangle separator2Bounds;
    private Rectangle spinnerBounds;
    private Rectangle hoursTextFieldBounds;
    private Rectangle minutesTextFieldBounds;
    private Rectangle secondsTextFieldBounds;
    private Rectangle separator3Bounds;
    private Rectangle separator4Bounds;
    private Rectangle dropDownButtonBounds;
    static /* synthetic */ Class class$0;

    public DateTime(Composite parent, int style) {
        super(parent, DateTime.checkStyle(style));
        DateFormatSymbols symbols = new DateFormatSymbols(RWT.getLocale());
        this.monthNames = symbols.getMonths();
        this.weekdayNames = symbols.getWeekdays();
        this.weekdayShortNames = symbols.getShortWeekdays();
        this.dateSeparator = this.getDateSeparator();
        this.datePattern = this.getDatePattern(this.dateSeparator);
        this.computeSubWidgetsBounds();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    public int getHours() {
        this.checkWidget();
        return this.rightNow.get(11);
    }

    public int getMinutes() {
        this.checkWidget();
        return this.rightNow.get(12);
    }

    public int getSeconds() {
        this.checkWidget();
        return this.rightNow.get(13);
    }

    public int getDay() {
        this.checkWidget();
        return this.rightNow.get(5);
    }

    public int getMonth() {
        this.checkWidget();
        return this.rightNow.get(2);
    }

    public int getYear() {
        this.checkWidget();
        return this.rightNow.get(1);
    }

    public void setHours(int hours) {
        this.checkWidget();
        if (this.checkTime(hours, this.getMinutes(), this.getSeconds())) {
            this.rightNow.set(11, hours);
        }
    }

    public void setMinutes(int minutes) {
        this.checkWidget();
        if (this.checkTime(this.getHours(), minutes, this.getSeconds())) {
            this.rightNow.set(12, minutes);
        }
    }

    public void setSeconds(int seconds) {
        this.checkWidget();
        if (this.checkTime(this.getHours(), this.getMinutes(), seconds)) {
            this.rightNow.set(13, seconds);
        }
    }

    public void setDay(int day) {
        this.checkWidget();
        int month = this.rightNow.get(2);
        int year = this.rightNow.get(1);
        if (this.checkDate(year, month, day)) {
            this.rightNow.set(5, day);
        }
    }

    public void setMonth(int month) {
        this.checkWidget();
        int day = this.rightNow.get(5);
        int year = this.rightNow.get(1);
        if (this.checkDate(year, month, day)) {
            this.rightNow.set(2, month);
        }
    }

    public void setYear(int year) {
        this.checkWidget();
        int day = this.rightNow.get(5);
        int month = this.rightNow.get(2);
        if (this.checkDate(year, month, day)) {
            this.rightNow.set(1, year);
        }
    }

    public void setDate(int year, int month, int day) {
        this.checkWidget();
        if (this.checkDate(year, month, day)) {
            this.setYear(9996);
            this.setMonth(0);
            this.setDay(1);
            this.setYear(year);
            this.setMonth(month);
            this.setDay(day);
        }
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.checkWidget();
        if (this.checkTime(hours, minutes, seconds)) {
            this.setHours(hours);
            this.setMinutes(minutes);
            this.setSeconds(seconds);
        }
    }

    public void setFont(Font font) {
        if (font != this.getFont()) {
            super.setFont(font);
        }
        this.computeSubWidgetsBounds();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IDateTimeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object result = adapter == clazz ? this.dateTimeAdapter : super.getAdapter(adapter);
        return result;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint == -1 || hHint == -1) {
            Point size = this.computeSubWidgetsBounds();
            width = size.x;
            height = size.y;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        Point size = this.computeSubWidgetsBounds();
        Point computedSize = this.getSize();
        if (!((this.style & 0x20) == 0 && (this.style & 0x80) == 0 || computedSize.x == size.x && computedSize.y == size.y)) {
            this.recalculateButtonsBounds(computedSize);
        }
    }

    private Point computeSubWidgetsBounds() {
        Font font = this.getFont();
        int width = 0;
        int height = 0;
        Rectangle padding = this.getPadding();
        int border = this.getBorderWidth();
        if ((this.style & 0x400) != 0) {
            width = 192 + border * 2;
            height = 136 + border * 2;
        } else if ((this.style & 0x20) != 0) {
            Point prefSize = new Point(0, 0);
            prefSize = this.datePattern.equals("MDY") ? this.computeMDYBounds() : (this.datePattern.equals("DMY") ? this.computeDMYBounds() : ((this.style & 0x10000) != 0 ? this.computeYMDBounds() : this.computeMDYBounds()));
            width = prefSize.x + border * 2;
            height = prefSize.y + border * 2;
        } else if ((this.style & 0x80) != 0) {
            this.hoursTextFieldBounds = new Rectangle(padding.x, padding.y, 0, 0);
            this.hoursTextFieldBounds.width = TextSizeDetermination.stringExtent((Font)font, (String)"88").x + this.H_PADDING;
            this.hoursTextFieldBounds.height = TextSizeDetermination.stringExtent((Font)font, (String)"88").y + this.V_PADDING;
            this.separator3Bounds = new Rectangle(0, padding.y, 0, 0);
            this.separator3Bounds.x = this.hoursTextFieldBounds.x + this.hoursTextFieldBounds.width;
            this.separator3Bounds.width = TextSizeDetermination.stringExtent((Font)font, (String)":").x;
            this.separator3Bounds.height = this.hoursTextFieldBounds.height;
            this.minutesTextFieldBounds = new Rectangle(0, padding.y, 0, 0);
            this.minutesTextFieldBounds.x = this.separator3Bounds.x + this.separator3Bounds.width;
            this.minutesTextFieldBounds.width = this.hoursTextFieldBounds.width;
            this.minutesTextFieldBounds.height = this.hoursTextFieldBounds.height;
            this.separator4Bounds = new Rectangle(0, padding.y, 0, 0);
            this.separator4Bounds.x = this.minutesTextFieldBounds.x + this.minutesTextFieldBounds.width;
            this.separator4Bounds.width = this.separator3Bounds.width;
            this.separator4Bounds.height = this.hoursTextFieldBounds.height;
            this.secondsTextFieldBounds = new Rectangle(0, padding.y, 0, 0);
            this.secondsTextFieldBounds.x = this.separator4Bounds.x + this.separator4Bounds.width;
            this.secondsTextFieldBounds.width = this.hoursTextFieldBounds.width;
            this.secondsTextFieldBounds.height = this.hoursTextFieldBounds.height;
            int spinnerButtonWidth = this.getSpinnerButtonWidth();
            this.spinnerBounds = new Rectangle(0, 0, 0, 0);
            this.spinnerBounds.x = this.minutesTextFieldBounds.x + this.minutesTextFieldBounds.width + padding.x;
            if ((this.style & 0x10000) != 0 || (this.style & 0x10000000) != 0) {
                this.spinnerBounds.x = this.secondsTextFieldBounds.x + this.secondsTextFieldBounds.width + padding.x;
            }
            this.spinnerBounds.width = spinnerButtonWidth + 1;
            this.spinnerBounds.height = this.hoursTextFieldBounds.height + padding.height;
            width = this.spinnerBounds.x + this.spinnerBounds.width + border * 2;
            height = this.spinnerBounds.height + border * 2;
        }
        return new Point(width, height);
    }

    private Point computeMDYBounds() {
        Font font = this.getFont();
        Rectangle padding = this.getPadding();
        this.weekdayTextFieldBounds = new Rectangle(padding.x, padding.y, 0, 0);
        if ((this.style & 0x10000000) != 0) {
            this.weekdayTextFieldBounds.width = this.getMaxStringLength(this.weekdayNames) + this.H_PADDING + 2;
        }
        this.weekdayTextFieldBounds.height = TextSizeDetermination.stringExtent((Font)font, (String)this.weekdayNames[1]).y + this.V_PADDING;
        this.separator0Bounds = new Rectangle(0, padding.y, 0, 0);
        this.separator0Bounds.x = this.weekdayTextFieldBounds.x + this.weekdayTextFieldBounds.width;
        if ((this.style & 0x10000000) != 0) {
            this.separator0Bounds.width = TextSizeDetermination.stringExtent((Font)font, (String)",").x;
        }
        this.separator0Bounds.height = this.weekdayTextFieldBounds.height;
        this.monthTextFieldBounds = new Rectangle(0, padding.y, 0, 0);
        this.monthTextFieldBounds.x = this.separator0Bounds.x + this.separator0Bounds.width;
        this.monthTextFieldBounds.width = (this.style & 0x10000) != 0 ? TextSizeDetermination.stringExtent((Font)font, (String)"88").x + this.H_PADDING : this.getMaxStringLength(this.monthNames) + this.H_PADDING + 2;
        this.monthTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator1Bounds = new Rectangle(0, padding.y, 0, 0);
        this.separator1Bounds.x = this.monthTextFieldBounds.x + this.monthTextFieldBounds.width;
        if ((this.style & 0x10000) != 0) {
            this.separator1Bounds.width = TextSizeDetermination.stringExtent((Font)font, (String)this.dateSeparator).x;
        }
        this.separator1Bounds.height = this.weekdayTextFieldBounds.height;
        this.dayTextFieldBounds = new Rectangle(0, padding.y, 0, 0);
        this.dayTextFieldBounds.x = this.separator1Bounds.x + this.separator1Bounds.width;
        if ((this.style & 0x8000) == 0) {
            this.dayTextFieldBounds.width = TextSizeDetermination.stringExtent((Font)font, (String)"88").x + this.H_PADDING;
        }
        this.dayTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator2Bounds = new Rectangle(0, padding.y, 0, 0);
        this.separator2Bounds.x = this.dayTextFieldBounds.x + this.dayTextFieldBounds.width;
        this.separator2Bounds.width = (this.style & 0x10000) != 0 ? TextSizeDetermination.stringExtent((Font)font, (String)this.dateSeparator).x : TextSizeDetermination.stringExtent((Font)font, (String)",").x;
        this.separator2Bounds.height = this.weekdayTextFieldBounds.height;
        this.yearTextFieldBounds = new Rectangle(0, padding.y, 0, 0);
        this.yearTextFieldBounds.x = this.separator2Bounds.x + this.separator2Bounds.width;
        this.yearTextFieldBounds.width = TextSizeDetermination.stringExtent((Font)font, (String)"8888").x + this.H_PADDING;
        this.yearTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        int spinnerButtonWidth = this.getSpinnerButtonWidth();
        this.spinnerBounds = new Rectangle(0, 0, 0, 0);
        this.spinnerBounds.x = this.yearTextFieldBounds.x + this.yearTextFieldBounds.width + padding.x;
        this.spinnerBounds.width = spinnerButtonWidth + 1;
        this.spinnerBounds.height = this.weekdayTextFieldBounds.height + padding.height;
        int dropDownButtonWidth = this.getDropDownButtonWidth();
        this.dropDownButtonBounds = new Rectangle(this.spinnerBounds.x, this.spinnerBounds.y, dropDownButtonWidth + 1, this.spinnerBounds.height);
        int width = this.spinnerBounds.x;
        int height = this.spinnerBounds.height;
        width = (this.style & 4) == 0 ? (width += this.spinnerBounds.width) : (width += this.dropDownButtonBounds.width);
        return new Point(width, height);
    }

    private Point computeDMYBounds() {
        Font font = this.getFont();
        Rectangle padding = this.getPadding();
        this.weekdayTextFieldBounds = new Rectangle(padding.x, padding.y, 0, 0);
        if ((this.style & 0x10000000) != 0) {
            this.weekdayTextFieldBounds.width = this.getMaxStringLength(this.weekdayNames) + this.H_PADDING + 2;
        }
        this.weekdayTextFieldBounds.height = TextSizeDetermination.stringExtent((Font)font, (String)this.weekdayNames[1]).y + this.V_PADDING;
        this.separator0Bounds = new Rectangle(0, padding.y, 0, 0);
        this.separator0Bounds.x = this.weekdayTextFieldBounds.x + this.weekdayTextFieldBounds.width;
        if ((this.style & 0x10000000) != 0) {
            this.separator0Bounds.width = TextSizeDetermination.stringExtent((Font)font, (String)",").x;
        }
        this.separator0Bounds.height = this.weekdayTextFieldBounds.height;
        this.dayTextFieldBounds = new Rectangle(0, padding.y, 0, 0);
        this.dayTextFieldBounds.x = this.separator0Bounds.x + this.separator0Bounds.width;
        if ((this.style & 0x8000) == 0) {
            this.dayTextFieldBounds.width = TextSizeDetermination.stringExtent((Font)font, (String)"88").x + this.H_PADDING;
        }
        this.dayTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator1Bounds = new Rectangle(0, padding.y, 0, 0);
        this.separator1Bounds.x = this.dayTextFieldBounds.x + this.dayTextFieldBounds.width;
        if ((this.style & 0x10000) != 0) {
            this.separator1Bounds.width = TextSizeDetermination.stringExtent((Font)font, (String)this.dateSeparator).x;
        }
        this.separator1Bounds.height = this.weekdayTextFieldBounds.height;
        this.monthTextFieldBounds = new Rectangle(0, padding.y, 0, 0);
        this.monthTextFieldBounds.x = this.separator1Bounds.x + this.separator1Bounds.width;
        this.monthTextFieldBounds.width = (this.style & 0x10000) != 0 ? TextSizeDetermination.stringExtent((Font)font, (String)"88").x + this.H_PADDING : this.getMaxStringLength(this.monthNames) + this.H_PADDING + 2;
        this.monthTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator2Bounds = new Rectangle(0, padding.y, 0, 0);
        this.separator2Bounds.x = this.monthTextFieldBounds.x + this.monthTextFieldBounds.width;
        this.separator2Bounds.width = (this.style & 0x10000) != 0 ? TextSizeDetermination.stringExtent((Font)font, (String)this.dateSeparator).x : TextSizeDetermination.stringExtent((Font)font, (String)",").x;
        this.separator2Bounds.height = this.weekdayTextFieldBounds.height;
        this.yearTextFieldBounds = new Rectangle(0, padding.y, 0, 0);
        this.yearTextFieldBounds.x = this.separator2Bounds.x + this.separator2Bounds.width;
        this.yearTextFieldBounds.width = TextSizeDetermination.stringExtent((Font)font, (String)"8888").x + this.H_PADDING;
        this.yearTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        int spinnerButtonWidth = this.getSpinnerButtonWidth();
        this.spinnerBounds = new Rectangle(0, 0, 0, 0);
        this.spinnerBounds.x = this.yearTextFieldBounds.x + this.yearTextFieldBounds.width + padding.x;
        this.spinnerBounds.width = spinnerButtonWidth + 1;
        this.spinnerBounds.height = this.weekdayTextFieldBounds.height + padding.height;
        int dropDownButtonWidth = this.getDropDownButtonWidth();
        this.dropDownButtonBounds = new Rectangle(this.spinnerBounds.x, this.spinnerBounds.y, dropDownButtonWidth + 1, this.spinnerBounds.height);
        int width = this.spinnerBounds.x;
        int height = this.spinnerBounds.height;
        width = (this.style & 4) == 0 ? (width += this.spinnerBounds.width) : (width += this.dropDownButtonBounds.width);
        return new Point(width, height);
    }

    private Point computeYMDBounds() {
        Font font = this.getFont();
        Rectangle padding = this.getPadding();
        this.weekdayTextFieldBounds = new Rectangle(padding.x, padding.y, 0, 0);
        if ((this.style & 0x10000000) != 0) {
            this.weekdayTextFieldBounds.width = this.getMaxStringLength(this.weekdayNames) + this.H_PADDING + 2;
        }
        this.weekdayTextFieldBounds.height = TextSizeDetermination.stringExtent((Font)font, (String)this.weekdayNames[1]).y + this.V_PADDING;
        this.separator0Bounds = new Rectangle(0, padding.y, 0, 0);
        this.separator0Bounds.x = this.weekdayTextFieldBounds.x + this.weekdayTextFieldBounds.width;
        if ((this.style & 0x10000000) != 0) {
            this.separator0Bounds.width = TextSizeDetermination.stringExtent((Font)font, (String)",").x;
        }
        this.separator0Bounds.height = this.weekdayTextFieldBounds.height;
        this.yearTextFieldBounds = new Rectangle(0, padding.y, 0, 0);
        this.yearTextFieldBounds.x = this.separator0Bounds.x + this.separator0Bounds.width;
        this.yearTextFieldBounds.width = TextSizeDetermination.stringExtent((Font)font, (String)"8888").x + this.H_PADDING;
        this.yearTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator1Bounds = new Rectangle(0, padding.y, 0, 0);
        this.separator1Bounds.x = this.yearTextFieldBounds.x + this.yearTextFieldBounds.width;
        if ((this.style & 0x10000) != 0) {
            this.separator1Bounds.width = TextSizeDetermination.stringExtent((Font)font, (String)this.dateSeparator).x;
        }
        this.monthTextFieldBounds = new Rectangle(0, padding.y, 0, 0);
        this.monthTextFieldBounds.x = this.separator1Bounds.x + this.separator1Bounds.width;
        this.monthTextFieldBounds.width = (this.style & 0x10000) != 0 ? TextSizeDetermination.stringExtent((Font)font, (String)"88").x + this.H_PADDING : this.getMaxStringLength(this.monthNames) + this.H_PADDING + 2;
        this.monthTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator2Bounds = new Rectangle(0, padding.y, 0, 0);
        this.separator2Bounds.x = this.monthTextFieldBounds.x + this.monthTextFieldBounds.width;
        this.separator2Bounds.width = (this.style & 0x10000) != 0 ? TextSizeDetermination.stringExtent((Font)font, (String)this.dateSeparator).x : TextSizeDetermination.stringExtent((Font)font, (String)",").x;
        this.separator2Bounds.height = this.weekdayTextFieldBounds.height;
        this.dayTextFieldBounds = new Rectangle(0, padding.y, 0, 0);
        this.dayTextFieldBounds.x = this.separator2Bounds.x + this.separator2Bounds.width;
        if ((this.style & 0x8000) == 0) {
            this.dayTextFieldBounds.width = TextSizeDetermination.stringExtent((Font)font, (String)"88").x + this.H_PADDING;
        }
        this.dayTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator1Bounds.height = this.weekdayTextFieldBounds.height;
        int spinnerButtonWidth = this.getSpinnerButtonWidth();
        this.spinnerBounds = new Rectangle(0, 0, 0, 0);
        this.spinnerBounds.x = this.dayTextFieldBounds.x + this.dayTextFieldBounds.width + padding.x;
        this.spinnerBounds.width = spinnerButtonWidth + 1;
        this.spinnerBounds.height = this.weekdayTextFieldBounds.height + padding.height;
        int dropDownButtonWidth = this.getDropDownButtonWidth();
        this.dropDownButtonBounds = new Rectangle(this.spinnerBounds.x, this.spinnerBounds.y, dropDownButtonWidth + 1, this.spinnerBounds.height);
        int width = this.spinnerBounds.x;
        int height = this.spinnerBounds.height;
        width = (this.style & 4) == 0 ? (width += this.spinnerBounds.width) : (width += this.dropDownButtonBounds.width);
        return new Point(width, height);
    }

    private void recalculateButtonsBounds(Point size) {
        int border = this.getBorderWidth();
        this.spinnerBounds.x = size.x - this.spinnerBounds.width - 2 * border;
        this.spinnerBounds.height = size.y - 2 * border;
        if ((this.style & 4) != 0) {
            this.dropDownButtonBounds.x = size.x - this.dropDownButtonBounds.width - 2 * border;
            this.dropDownButtonBounds.height = size.y - 2 * border;
        }
    }

    private int getSpinnerButtonWidth() {
        ThemeManager manager = ThemeManager.getInstance();
        DateTimeThemeAdapter adapter = (DateTimeThemeAdapter)manager.getThemeAdapter(this.getClass());
        return adapter.getSpinnerButtonWidth(this);
    }

    private int getDropDownButtonWidth() {
        ThemeManager manager = ThemeManager.getInstance();
        DateTimeThemeAdapter adapter = (DateTimeThemeAdapter)manager.getThemeAdapter(this.getClass());
        return adapter.getDropDownButtonWidth(this);
    }

    private Rectangle getPadding() {
        ThemeManager manager = ThemeManager.getInstance();
        DateTimeThemeAdapter adapter = (DateTimeThemeAdapter)manager.getThemeAdapter(this.getClass());
        return adapter.getPadding(this);
    }

    private int getDaysInMonth(int month, int year) {
        GregorianCalendar cal = new GregorianCalendar(year, month, 1);
        return cal.getActualMaximum(5);
    }

    private int getMaxStringLength(String[] strings) {
        Font font = this.getFont();
        int maxLength = 0;
        int i = 0;
        while (i < strings.length) {
            int currentStringWidth = TextSizeDetermination.stringExtent((Font)font, (String)strings[i]).x;
            maxLength = Math.max(maxLength, currentStringWidth);
            ++i;
        }
        return maxLength;
    }

    private String getDateSeparator() {
        DateFormat df = DateFormat.getDateInstance(3, RWT.getLocale());
        String datePattern = ((SimpleDateFormat)df).toPattern();
        String result = "";
        int index = 0;
        while (Character.isLetter(datePattern.charAt(index))) {
            ++index;
        }
        result = Character.toString(datePattern.charAt(index));
        return result;
    }

    private String getDatePattern(String dateSeparator) {
        DateFormat df = DateFormat.getDateInstance(3, RWT.getLocale());
        String datePattern = ((SimpleDateFormat)df).toPattern();
        String result = "";
        StringTokenizer st = new StringTokenizer(datePattern, dateSeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            result = String.valueOf(result) + Character.toString(token.charAt(0));
        }
        return result.toUpperCase();
    }

    String getNameText() {
        return "DateTime";
    }

    private boolean checkDate(int year, int month, int day) {
        boolean validDay;
        int daysInMonth = this.getDaysInMonth(month, year);
        boolean validYear = year >= 1752 && year <= 9999 && day <= daysInMonth;
        boolean validMonth = month >= 0 && month <= 11 && day <= daysInMonth;
        boolean bl = validDay = day >= 1 && day <= daysInMonth;
        return validYear && validMonth && validDay;
    }

    private boolean checkTime(int hours, int minutes, int seconds) {
        boolean validSeconds;
        boolean validHours = hours >= 0 && hours <= 23;
        boolean validMinutes = minutes >= 0 && minutes <= 59;
        boolean bl = validSeconds = seconds >= 0 && seconds <= 59;
        return validHours && validMinutes && validSeconds;
    }

    static int checkStyle(int value) {
        int style = value;
        style &= 0xFFFFFCFF;
        style = DateTime.checkBits(style, 32, 128, 1024, 0, 0, 0);
        if (((style = DateTime.checkBits(style, 65536, 32768, 0x10000000, 0, 0, 0)) & 0x20) == 0) {
            style &= 0xFFFFFFFB;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    private final class DateTimeAdapter
    implements IDateTimeAdapter {
        private DateTimeAdapter() {
        }

        public Rectangle getBounds(int widget) {
            Rectangle result = new Rectangle(0, 0, 0, 0);
            switch (widget) {
                case 0: {
                    result = DateTime.this.weekdayTextFieldBounds;
                    break;
                }
                case 1: {
                    result = DateTime.this.dayTextFieldBounds;
                    break;
                }
                case 2: {
                    result = DateTime.this.monthTextFieldBounds;
                    break;
                }
                case 3: {
                    result = DateTime.this.yearTextFieldBounds;
                    break;
                }
                case 4: {
                    result = DateTime.this.separator0Bounds;
                    break;
                }
                case 5: {
                    result = DateTime.this.separator1Bounds;
                    break;
                }
                case 6: {
                    result = DateTime.this.separator2Bounds;
                    break;
                }
                case 7: {
                    result = DateTime.this.spinnerBounds;
                    break;
                }
                case 8: {
                    result = DateTime.this.hoursTextFieldBounds;
                    break;
                }
                case 9: {
                    result = DateTime.this.minutesTextFieldBounds;
                    break;
                }
                case 10: {
                    result = DateTime.this.secondsTextFieldBounds;
                    break;
                }
                case 11: {
                    result = DateTime.this.separator3Bounds;
                    break;
                }
                case 12: {
                    result = DateTime.this.separator4Bounds;
                    break;
                }
                case 13: {
                    result = DateTime.this.dropDownButtonBounds;
                }
            }
            return result;
        }

        public String[] getMonthNames() {
            return DateTime.this.monthNames;
        }

        public String[] getWeekdayNames() {
            return DateTime.this.weekdayNames;
        }

        public String[] getWeekdayShortNames() {
            return DateTime.this.weekdayShortNames;
        }

        public String getDateSeparator() {
            return DateTime.this.dateSeparator;
        }

        public String getDatePattern() {
            return DateTime.this.datePattern;
        }
    }
}

