/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.IMenuAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.MenuHolder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    private IMenuAdapter menuAdapter;
    private final ItemHolder itemHolder;
    private final Decorations parent;
    private int x;
    private int y;
    private boolean visible = false;
    MenuItem cascade;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem parent) {
        this(Menu.checkNull(parent).getParent().getParent(), 4);
    }

    public Menu(Control parent) {
        this(Menu.checkNull(parent).getShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.MenuItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemHolder = new ItemHolder(clazz);
        MenuHolder.addMenu(parent, this);
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.getParent();
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IItemHolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            result = this.itemHolder;
        } else {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IMenuAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz2) {
                if (this.menuAdapter == null) {
                    this.menuAdapter = new IMenuAdapter(){

                        public Point getLocation() {
                            return new Point(Menu.this.x, Menu.this.y);
                        }
                    };
                }
                result = this.menuAdapter;
            } else {
                result = super.getAdapter(adapter);
            }
        }
        return result;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        if ((this.style & 6) == 0) {
            this.x = x;
            this.y = y;
        }
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            SWT.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) == 0 && this.visible != visible) {
            this.visible = visible;
            if (visible) {
                MenuEvent event = new MenuEvent(this, 22);
                event.processEvent();
            }
        }
    }

    public boolean getVisible() {
        this.checkWidget();
        boolean result = (this.style & 2) != 0 ? this == this.parent.getMenuBar() : ((this.style & 8) != 0 ? this.visible : false);
        return result;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state &= 0xFFFFFFF7;
        if (!enabled) {
            this.state |= 8;
        }
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemHolder.size();
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        return (MenuItem[])this.itemHolder.getItems();
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        return (MenuItem)this.itemHolder.getItem(index);
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem == null) {
            SWT.error(4);
        }
        if (menuItem.isDisposed()) {
            SWT.error(5);
        }
        return this.itemHolder.indexOf(menuItem);
    }

    final void releaseChildren() {
        MenuItem[] menuItems = (MenuItem[])ItemHolder.getItems(this);
        int i = 0;
        while (i < menuItems.length) {
            menuItems[i].dispose();
            ++i;
        }
        super.releaseChildren();
    }

    final void releaseWidget() {
        MenuHolder.removeMenu(this.parent, this);
        super.releaseWidget();
    }

    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = String.valueOf(result) + items[i].getNameText() + ", ";
                ++i;
            }
            result = String.valueOf(result) + items[length - 1].getNameText();
        }
        return result;
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        MenuEvent.addListener(this, listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        MenuEvent.removeListener(this, listener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        HelpEvent.addListener(this, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        HelpEvent.removeListener(this, listener);
    }

    private static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    private static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    private static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    private static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }
}

