/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    private final TabFolder parent;
    private Control control;
    private String toolTipText;

    public TabItem(TabFolder parent, int style) {
        super(parent, TabItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public TabItem(TabFolder parent, int style, int index) {
        super(parent, TabItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int index = this.parent.indexOf(this);
        if (index != this.parent.getSelectionIndex()) {
            if (newControl != null) {
                newControl.setVisible(false);
            }
        } else {
            if (newControl != null) {
                newControl.setBounds(this.parent.getClientArea());
                newControl.setVisible(true);
            }
            if (oldControl != null) {
                oldControl.setVisible(false);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index > -1) {
            super.setImage(image);
        }
    }

    public void setToolTipText(String toolTip) {
        this.checkWidget();
        this.toolTipText = toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void releaseParent() {
        super.releaseParent();
        ItemHolder.removeItem(this.parent, this);
    }

    private static int checkStyle(int style) {
        int result = 0;
        if (style > 0) {
            result = style;
        }
        return result;
    }
}

