/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.toolbarkit.ToolBarThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBar
extends Composite {
    private static final int DEFAULT_TOOLBAR_WIDTH = 24;
    private static final int DEFAULT_TOOLBAR_HEIGHT = 22;
    private final ItemHolder itemHolder;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.ToolItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemHolder = new ItemHolder(clazz);
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IItemHolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object result = adapter == clazz ? this.itemHolder : super.getAdapter(adapter);
        return result;
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        return (ToolItem)this.itemHolder.getItem(index);
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem result = null;
        ToolItem[] items = this.getItems();
        int i = 0;
        while (result == null && i < items.length) {
            Rectangle rect = items[i].getBounds();
            if (rect.contains(point)) {
                result = items[i];
            }
            ++i;
        }
        return result;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemHolder.size();
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return (ToolItem[])this.itemHolder.getItems();
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        return this.itemHolder.indexOf(item);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Rectangle itemBounds;
        ToolItem item;
        int i;
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 0x200) != 0) {
            i = 0;
            while (i < this.itemHolder.size()) {
                item = (ToolItem)this.itemHolder.getItem(i);
                itemBounds = item.getBounds();
                width = Math.max(width, itemBounds.width);
                if (i == this.itemHolder.size() - 1) {
                    height += itemBounds.height + itemBounds.y;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.itemHolder.size()) {
                item = (ToolItem)this.itemHolder.getItem(i);
                itemBounds = item.getBounds();
                height = Math.max(height, itemBounds.height);
                if (i == this.itemHolder.size() - 1) {
                    width += itemBounds.width + itemBounds.x;
                }
                ++i;
            }
        }
        height += this.getToolBarPadding().height;
        if ((width += this.getToolBarPadding().width) == 0) {
            width = 24;
        }
        if (height == 0) {
            height = 22;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        i = 0;
        while (i < this.itemHolder.size()) {
            item = (ToolItem)this.itemHolder.getItem(i);
            item.resizeControl();
            ++i;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        width = trim.width;
        height = trim.height;
        return new Point(width, height);
    }

    public int getBorderWidth() {
        return (this.style & 0x800) != 0 ? 1 : 0;
    }

    Rectangle getToolBarPadding() {
        ToolBarThemeAdapter adapter = this.getToolBarThemeAdapter();
        return adapter.getToolBarPadding(this);
    }

    private ToolBarThemeAdapter getToolBarThemeAdapter() {
        ThemeManager themeMgr = ThemeManager.getInstance();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.swt.widgets.ToolBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ToolBarThemeAdapter)themeMgr.getThemeAdapter(clazz);
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        int i = 0;
        while (i < this.itemHolder.size()) {
            ToolItem item = (ToolItem)this.itemHolder.getItem(i);
            Rectangle ibounds = item.getBounds();
            boolean visible = ibounds.x + ibounds.width <= bounds.width;
            item.setVisible(visible);
            ++i;
        }
    }

    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item != null && item.getControl() == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    final void releaseChildren() {
        ToolItem[] toolItems = this.getItems();
        int i = 0;
        while (i < toolItems.length) {
            toolItems[i].dispose();
            ++i;
        }
    }

    private static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }
}

