/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.IToolItemAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.toolbarkit.ToolBarThemeAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;

public class ToolItem
extends Item {
    private static final int DEFAULT_WIDTH = 24;
    private static final int DEFAULT_HEIGHT = 22;
    private final ToolBar parent;
    private boolean selected;
    private Control control;
    private int width;
    private boolean computedWidth = true;
    private String toolTipText;
    private boolean visible;
    private Image disabledImage;
    private Image hotImage;
    private final IToolItemAdapter toolItemAdapter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ToolItem(ToolBar parent, int style) {
        this(ToolItem.checkNull(parent), ToolItem.checkStyle(style), parent.getItemCount());
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        this.visible = true;
        ItemHolder.insertItem(parent, this, index);
        this.computeInitialWidth();
        this.toolItemAdapter = new IToolItemAdapter(){

            public boolean getVisible() {
                return ToolItem.this.visible;
            }
        };
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error(4);
        }
        if ((this.style & 2) == 0) {
            super.setText(text);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            super.setImage(image);
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            this.disabledImage = image;
        }
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            this.hotImage = image;
        }
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                SWT.error(5);
            }
            if (control.getParent() != this.parent) {
                SWT.error(32);
            }
        }
        if ((this.style & 2) != 0) {
            if (this.control != null && !this.control.isDisposed()) {
                this.control.setVisible(false);
            }
            this.control = control;
            if (this.control != null) {
                this.control.setVisible(true);
            }
            this.resizeControl();
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rectangle clientArea = this.parent.getClientArea();
        int left = clientArea.x;
        int top = clientArea.y;
        int index = this.parent.indexOf(this);
        if ((this.parent.style & 0x200) != 0) {
            if (index > 0) {
                Rectangle upperSiblingBounds = this.parent.getItem(index - 1).getBounds();
                top += upperSiblingBounds.y + upperSiblingBounds.height;
                top += this.getToolBarSpacing();
            } else {
                top += this.parent.getToolBarPadding().y;
            }
            left += this.parent.getToolBarPadding().x;
        } else {
            if (index > 0) {
                Rectangle leftSiblingBounds = this.parent.getItem(index - 1).getBounds();
                left += leftSiblingBounds.x + leftSiblingBounds.width;
                left += this.getToolBarSpacing();
            } else {
                left += this.parent.getToolBarPadding().x;
            }
            top += this.parent.getToolBarPadding().y;
        }
        return new Rectangle(left, top, this.getWidth(), this.getHeight());
    }

    private int getHeight() {
        int height;
        if ((this.parent.style & 0x200) != 0 && (this.style & 2) != 0 && this.getControl() == null) {
            height = this.getSeparatorWidth();
        } else {
            height = 0;
            ToolItem[] siblings = this.getParent().getItems();
            int i = 0;
            while (i < siblings.length) {
                if ((siblings[i].style & 2) == 0) {
                    height = Math.max(height, siblings[i].getPreferredHeight());
                }
                ++i;
            }
        }
        return height;
    }

    public int getWidth() {
        int result;
        boolean isVertical;
        this.checkWidget();
        boolean bl = isVertical = (this.parent.style & 0x200) != 0;
        if (!((this.style & 2) == 0 || isVertical && this.computedWidth)) {
            result = this.width;
        } else if (isVertical) {
            result = 0;
            ToolItem[] siblings = this.getParent().getItems();
            int i = 0;
            while (i < siblings.length) {
                if ((siblings[i].style & 2) == 0) {
                    result = Math.max(result, siblings[i].getPreferredWidth());
                }
                ++i;
            }
        } else {
            result = this.getPreferredWidth();
        }
        return result;
    }

    int getPreferredHeight() {
        int height = 22;
        int frameHeight = this.getPadding().height + this.getBorderWidth() * 2;
        if (!"".equals(this.getText())) {
            int charHeight = TextSizeDetermination.getCharHeight(this.parent.getFont());
            height = Math.max(22, charHeight + frameHeight);
        }
        if (this.getImage() != null) {
            int imageHeight = this.getImage().getBounds().height;
            height = Math.max(height, imageHeight + frameHeight);
        }
        return height;
    }

    int getPreferredWidth() {
        boolean hasText;
        int result = 0;
        boolean hasImage = this.image != null;
        boolean bl = hasText = !"".equals(this.text);
        if (hasImage) {
            result += this.image.getBounds().width;
        }
        if (hasText) {
            Font font = this.parent.getFont();
            result += TextSizeDetermination.stringExtent((Font)font, (String)this.text).x;
        }
        if (hasText && hasImage) {
            result += this.getSpacing();
        }
        int paddingWidth = this.getPadding().width;
        int borderWidth = this.getBorderWidth() * 2;
        if ((this.style & 4) != 0) {
            result += this.getSpacing() * 2;
            ++result;
            result += this.getDropDownImageDimension().x;
        }
        return result += paddingWidth + borderWidth;
    }

    private int getBorderWidth() {
        ToolBarThemeAdapter adapter = this.getToolBarThemeAdapter();
        return adapter.getItemBorderWidth(this.parent);
    }

    private Point getDropDownImageDimension() {
        ToolBarThemeAdapter adapter = this.getToolBarThemeAdapter();
        return adapter.getDropDownImageDimension(this.parent);
    }

    private Rectangle getPadding() {
        ToolBarThemeAdapter adapter = this.getToolBarThemeAdapter();
        return adapter.getItemPadding(this.parent);
    }

    private int getToolBarSpacing() {
        ToolBarThemeAdapter adapter = this.getToolBarThemeAdapter();
        return adapter.getToolBarSpacing(this.parent);
    }

    private int getSpacing() {
        ToolBarThemeAdapter adapter = this.getToolBarThemeAdapter();
        return adapter.getItemSpacing(this.parent);
    }

    int getSeparatorWidth() {
        ToolBarThemeAdapter adapter = this.getToolBarThemeAdapter();
        return adapter.getSeparatorWidth(this.parent);
    }

    private ToolBarThemeAdapter getToolBarThemeAdapter() {
        ThemeManager themeMgr = ThemeManager.getInstance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.ToolBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ToolBarThemeAdapter)themeMgr.getThemeAdapter(clazz);
    }

    public void setWidth(int width) {
        this.checkWidget();
        if ((this.style & 2) != 0 && width >= 0) {
            this.computedWidth = false;
            this.width = width;
            this.resizeControl();
        }
    }

    public boolean getSelection() {
        this.checkWidget();
        boolean result = this.selected;
        if ((this.style & 0x30) == 0) {
            result = false;
        }
        return result;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) != 0) {
            this.selected = selected;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    void releaseParent() {
        super.releaseParent();
        ItemHolder.removeItem(this.parent, this);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IToolItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object result = adapter == clazz ? this.toolItemAdapter : super.getAdapter(adapter);
        return result;
    }

    void resizeControl() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setBounds(this.getBounds());
        }
    }

    private void computeInitialWidth() {
        if ((this.style & 2) != 0) {
            this.width = this.getSeparatorWidth();
        } else {
            this.width = 24;
            if ((this.style & 4) != 0) {
                this.width += this.getDropDownImageDimension().x;
            }
        }
    }

    private static ToolBar checkNull(ToolBar parent) {
        if (parent == null) {
            SWT.error(4);
        }
        return parent;
    }

    private static int checkStyle(int style) {
        return ToolItem.checkBits(style, 8, 32, 16, 2, 4, 0);
    }

    void setVisible(boolean visible) {
        this.visible = visible;
    }
}

