/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.internal.widgets.treekit.TreeThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    private static final TreeItem[] EMPTY_SELECTION = new TreeItem[0];
    private static final int CHECK_HEIGHT = 13;
    private static final int VERTICAL_ITEM_MARGIN = 3;
    final ItemHolder itemHolder;
    final ItemHolder columnHolder;
    private TreeItem[] selection;
    private boolean linesVisible;
    private int[] columnOrder;
    private TreeColumn sortColumn;
    private int sortDirection = 0;
    private boolean headerVisible = false;
    private TreeItem showItem;
    private final ResizeListener resizeListener;
    private final TreeListener expandListener;
    private TreeItem currentItem;
    private final ITreeAdapter treeAdapter;
    int scrollTop;
    int scrollLeft;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.TreeItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemHolder = new ItemHolder(clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.swt.widgets.TreeColumn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.columnHolder = new ItemHolder(clazz2);
        this.treeAdapter = new InternalTreeAdapter();
        this.selection = EMPTY_SELECTION;
        if ((this.style & 0x10000000) != 0) {
            this.resizeListener = new ResizeListener();
            this.addControlListener(this.resizeListener);
            this.expandListener = new ExpandListener();
            this.addTreeListener(this.expandListener);
        } else {
            this.resizeListener = null;
            this.expandListener = null;
        }
    }

    void initState() {
        this.state &= 0xFFFFFEFF;
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IItemHolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            result = new CompositeItemHolder();
        } else {
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.swt.internal.widgets.ITreeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result = adapter == clazz2 ? this.treeAdapter : super.getAdapter(adapter);
        }
        return result;
    }

    public void setItemCount(int itemCount) {
        this.checkWidget();
        this.setItemCount(itemCount, null);
        this.redraw();
    }

    void setItemCount(int itemCount, TreeItem parent) {
        int oldItemCount = parent == null ? this.getItemCount() : parent.getItemCount();
        int newItemCount = Math.max(0, itemCount);
        if (newItemCount != oldItemCount) {
            TreeItem[] items = parent == null ? this.getItems() : parent.getItems();
            int index = newItemCount;
            while (index < oldItemCount) {
                TreeItem item = items[index];
                if (item != null && !item.isDisposed()) {
                    item.dispose();
                }
                ++index;
            }
            int i = oldItemCount;
            while (i < newItemCount) {
                if (parent == null) {
                    new TreeItem(this, 0, i);
                } else {
                    new TreeItem(parent, 0, i);
                }
                ++i;
            }
        }
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemHolder.size();
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return (TreeItem[])this.itemHolder.getItems();
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        return (TreeItem)this.itemHolder.getItem(index);
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        int index = this.itemHolder.indexOf(item);
        return index;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public void removeAll() {
        this.checkWidget();
        TreeItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        this.selection = EMPTY_SELECTION;
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.getParent() != this) {
            return;
        }
        TreeItem parent = item.getParentItem();
        while (parent != null) {
            parent.setExpanded(true);
            parent = parent.getParentItem();
        }
        this.showItem = item;
    }

    public void showColumn(TreeColumn column) {
        int index;
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.getParent() == this && (index = this.indexOf(column)) >= 0 && index < this.getColumnCount()) {
            int leftColumnsWidth = 0;
            int columnWidth = column.getWidth();
            int clientWidth = this.getClientArea().width - this.getVScrollBarWidth();
            int[] columnOrder = this.getColumnOrder();
            boolean found = false;
            int i = 0;
            while (i < columnOrder.length && !found) {
                boolean bl = found = index == columnOrder[i];
                if (!found) {
                    leftColumnsWidth += this.getColumn(columnOrder[i]).getWidth();
                }
                ++i;
            }
            if (this.scrollLeft > leftColumnsWidth) {
                this.scrollLeft = leftColumnsWidth;
            } else if (this.scrollLeft < leftColumnsWidth + columnWidth - clientWidth) {
                this.scrollLeft = leftColumnsWidth + columnWidth - clientWidth;
            }
        }
    }

    private int getVScrollBarWidth() {
        return (this.style & 0x200) != 0 ? 16 : 0;
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selection.length == 0) {
            return;
        }
        this.showItem(this.selection[0]);
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        TreeItem[] result = new TreeItem[this.selection.length];
        System.arraycopy(this.selection, 0, result, 0, this.selection.length);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selection.length;
    }

    public void setSelection(TreeItem selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error(4);
        }
        this.setSelection(new TreeItem[]{selection});
    }

    public void setSelection(TreeItem[] selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error(4);
        }
        int length = selection.length;
        if ((this.style & 4) != 0) {
            if (length == 0 || length > 1) {
                this.deselectAll();
            } else {
                TreeItem item = selection[0];
                if (item != null) {
                    if (item.isDisposed()) {
                        SWT.error(5);
                    }
                    this.selection = new TreeItem[]{item};
                }
            }
        } else if (length == 0) {
            this.deselectAll();
        } else {
            TreeItem[] validSelection = new TreeItem[length];
            int validLength = 0;
            int i = 0;
            while (i < length) {
                if (selection[i] != null) {
                    if (selection[i].isDisposed()) {
                        SWT.error(5);
                    }
                    validSelection[validLength] = selection[i];
                    ++validLength;
                }
                ++i;
            }
            if (validLength > 0) {
                this.selection = new TreeItem[validLength];
                System.arraycopy(validSelection, 0, this.selection, 0, validLength);
            }
        }
    }

    public void select(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 4) != 0) {
            this.setSelection(item);
        } else {
            ArrayList<TreeItem> selItems = new ArrayList<TreeItem>(Arrays.asList(this.selection));
            if (!selItems.contains(item)) {
                selItems.add(item);
                this.selection = new TreeItem[selItems.size()];
                selItems.toArray(this.selection);
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            final ArrayList allItems = new ArrayList();
            WidgetTreeVisitor.accept(this, new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                public boolean doVisit(Widget widget) {
                    if (widget instanceof TreeItem) {
                        allItems.add(widget);
                    }
                    return true;
                }
            });
            this.selection = new TreeItem[allItems.size()];
            allItems.toArray(this.selection);
        }
    }

    public void deselect(TreeItem item) {
        ArrayList<TreeItem> selItems;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if ((selItems = new ArrayList<TreeItem>(Arrays.asList(this.selection))).contains(item)) {
            selItems.remove(item);
            this.selection = new TreeItem[selItems.size()];
            selItems.toArray(this.selection);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.selection = EMPTY_SELECTION;
    }

    public void setLinesVisible(boolean value) {
        this.checkWidget();
        if (this.linesVisible == value) {
            return;
        }
        this.linesVisible = value;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    public void clear(int index, boolean recursive) {
        this.checkWidget();
        if (index < 0 || index >= this.itemHolder.size()) {
            this.error(6);
        }
        TreeItem item = (TreeItem)this.itemHolder.getItem(index);
        item.clear();
        if (recursive) {
            item.clearAll(true, false);
        }
        if ((this.style & 0x10000000) == 0) {
            this.checkData(item, index);
        }
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int index = (point.y - this.getHeaderHeight() + this.scrollTop) / this.getItemHeight();
        List visibleItems = this.collectVisibleItems(null);
        if (index < 0 || index >= visibleItems.size()) {
            return null;
        }
        TreeItem result = (TreeItem)visibleItems.get(index);
        return result;
    }

    private List collectVisibleItems(TreeItem parent) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        TreeItem[] children = parent == null ? this.getItems() : parent.getItems();
        int i = 0;
        while (i < children.length) {
            TreeItem item = children[i];
            result.add(item);
            if (item.getExpanded()) {
                result.addAll(this.collectVisibleItems(item));
            }
            ++i;
        }
        return result;
    }

    private int getItemHeight() {
        this.checkWidget();
        int charHeight = TextSizeDetermination.getCharHeight(this.getFont());
        int result = charHeight + 3;
        if ((this.style & 0x20) != 0) {
            result = Math.max(13, result);
        }
        return result;
    }

    public void clearAll(boolean recursive) {
        this.checkWidget();
        if (this.itemHolder.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.itemHolder.size()) {
            ((TreeItem)this.itemHolder.getItem(i)).clear();
            if (recursive) {
                ((TreeItem)this.itemHolder.getItem(i)).clearAll(true, false);
            }
            ++i;
        }
        if ((this.style & 0x10000000) != 0) {
            Tree.checkAllData(this);
        }
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnHolder.size();
    }

    void createItem(TreeColumn column, int index) {
        this.columnHolder.insert(column, index);
        if (this.columnOrder == null) {
            this.columnOrder = new int[]{index};
        } else {
            int length = this.columnOrder.length;
            int i = index;
            while (i < length) {
                int n = i++;
                this.columnOrder[n] = this.columnOrder[n] + 1;
            }
            int[] newColumnOrder = new int[length + 1];
            System.arraycopy(this.columnOrder, 0, newColumnOrder, 0, index);
            System.arraycopy(this.columnOrder, index, newColumnOrder, index + 1, length - index);
            this.columnOrder = newColumnOrder;
            this.columnOrder[index] = index;
        }
        int i = 0;
        while (i < this.itemHolder.size()) {
            TreeItem child = (TreeItem)this.itemHolder.getItem(i);
            child.addColumn(column);
            ++i;
        }
    }

    final void destroyColumn(TreeColumn column) {
        int index = this.indexOf(column);
        if (column == this.sortColumn) {
            this.sortColumn = null;
        }
        this.columnHolder.remove(column);
        int length = this.columnOrder.length;
        int[] newColumnOrder = new int[length - 1];
        int count = 0;
        int i = 0;
        while (i < length) {
            if (this.columnOrder[i] != index) {
                int newOrder = this.columnOrder[i];
                if (index < newOrder) {
                    // empty if block
                }
                newColumnOrder[count] = --newOrder;
                ++count;
            }
            ++i;
        }
        this.columnOrder = newColumnOrder;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        int result = 0;
        if (this.headerVisible) {
            int textHeight = TextSizeDetermination.getCharHeight(this.getFont());
            int imageHeight = 0;
            int i = 0;
            while (i < this.getColumnCount()) {
                int height;
                Image image = this.getColumn(i).getImage();
                int n = height = image == null ? 0 : image.getBounds().height;
                if (height > imageHeight) {
                    imageHeight = height;
                }
                ++i;
            }
            result = Math.max(textHeight, imageHeight);
            ThemeManager themeManager = ThemeManager.getInstance();
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.swt.widgets.Tree");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TreeThemeAdapter adapter = (TreeThemeAdapter)themeManager.getThemeAdapter(clazz);
            result += adapter.getHeaderBorderBottomWidth(this);
            result += adapter.getHeaderPadding((Control)this).height;
        }
        return result;
    }

    public void setHeaderVisible(boolean value) {
        this.checkWidget();
        if (this.headerVisible == value) {
            return;
        }
        this.headerVisible = value;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return this.headerVisible;
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            SWT.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        return this.columnHolder.indexOf(column);
    }

    TreeColumn[] getOrderedColumns() {
        return this.getColumns();
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnHolder.size()) {
            this.error(6);
        }
        return (TreeColumn)this.columnHolder.getItem(index);
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        return (TreeColumn[])this.columnHolder.getItems();
    }

    public void setColumnOrder(int[] order) {
        int columnCount;
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (order.length != (columnCount = this.getColumnCount())) {
            this.error(5);
        }
        if (columnCount > 0) {
            int[] oldOrder = new int[columnCount];
            System.arraycopy(this.columnOrder, 0, oldOrder, 0, this.columnOrder.length);
            boolean reorder = false;
            boolean[] seen = new boolean[columnCount];
            int i = 0;
            while (i < order.length) {
                int index = order[i];
                if (index < 0 || index >= columnCount) {
                    this.error(6);
                }
                if (seen[index]) {
                    this.error(5);
                }
                seen[index] = true;
                if (index != oldOrder[i]) {
                    reorder = true;
                }
                ++i;
            }
            if (reorder) {
                System.arraycopy(order, 0, this.columnOrder, 0, this.columnOrder.length);
                i = 0;
                while (i < seen.length) {
                    if (oldOrder[i] != this.columnOrder[i]) {
                        TreeColumn column = this.getColumn(this.columnOrder[i]);
                        int controlMoved = 10;
                        ControlEvent controlEvent = new ControlEvent(column, controlMoved);
                        controlEvent.processEvent();
                    }
                    ++i;
                }
            }
        }
    }

    public void setSortColumn(TreeColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (column == this.sortColumn) {
            return;
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(0);
        }
        this.sortColumn = column;
        if (this.sortColumn != null) {
            this.sortColumn.setSortDirection(this.sortDirection);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        this.sortColumn.setSortDirection(this.sortDirection);
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int[] getColumnOrder() {
        int[] result;
        this.checkWidget();
        if (this.columnHolder.size() == 0) {
            result = new int[]{};
        } else {
            result = new int[this.columnOrder.length];
            System.arraycopy(this.columnOrder, 0, result, 0, this.columnOrder.length);
        }
        return result;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        TreeEvent.addListener((Adaptable)this, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        TreeEvent.removeListener((Adaptable)this, listener);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.resizeListener != null) {
            this.removeControlListener(this.resizeListener);
        }
    }

    void releaseChildren() {
        TreeItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        TreeColumn[] cols = (TreeColumn[])this.columnHolder.getItems();
        int c = 0;
        while (c < cols.length) {
            cols[c].dispose();
            ++c;
        }
        super.releaseChildren();
    }

    void removeFromSelection(TreeItem item) {
        int index = -1;
        int i = 0;
        while (index == -1 && i < this.selection.length) {
            if (this.selection[i] == item) {
                index = i;
            }
            ++i;
        }
        if (index != -1) {
            TreeItem[] newSelection = new TreeItem[this.selection.length - 1];
            System.arraycopy(this.selection, 0, newSelection, 0, index);
            if (index < this.selection.length - 1) {
                int length = this.selection.length - index - 1;
                System.arraycopy(this.selection, index + 1, newSelection, index, length);
            }
            this.selection = newSelection;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        TreeItem item;
        int i;
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (this.getColumnCount() > 0) {
            i = 0;
            while (i < this.getColumnCount()) {
                width += this.getColumn(i).getWidth();
                ++i;
            }
        } else {
            i = 0;
            while (i < this.getItemCount()) {
                item = this.getItem(i);
                if (item.isCached()) {
                    int itemWidth = item.getPreferredWidth(0, false);
                    width = Math.max(width, itemWidth);
                    item.getExpanded();
                }
                ++i;
            }
        }
        height += this.getHeaderHeight();
        height += this.getItemCount() * this.getItemHeight();
        i = 0;
        while (i < this.getItemCount()) {
            item = this.getItem(i);
            if (item.getExpanded()) {
                height += item.getInnerHeight();
            }
            ++i;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += 16;
        }
        if ((this.style & 0x100) != 0) {
            height += 16;
        }
        return new Point(width, height);
    }

    final int getCheckWidth() {
        int result = 0;
        if ((this.style & 0x20) != 0) {
            result = 17;
        }
        return result;
    }

    static void checkAllData(Tree tree) {
        WidgetTreeVisitor.AllWidgetTreeVisitor visitor = new WidgetTreeVisitor.AllWidgetTreeVisitor(){
            int flatIndex = 0;

            public boolean doVisit(Widget widget) {
                boolean result = true;
                if (widget instanceof TreeItem) {
                    TreeItem item = (TreeItem)widget;
                    result = item.getExpanded();
                    TreeItem parentItem = item.getParentItem();
                    int index = parentItem != null ? parentItem.indexOf(item) : Tree.this.indexOf(item);
                    item.flatIndex = this.flatIndex++;
                    if (!item.isCached() && Tree.this.isItemVisible(item)) {
                        Tree.this.checkData(item, index);
                    }
                }
                return result;
            }
        };
        WidgetTreeVisitor.accept(tree, visitor);
    }

    private boolean isItemVisible(TreeItem item) {
        boolean result = false;
        int itemPosition = item.getBounds((int)0, (boolean)false).y;
        if (itemPosition >= 0 && itemPosition <= this.getSize().y) {
            TreeItem parentItem = item.getParentItem();
            if (parentItem != null) {
                if (parentItem.getExpanded()) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    void updateFlatIndices() {
        int flatIndex = 0;
        TreeItem[] uItems = this.getItems();
        int i = 0;
        while (i < uItems.length) {
            TreeItem treeItem = uItems[i];
            treeItem.flatIndex = flatIndex++;
            flatIndex = this.updateFlatIndicesSub(treeItem, flatIndex);
            ++i;
        }
    }

    int updateFlatIndicesSub(TreeItem item, int flatIndex) {
        int newFlatIndex = flatIndex;
        if (item.getExpanded()) {
            TreeItem[] subItems = item.getItems();
            int i = 0;
            while (i < subItems.length) {
                TreeItem subItem = subItems[i];
                subItem.flatIndex = newFlatIndex++;
                newFlatIndex = this.updateFlatIndicesSub(subItem, newFlatIndex);
                ++i;
            }
        }
        return newFlatIndex;
    }

    /*
     * Exception decompiling
     */
    final void checkData(TreeItem item, int index) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 88->92)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int checkStyle(int style) {
        int result = style | 0x100 | 0x200;
        return Tree.checkBits(result, 4, 2, 0, 0, 0, 0);
    }

    private final class CompositeItemHolder
    implements IItemHolderAdapter {
        private CompositeItemHolder() {
        }

        public void add(Item item) {
            if (item instanceof TreeItem) {
                Tree.this.itemHolder.add(item);
            } else {
                Tree.this.columnHolder.add(item);
            }
        }

        public void insert(Item item, int index) {
            if (item instanceof TreeItem) {
                Tree.this.itemHolder.insert(item, index);
            } else {
                Tree.this.columnHolder.insert(item, index);
            }
        }

        public void remove(Item item) {
            if (item instanceof TreeItem) {
                Tree.this.itemHolder.remove(item);
            } else {
                Tree.this.columnHolder.remove(item);
            }
        }

        public Item[] getItems() {
            TreeItem[] items = (TreeItem[])Tree.this.itemHolder.getItems();
            Item[] columns = Tree.this.columnHolder.getItems();
            Item[] result = new Item[items.length + columns.length];
            System.arraycopy(columns, 0, result, 0, columns.length);
            System.arraycopy(items, 0, result, columns.length, items.length);
            return result;
        }
    }

    private static final class ExpandListener
    extends TreeAdapter {
        private ExpandListener() {
        }

        public void treeExpanded(TreeEvent event) {
            Tree tree = (Tree)event.widget;
            tree.updateFlatIndices();
            Tree.checkAllData(tree);
        }

        public void treeCollapsed(TreeEvent event) {
            Tree tree = (Tree)event.widget;
            tree.updateFlatIndices();
        }
    }

    private final class InternalTreeAdapter
    implements ITreeAdapter {
        private InternalTreeAdapter() {
        }

        public TreeItem getShowItem() {
            return Tree.this.showItem;
        }

        public void clearShowItem() {
            Tree.this.showItem = null;
        }

        public void setScrollLeft(int left) {
            Tree.this.scrollLeft = left;
        }

        public void setScrollTop(int top) {
            Tree.this.scrollTop = top;
        }

        public int getScrollTop() {
            return Tree.this.scrollTop;
        }

        public int getScrollLeft() {
            return Tree.this.scrollLeft;
        }

        public boolean isCached(TreeItem item) {
            return item.isCached();
        }

        public void checkAllData(Tree tree) {
            Tree.checkAllData(tree);
        }
    }

    private static final class ResizeListener
    extends ControlAdapter {
        private ResizeListener() {
        }

        public void controlResized(ControlEvent event) {
            Tree.checkAllData((Tree)event.widget);
        }
    }
}

