/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views;

import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.debug.core.IPDebugEventListener;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.event.IPDebugEvent;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class AbstractPDebugViewEventHandler
implements IPDebugEventListener {
    private IViewPart fView;
    protected PDebugEventWorkbenchJob eventWorkbenchJob = new PDebugEventWorkbenchJob();

    public AbstractPDebugViewEventHandler(IViewPart view) {
        this.setView(view);
        PTPDebugCorePlugin.getDefault().addDebugEventListener((IPDebugEventListener)this);
    }

    public void dispose() {
        PTPDebugCorePlugin.getDefault().removeDebugEventListener((IPDebugEventListener)this);
    }

    protected IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public void handleDebugEvent(IPDebugEvent event) {
        this.eventWorkbenchJob.addEvent(event);
    }

    protected abstract void doHandleDebugEvent(IPDebugEvent var1, IProgressMonitor var2);

    protected abstract void refresh(boolean var1);

    public void refresh() {
        this.refresh(false);
    }

    protected IViewPart getView() {
        return this.fView;
    }

    private void setView(IViewPart view) {
        this.fView = view;
    }

    class PDebugEventWorkbenchJob
    extends WorkbenchJob {
        Vector<IPDebugEvent> events;

        PDebugEventWorkbenchJob() {
            super("Handling Debug Event");
            this.events = new Vector(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            IPDebugEvent[] pEvents;
            Vector<IPDebugEvent> vector = this.events;
            synchronized (vector) {
                pEvents = this.events.toArray(new IPDebugEvent[0]);
                this.events.clear();
            }
            IPDebugEvent[] iPDebugEventArray = pEvents;
            int n = pEvents.length;
            int n2 = 0;
            while (n2 < n) {
                IPDebugEvent e = iPDebugEventArray[n2];
                AbstractPDebugViewEventHandler.this.doHandleDebugEvent(e, monitor);
                ++n2;
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEvent(IPDebugEvent event) {
            Vector<IPDebugEvent> vector = this.events;
            synchronized (vector) {
                this.events.add(event);
            }
            this.schedule();
        }
    }
}

