/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.samples.dynamic.consumer;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Message;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.core.MessageImpl;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class SimpleClient
implements InitializingBean {
    private static final Log LOG = LogFactory.getLog(SimpleClient.class);
    private String dataToSend;
    private String interfaceName;
    private String consumerPolicyName;
    private String operationName;
    private Integer delayBeforeSending = 8000;
    private NMR nmr;

    private void checkConstraints() {
        Assert.notNull((Object)this.dataToSend, (String)"dataToSend property is compulsory");
        Assert.notNull((Object)this.nmr, (String)"nmr property is compulsory");
    }

    public void start() {
        this.checkConstraints();
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                try {
                    SimpleClient.this.sendRequestSynchronously();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, this.delayBeforeSending.intValue());
    }

    public void sendRequestSynchronously() throws Exception {
        Channel dc = this.nmr.createChannel();
        Exchange ex = dc.createExchange(Pattern.InOut);
        MessageImpl msg = new MessageImpl();
        StreamSource src = new StreamSource(new ByteArrayInputStream(this.dataToSend.getBytes()));
        msg.setBody((Object)src);
        ex.setIn((Message)msg);
        ex.setProperty("javax.jbi.InterfaceName", (Object)QName.valueOf(this.interfaceName));
        if (this.consumerPolicyName != null && this.consumerPolicyName.length() > 0) {
            ex.setProperty("org.eclipse.swordfish.policy.ConsumerName", (Object)QName.valueOf(this.consumerPolicyName));
        }
        ex.setOperation(QName.valueOf(this.operationName));
        HashMap<String, String> targetProps = new HashMap<String, String>();
        targetProps.put("ENDPOINT_NAME", "JustDummyEndpointName");
        ex.setTarget(this.nmr.getEndpointRegistry().lookup(targetProps));
        LOG.info((Object)("!!SimpleClient is sending synchronous request with in message " + this.dataToSend));
        dc.sendSync(ex);
        if (ex.getError() != null) {
            LOG.error((Object)"The invocation wasn't successful", (Throwable)ex.getError());
        }
        if (ex.getFault() != null && ex.getFault().getBody() != null) {
            LOG.error((Object)("The invocation wasn't successful " + ex.getFault().getBody().toString()));
        }
        LOG.info((Object)("!!SimpleClient have received the response: " + new SourceTransformer().toString((Source)ex.getOut().getBody(Source.class))));
    }

    public String getDataToSend() {
        return this.dataToSend;
    }

    public void setDataToSend(String dataToSend) {
        this.dataToSend = dataToSend;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getConsumerPolicyName() {
        return this.consumerPolicyName;
    }

    public void setConsumerPolicyName(String consumerPolicyName) {
        this.consumerPolicyName = consumerPolicyName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public Integer getDelayBeforeSending() {
        return this.delayBeforeSending;
    }

    public void setDelayBeforeSending(Integer delayBeforeSending) {
        this.delayBeforeSending = delayBeforeSending;
    }

    public NMR getNmr() {
        return this.nmr;
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }
}

