/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.samples.configuration;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.SwordfishContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ConfigurationProvider
implements InitializingBean {
    private static final Log LOG = LogFactory.getLog(ConfigurationProvider.class);
    private SwordfishContext swordfishContext;
    private String id;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setContext(SwordfishContext swordfishContext) {
        this.swordfishContext = swordfishContext;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.id);
        final HashMap<String, String> configData = new HashMap<String, String>();
        configData.put("testProperty1", "Updated by ConfigurationProvider");
        configData.put("currentDateTime", DateFormat.getDateTimeInstance().format(new Date()));
        LOG.info((Object)"Updating configuration");
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                ConfigurationProvider.this.swordfishContext.getConfigurationService().updateConfiguration(ConfigurationProvider.this.id, configData);
            }
        }, 5000L);
    }
}

