/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import java.math.BigInteger;
import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.BigIntegerAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BigIntegerAttribute
extends AbstractAttribute<BigInteger, BigIntegerAttribute, BigIntegerAttributeDefinition> {
    private BigInteger value;

    public BigIntegerAttribute(BigIntegerAttributeDefinition definition, BigInteger initialValue) throws IllegalValueException {
        super(definition);
        this.setValue(initialValue);
    }

    public BigIntegerAttribute(BigIntegerAttributeDefinition definition, String initialValue) throws IllegalValueException {
        super(definition);
        this.setValueAsString(initialValue);
    }

    public BigIntegerAttribute(BigIntegerAttributeDefinition definition, Integer value) throws IllegalValueException {
        this(definition, BigInteger.valueOf(value.intValue()));
    }

    @Override
    public synchronized BigInteger getValue() {
        return this.value;
    }

    @Override
    public synchronized String getValueAsString() {
        return this.value.toString();
    }

    @Override
    public boolean isValid(String string) {
        try {
            BigInteger val = new BigInteger(string);
            return val.compareTo(this.getMinValue()) >= 0 && val.compareTo(this.getMaxValue()) <= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public synchronized void setValue(BigInteger value) throws IllegalValueException {
        if (value.compareTo(this.getMinValue()) < 0 || value.compareTo(this.getMaxValue()) > 0) {
            throw new IllegalValueException(Messages.BigIntegerAttribute_0);
        }
        this.value = value;
    }

    @Override
    public synchronized void setValue(Integer ivalue) throws IllegalValueException {
        BigInteger value = BigInteger.valueOf(ivalue.intValue());
        if (value.compareTo(this.getMinValue()) < 0 || value.compareTo(this.getMaxValue()) > 0) {
            throw new IllegalValueException(Messages.BigIntegerAttribute_1);
        }
        this.value = value;
    }

    @Override
    public synchronized void setValueAsString(String string) throws IllegalValueException {
        try {
            BigInteger value = new BigInteger(string);
            if (value.compareTo(this.getMinValue()) < 0 || value.compareTo(this.getMaxValue()) > 0) {
                throw new IllegalValueException(Messages.BigIntegerAttribute_2);
            }
            this.value = value;
        }
        catch (NumberFormatException e) {
            throw new IllegalValueException(e);
        }
    }

    private BigInteger getMinValue() {
        return ((BigIntegerAttributeDefinition)this.getDefinition()).getMinValue();
    }

    private BigInteger getMaxValue() {
        return ((BigIntegerAttributeDefinition)this.getDefinition()).getMaxValue();
    }

    @Override
    protected BigIntegerAttribute doCopy() {
        try {
            return new BigIntegerAttribute((BigIntegerAttributeDefinition)this.getDefinition(), this.value);
        }
        catch (IllegalValueException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected synchronized int doCompareTo(BigIntegerAttribute other) {
        return this.value.compareTo(other.value);
    }

    @Override
    protected synchronized boolean doEquals(BigIntegerAttribute other) {
        return this.value.equals(other.value);
    }

    @Override
    protected synchronized int doHashCode() {
        return this.value.hashCode();
    }
}

