/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ptp.core.attributes.AbstractAttributeDefinition;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumeratedAttributeDefinition<E extends Enum<E>>
extends AbstractAttributeDefinition<E, EnumeratedAttribute<E>, EnumeratedAttributeDefinition<E>> {
    private final E defaultValue;
    private final Class<E> enumClass;

    public EnumeratedAttributeDefinition(String uniqueId, String name, String description, boolean display, E defaultValueIn) {
        super(uniqueId, name, description, display);
        Class<?> eClass = defaultValueIn.getClass();
        this.enumClass = eClass;
        this.defaultValue = defaultValueIn;
    }

    @Override
    public EnumeratedAttribute<E> create() {
        return new EnumeratedAttribute<E>(this, this.defaultValue);
    }

    public EnumeratedAttribute<E> create(E value) {
        return new EnumeratedAttribute<E>(this, value);
    }

    public EnumeratedAttribute<E> create(int value) throws IllegalValueException {
        return new EnumeratedAttribute<int>((EnumeratedAttributeDefinition<int>)this, value);
    }

    @Override
    public EnumeratedAttribute<E> create(String value) throws IllegalValueException {
        return new EnumeratedAttribute<String>((EnumeratedAttributeDefinition<String>)this, value);
    }

    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    public List<E> getEnumerations() {
        return Arrays.asList((Enum[])this.enumClass.getEnumConstants());
    }

    public List<String> getEnumerationStrings() {
        List<E> values = this.getEnumerations();
        ArrayList<String> strings = new ArrayList<String>(values.size());
        for (Enum value : values) {
            strings.add(value.toString());
        }
        return strings;
    }
}

