/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.elementcontrols.IPElementControl;
import org.eclipse.ptp.core.elementcontrols.IPMachineControl;
import org.eclipse.ptp.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.core.elementcontrols.IPProcessControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.attributes.NodeAttributes;
import org.eclipse.ptp.core.elements.events.IChangedProcessEvent;
import org.eclipse.ptp.core.elements.events.INewProcessEvent;
import org.eclipse.ptp.core.elements.events.IRemoveProcessEvent;
import org.eclipse.ptp.core.elements.listeners.IJobChildListener;
import org.eclipse.ptp.core.elements.listeners.INodeChildListener;
import org.eclipse.ptp.core.elements.listeners.INodeListener;
import org.eclipse.ptp.internal.core.elements.Parent;
import org.eclipse.ptp.internal.core.elements.events.ChangedProcessEvent;
import org.eclipse.ptp.internal.core.elements.events.NewProcessEvent;
import org.eclipse.ptp.internal.core.elements.events.NodeChangeEvent;
import org.eclipse.ptp.internal.core.elements.events.RemoveProcessEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PNode
extends Parent
implements IPNodeControl,
IJobChildListener {
    private final ListenerList elementListeners = new ListenerList();
    private final ListenerList childListeners = new ListenerList();

    public PNode(String id, IPMachineControl mac, IAttribute<?, ?, ?>[] attrs) {
        super(id, mac, 12, attrs);
        IAttribute nodeState = (EnumeratedAttribute)this.getAttribute(NodeAttributes.getStateAttributeDefinition());
        if (nodeState == null) {
            nodeState = NodeAttributes.getStateAttributeDefinition().create();
            this.addAttribute(nodeState);
        }
    }

    @Override
    public void addChildListener(INodeChildListener listener) {
        this.childListeners.add((Object)listener);
    }

    @Override
    public void addElementListener(INodeListener listener) {
        this.elementListeners.add((Object)listener);
    }

    @Override
    public void addProcesses(Collection<IPProcessControl> processControls) {
        ArrayList<IPProcess> procs = new ArrayList<IPProcess>(processControls.size());
        HashSet<IPJob> jobs = new HashSet<IPJob>();
        for (IPProcessControl process : processControls) {
            this.addChild(process);
            process.addNode(this);
            jobs.add(process.getJob());
            procs.add(process);
        }
        for (IPJob job : jobs) {
            job.addChildListener(this);
        }
        this.fireNewProcesses(procs);
    }

    @Override
    public IPMachine getMachine() {
        return this.getMachineControl();
    }

    @Override
    public IPMachineControl getMachineControl() {
        IPElementControl current = this;
        do {
            if (!(current instanceof IPMachineControl)) continue;
            return (IPMachineControl)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @Override
    public String getNodeNumber() {
        IntegerAttribute num = (IntegerAttribute)this.getAttribute(NodeAttributes.getNumberAttributeDefinition());
        if (num != null) {
            return num.getValueAsString();
        }
        return "";
    }

    @Override
    public Collection<IPProcessControl> getProcessControls() {
        IPElementControl[] children = this.getChildren();
        ArrayList<IPProcessControl> processes = new ArrayList<IPProcessControl>(children.length);
        IPElementControl[] iPElementControlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPElementControl element = iPElementControlArray[n2];
            processes.add((IPProcessControl)element);
            ++n2;
        }
        return processes;
    }

    @Override
    public IPProcess[] getProcesses() {
        return this.getProcessControls().toArray(new IPProcess[this.getProcessControls().size()]);
    }

    @Override
    public NodeAttributes.State getState() {
        return (NodeAttributes.State)((Object)((EnumeratedAttribute)this.getAttribute(NodeAttributes.getStateAttributeDefinition())).getValue());
    }

    @Override
    public void handleEvent(IChangedProcessEvent e) {
        this.fireChangedProcesses(e.getProcesses());
    }

    @Override
    public void handleEvent(IRemoveProcessEvent e) {
        for (IPProcess process : e.getProcesses()) {
            this.removeChild((IPProcessControl)process);
        }
        this.fireRemoveProcesses(e.getProcesses());
    }

    @Override
    public void handleEvent(INewProcessEvent e) {
    }

    @Override
    public void removeChildListener(INodeChildListener listener) {
        this.childListeners.remove((Object)listener);
    }

    @Override
    public void removeElementListener(INodeListener listener) {
        this.elementListeners.remove((Object)listener);
    }

    @Override
    public void removeProcesses(Collection<IPProcessControl> processControls) {
        ArrayList<IPProcess> processes = new ArrayList<IPProcess>(processControls.size());
        for (IPProcessControl process : processControls) {
            this.removeChild(process);
            process.removeNode();
            processes.add(process);
        }
        this.fireRemoveProcesses(processes);
    }

    private void fireChangedNode(AttributeManager attrs) {
        NodeChangeEvent e = new NodeChangeEvent(this, attrs);
        Object[] objectArray = this.elementListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((INodeListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireNewProcesses(Collection<IPProcess> processes) {
        NewProcessEvent e = new NewProcessEvent(this, processes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((INodeChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireRemoveProcesses(Collection<IPProcess> processes) {
        RemoveProcessEvent e = new RemoveProcessEvent(this, processes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((INodeChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireChangedProcesses(Collection<IPProcess> processes) {
        ChangedProcessEvent e = new ChangedProcessEvent(this, processes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((INodeChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attrs) {
        this.fireChangedNode(attrs);
    }
}

