/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.attributes.StringAttributeDefinition;
import org.eclipse.ptp.core.elementcontrols.IPElementControl;
import org.eclipse.ptp.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.core.elementcontrols.IPProcessControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.elements.listeners.IProcessListener;
import org.eclipse.ptp.core.util.OutputTextFile;
import org.eclipse.ptp.internal.core.elements.Parent;
import org.eclipse.ptp.internal.core.elements.events.ProcessChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PProcess
extends Parent
implements IPProcessControl {
    private final ListenerList elementListeners = new ListenerList();
    private final OutputTextFile outputFile;
    private String outputDirPath = null;
    private int storeLines = 0;
    private IPNodeControl node;

    public PProcess(String id, IPJobControl job, IAttribute<?, ?, ?>[] attrs) {
        super(id, job, 14, attrs);
        StringAttribute signalName;
        IntegerAttribute index;
        IntegerAttribute pid;
        IntegerAttribute exitCode;
        this.setOutputStore();
        String name = String.valueOf(job.getQueue().getResourceManager().getName()) + "_" + job.getQueue().getName() + "_" + job.getName() + "_" + this.getName();
        this.outputFile = new OutputTextFile(name, ProcessAttributes.getStdoutAttributeDefinition().getId(), this.outputDirPath, this.storeLines);
        IAttribute procState = (EnumeratedAttribute)this.getAttribute(ProcessAttributes.getStateAttributeDefinition());
        if (procState == null) {
            procState = ProcessAttributes.getStateAttributeDefinition().create();
            this.addAttribute(procState);
        }
        if ((exitCode = (IntegerAttribute)this.getAttribute(ProcessAttributes.getExitCodeAttributeDefinition())) == null) {
            try {
                exitCode = ProcessAttributes.getExitCodeAttributeDefinition().create();
                this.addAttribute(exitCode);
            }
            catch (IllegalValueException illegalValueException) {}
        }
        if ((pid = (IntegerAttribute)this.getAttribute(ProcessAttributes.getPIDAttributeDefinition())) == null) {
            try {
                pid = ProcessAttributes.getPIDAttributeDefinition().create();
                this.addAttribute(pid);
            }
            catch (IllegalValueException illegalValueException) {}
        }
        if ((index = (IntegerAttribute)this.getAttribute(ProcessAttributes.getIndexAttributeDefinition())) == null) {
            try {
                index = ProcessAttributes.getIndexAttributeDefinition().create();
                this.addAttribute(index);
            }
            catch (IllegalValueException illegalValueException) {}
        }
        if ((signalName = (StringAttribute)this.getAttribute(ProcessAttributes.getSignalNameAttributeDefinition())) == null) {
            signalName = ProcessAttributes.getSignalNameAttributeDefinition().create();
            this.addAttribute(signalName);
        }
    }

    @Override
    public void addElementListener(IProcessListener listener) {
        this.elementListeners.add((Object)listener);
    }

    @Override
    public synchronized void addNode(IPNode node) {
        this.node = (IPNodeControl)node;
    }

    @Override
    public void clearOutput() {
        this.outputFile.delete();
    }

    @Override
    public int getExitCode() {
        return ((IntegerAttribute)this.getAttribute(ProcessAttributes.getExitCodeAttributeDefinition())).getValue();
    }

    @Override
    public IPJob getJob() {
        return this.getJobControl();
    }

    @Override
    public IPJobControl getJobControl() {
        IPElementControl current = this;
        do {
            if (!(current instanceof IPJobControl)) continue;
            return (IPJobControl)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @Override
    public synchronized IPNode getNode() {
        return this.node;
    }

    @Override
    public int getPid() {
        return ((IntegerAttribute)this.getAttribute(ProcessAttributes.getPIDAttributeDefinition())).getValue();
    }

    @Override
    public String getProcessIndex() {
        return ((IntegerAttribute)this.getAttribute(ProcessAttributes.getIndexAttributeDefinition())).getValueAsString();
    }

    @Override
    public String getSavedOutput(StringAttributeDefinition attrDef) {
        if (attrDef.equals(ProcessAttributes.getStdoutAttributeDefinition())) {
            return this.outputFile.getContents();
        }
        return "";
    }

    @Override
    public String getSignalName() {
        return ((StringAttribute)this.getAttribute(ProcessAttributes.getSignalNameAttributeDefinition())).getValue();
    }

    @Override
    public ProcessAttributes.State getState() {
        return (ProcessAttributes.State)((Object)((EnumeratedAttribute)this.getAttribute(ProcessAttributes.getStateAttributeDefinition())).getValue());
    }

    @Override
    public void removeElementListener(IProcessListener listener) {
        this.elementListeners.remove((Object)listener);
    }

    @Override
    public synchronized void removeNode() {
        this.node = null;
    }

    private void addOutput(String output) {
        this.outputFile.write(output);
    }

    private void fireChangedProcess(AttributeManager attrs) {
        ProcessChangeEvent e = new ProcessChangeEvent(this, attrs);
        Object[] objectArray = this.elementListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IProcessListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void setOutputStore() {
        File outputDirectory;
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        this.outputDirPath = preferences.getString("PREFS_OUTPUT_DIR");
        this.storeLines = preferences.getInt("PREFS_STORE_LINES");
        if (this.outputDirPath == null || this.outputDirPath.length() == 0) {
            this.outputDirPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append("output").toOSString();
        }
        if (this.storeLines == 0) {
            this.storeLines = 100;
        }
        if (!(outputDirectory = new File(this.outputDirPath)).exists()) {
            outputDirectory.mkdir();
        }
    }

    @Override
    public void setState(ProcessAttributes.State state) {
        EnumeratedAttribute attr = (EnumeratedAttribute)this.getAttribute(ProcessAttributes.getStateAttributeDefinition());
        attr.setValue(state);
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttribute(attr);
        this.fireChangedProcess(attrMgr);
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attrs) {
        StringAttribute attr = (StringAttribute)attrs.getAttribute(ProcessAttributes.getStdoutAttributeDefinition());
        if (attr != null) {
            this.addOutput(attr.getValue());
        }
        this.fireChangedProcess(attrs);
    }
}

