/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.rtsystem.IRuntimeEventListener;
import org.eclipse.ptp.rtsystem.IRuntimeSystem;
import org.eclipse.ptp.rtsystem.events.IRuntimeAttributeDefinitionEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeConnectedStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeErrorStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeJobChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeMachineChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeMessageEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewJobEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewMachineEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewNodeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewProcessEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewQueueEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNodeChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeProcessChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeQueueChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRMChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveAllEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveJobEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveMachineEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveNodeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveProcessEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveQueueEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRunningStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeShutdownStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeStartupErrorEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeSubmitJobErrorEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeTerminateJobErrorEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuntimeSystem
implements IRuntimeSystem {
    private final ListenerList listeners = new ListenerList();

    @Override
    public void addRuntimeEventListener(IRuntimeEventListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeRuntimeEventListener(IRuntimeEventListener listener) {
        this.listeners.remove((Object)listener);
    }

    public IAttribute<?, ?, ?>[] getLaunchAttributes(String machineName, String queueName, IAttribute<?, ?, ?>[] currentAttrs) {
        return null;
    }

    public void removeJob(IPJob job) {
    }

    protected void fireRuntimeMessageEvent(IRuntimeMessageEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeAttributeDefinitionEvent(IRuntimeAttributeDefinitionEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeConnectedStateEvent(IRuntimeConnectedStateEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeErrorStateEvent(IRuntimeErrorStateEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeJobChangeEvent(IRuntimeJobChangeEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeMachineChangeEvent(IRuntimeMachineChangeEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeNodeChangeEvent(IRuntimeNodeChangeEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeProcessChangeEvent(IRuntimeProcessChangeEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeQueueChangeEvent(IRuntimeQueueChangeEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeNewJobEvent(IRuntimeNewJobEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeNewMachineEvent(IRuntimeNewMachineEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeNewNodeEvent(IRuntimeNewNodeEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeNewProcessEvent(IRuntimeNewProcessEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeNewQueueEvent(IRuntimeNewQueueEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeRemoveAllEvent(IRuntimeRemoveAllEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeRemoveJobEvent(IRuntimeRemoveJobEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeRemoveMachineEvent(IRuntimeRemoveMachineEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeRemoveNodeEvent(IRuntimeRemoveNodeEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeRemoveProcessEvent(IRuntimeRemoveProcessEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeRemoveQueueEvent(IRuntimeRemoveQueueEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeRMChangeEvent(IRuntimeRMChangeEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeRunningStateEvent(IRuntimeRunningStateEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeShutdownStateEvent(IRuntimeShutdownStateEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeStartupErrorEvent(IRuntimeStartupErrorEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeSubmitJobErrorEvent(IRuntimeSubmitJobErrorEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }

    protected void fireRuntimeTerminateJobErrorEvent(IRuntimeTerminateJobErrorEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRuntimeEventListener)listener).handleEvent(event);
            ++n2;
        }
    }
}

