/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.jasper;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.servlet.Servlet;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.xmlparser.ParserUtils;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelper;
import org.eclipse.jetty.osgi.boot.utils.WebappRegistrationCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebappRegistrationCustomizerImpl
implements WebappRegistrationCustomizer {
    public WebappRegistrationCustomizerImpl() {
        this.fixupDtdResolution();
        try {
            Class<?> cl = this.getClass().getClassLoader().loadClass("org.apache.jasper.servlet.JspServlet");
        }
        catch (Exception e) {
            System.err.println("Unable to locate the JspServlet: jsp support unavailable.");
            e.printStackTrace();
            return;
        }
        try {
            JspFactory fact = JspFactory.getDefaultFactory();
            if (fact == null) {
                fact = (JspFactory)JettyBootstrapActivator.class.getClassLoader().loadClass("org.apache.jasper.runtime.JspFactoryImpl").newInstance();
                JspFactory.setDefaultFactory((JspFactory)fact);
            }
        }
        catch (Exception e) {
            System.err.println("Unable to set the JspFactory: jsp support incomplete.");
            e.printStackTrace();
        }
    }

    public URL[] getJarsWithTlds(BundleFileLocatorHelper locatorHelper) throws Exception {
        Bundle jasperBundler = FrameworkUtil.getBundle(TldLocationsCache.class);
        File jasperLocation = locatorHelper.getBundleInstallLocation(jasperBundler);
        if (jasperLocation.isDirectory()) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (File f : jasperLocation.listFiles()) {
                if (f.getName().endsWith(".jar") && f.isFile()) {
                    urls.add(f.toURI().toURL());
                    continue;
                }
                if (!f.isDirectory() || !f.getName().equals("lib")) continue;
                for (File f2 : jasperLocation.listFiles()) {
                    if (!f2.getName().endsWith(".jar") || !f2.isFile()) continue;
                    urls.add(f2.toURI().toURL());
                }
            }
            return urls.toArray(new URL[urls.size()]);
        }
        return new URL[]{jasperLocation.toURI().toURL()};
    }

    void fixupDtdResolution() {
        try {
            ParserUtils.setEntityResolver((EntityResolver)new MyFixedupEntityResolver());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class MyFixedupEntityResolver
    implements EntityResolver {
        static final String[] CACHED_DTD_PUBLIC_IDS = new String[]{"-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN"};
        static final String[] CACHED_DTD_RESOURCE_PATHS = new String[]{"/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", "/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", "/javax/servlet/resources/web-app_2_2.dtd", "/javax/servlet/resources/web-app_2_3.dtd"};

        MyFixedupEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            for (int i = 0; i < CACHED_DTD_PUBLIC_IDS.length; ++i) {
                String cachedDtdPublicId = CACHED_DTD_PUBLIC_IDS[i];
                if (!cachedDtdPublicId.equals(publicId)) continue;
                String resourcePath = CACHED_DTD_RESOURCE_PATHS[i];
                InputStream input = null;
                input = Servlet.class.getResourceAsStream(resourcePath);
                if (input == null && (input = JspContext.class.getResourceAsStream(resourcePath)) == null) {
                    input = this.getClass().getResourceAsStream(resourcePath);
                }
                if (input == null) {
                    throw new SAXException(Localizer.getMessage((String)"jsp.error.internal.filenotfound", (String)resourcePath));
                }
                InputSource isrc = new InputSource(input);
                return isrc;
            }
            return null;
        }
    }
}

