/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.data;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remotetools.environment.launcher.RemoteLauncherPlugin;
import org.eclipse.ptp.remotetools.environment.launcher.data.ISynchronizationRule;
import org.eclipse.ptp.remotetools.environment.launcher.data.Messages;

public class ExecutionConfiguration {
    ICProject cProject = null;
    File executable = null;
    boolean doConnectStreams = true;
    boolean doForwardX11 = false;
    boolean doAllocateTerminal = true;
    IPath remoteDirectory = null;
    File workingDirectory = null;
    List arguments = new ArrayList();
    List environmentVariables = new ArrayList();
    String beforeCommand = null;
    String afterCommand = null;
    boolean synchronizeAfter = false;
    boolean synchronizeBefore = false;
    boolean doCleanup = false;
    List synchronizationRules = new ArrayList();
    String label;
    static int counter = 0;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean getDoCleanup() {
        return this.doCleanup;
    }

    public void setDoCleanup(boolean doCleanup) {
        this.doCleanup = doCleanup;
    }

    public String[] getArgumentsArray() {
        String[] array = new String[this.arguments.size()];
        this.arguments.toArray(array);
        return array;
    }

    public void addArgument(String argument) {
        this.arguments.add(argument);
    }

    public void addArguments(String[] argumentsArray) {
        int i = 0;
        while (i < argumentsArray.length) {
            String argument = argumentsArray[i];
            this.addArgument(argument);
            ++i;
        }
    }

    public boolean getDoConnectStreams() {
        return this.doConnectStreams;
    }

    public void setDoConnectStream(boolean doConnect) {
        this.doConnectStreams = doConnect;
    }

    public boolean getDoForwardX11() {
        return this.doForwardX11;
    }

    public void setDoForwardX11(boolean doForward) {
        this.doForwardX11 = doForward;
    }

    public ICProject getProject() {
        return this.cProject;
    }

    public void setProject(ICProject project) {
        this.cProject = project;
    }

    public String[] getEnvironmentVariablesArray() {
        String[] array = new String[this.environmentVariables.size()];
        this.environmentVariables.toArray(array);
        return array;
    }

    public void addEnvironmentVariable(String variable) {
        this.environmentVariables.add(variable);
    }

    public void addEnvironmentVariables(String[] environmentArray) {
        int i = 0;
        while (i < environmentArray.length) {
            String string = environmentArray[i];
            this.addEnvironmentVariable(string);
            ++i;
        }
    }

    public File getExecutableFile() {
        return this.executable;
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }

    public IPath getRemoteDirectoryPath() {
        return this.remoteDirectory;
    }

    public void setRemoteDirectory(IPath remoteDirectory) {
        this.remoteDirectory = remoteDirectory;
    }

    public File getWorkingDirectoryFile() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public IPath getRemoteExecutablePath() {
        Path localExecutable = new Path(this.executable.getPath());
        IPath remoteExecutable = this.remoteDirectory.append(localExecutable.lastSegment());
        return remoteExecutable;
    }

    public String getRemoteExecutableName() {
        return this.getRemoteExecutablePath().lastSegment();
    }

    public void setBeforeCommand(String beforeCommand) {
        this.beforeCommand = beforeCommand;
    }

    public void setAfterCommand(String afterCommand) {
        this.afterCommand = afterCommand;
    }

    public void setDoSynchronizeAfter(boolean synchronizeAfter) {
        this.synchronizeAfter = synchronizeAfter;
    }

    public void setDoSynchronizeBefore(boolean synchronizeBefore) {
        this.synchronizeBefore = synchronizeBefore;
    }

    public String getAfterCommand() {
        return this.afterCommand;
    }

    public String getBeforeCommand() {
        return this.beforeCommand;
    }

    public boolean getDoSynchronizeAfter() {
        return this.synchronizeAfter;
    }

    public boolean getDoSynchronizeBefore() {
        return this.synchronizeBefore;
    }

    public ISynchronizationRule[] getSynchronizationRulesArray() {
        ISynchronizationRule[] array = this.synchronizationRules.toArray(new ISynchronizationRule[this.synchronizationRules.size()]);
        return array;
    }

    public void addSynchronizationRule(ISynchronizationRule rule) {
        this.synchronizationRules.add(rule);
    }

    public void addSynchronizationRules(ISynchronizationRule[] rules) {
        int i = 0;
        while (i < rules.length) {
            ISynchronizationRule rule = rules[i];
            this.addSynchronizationRule(rule);
            ++i;
        }
    }

    public int countSynchronizationRules() {
        return this.synchronizationRules.size();
    }

    public int countUploadRules() {
        int result = 0;
        for (ISynchronizationRule element : this.synchronizationRules) {
            if (!element.isUploadRule()) continue;
            ++result;
        }
        return result;
    }

    public int countDownloadRules() {
        int result = 0;
        for (ISynchronizationRule element : this.synchronizationRules) {
            if (!element.isDownloadRule()) continue;
            ++result;
        }
        return result;
    }

    public void setDoAllocateTerminal(boolean allocateTerminal) {
        this.doAllocateTerminal = allocateTerminal;
    }

    public boolean getDoAllocateTerminal() {
        return this.doAllocateTerminal;
    }

    public void validate() throws CoreException {
        if (this.cProject == null) {
            RemoteLauncherPlugin.throwCoreException(Messages.ExecutionConfiguration_Error_MissingProject, 2);
        }
        if (this.executable == null) {
            RemoteLauncherPlugin.throwCoreException(Messages.ExecutionConfiguration_Error_MissingExecutable, 2);
        }
        if (this.remoteDirectory == null) {
            RemoteLauncherPlugin.throwCoreException(Messages.ExecutionConfiguration_Error_MissingRemoteWorkingDirectory, 2);
        }
        if (this.workingDirectory == null) {
            RemoteLauncherPlugin.throwCoreException(Messages.ExecutionConfiguration_Error_MissingLocalRemoteDirectory, 2);
        }
    }
}

