/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.android;

import java.awt.Dimension;
import java.util.HashMap;
import org.eclipse.sequoyah.localization.android.i18n.Messages;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleAttribute;

public class AndroidLocaleAttribute
extends LocaleAttribute {
    public static final int INDEX_COUNTRY_CODE = 0;
    public static final int INDEX_NETWORK_CODE = 1;
    public static final int INDEX_LANGUAGE = 2;
    public static final int INDEX_REGION = 3;
    public static final int INDEX_SCREEN_ORIENTATION = 4;
    public static final int INDEX_PIXEL_DENSITY = 5;
    public static final int INDEX_TOUCH_TYPE = 6;
    public static final int INDEX_KEYBOARD_STATE = 7;
    public static final int INDEX_TEXT_INPUT_METHOD = 8;
    public static final int INDEX_NAVIGATION_METHOD = 9;
    public static final int INDEX_SCREEN_DIMENSION = 10;
    public static final int INDEX_COUNT = 11;
    private int androidType;
    private String stringValue = "";
    protected boolean isSet = false;

    public AndroidLocaleAttribute(Object object, int n) {
        super("", LocaleAttribute.STRING_TYPE, 0, 0, null, "", "");
        this.androidType = n;
        this.setAndroidValue(object);
        this.isSet = false;
    }

    public AndroidLocaleAttribute(String string, int n) {
        super("", LocaleAttribute.STRING_TYPE, 0, 0, null, "", "");
        this.androidType = n;
        Object object = this.getValueAndTypeFromQualifier(string);
        this.setAndroidValue(object);
    }

    public int getAndroidType() {
        return this.androidType;
    }

    private String getCountryCodeFolder(String string) {
        return String.valueOf(Messages.AndroidLocaleAttribute_7) + string;
    }

    private String getLanguageFolder(String string) {
        return string.toLowerCase();
    }

    private String getNetworkCodeFolder(String string) {
        return String.valueOf(Messages.AndroidLocaleAttribute_8) + string;
    }

    private String getPixelFolder(String string) {
        return String.valueOf(string) + Messages.AndroidLocaleAttribute_9;
    }

    private String getRegionCodeFolder(String string) {
        return String.valueOf(Messages.AndroidLocaleAttribute_10) + string.toUpperCase();
    }

    public String getStringValue() {
        return this.stringValue;
    }

    private Object getValueAndTypeFromQualifier(String string) {
        Object object = null;
        switch (this.androidType) {
            case 0: {
                object = string.substring(3);
                break;
            }
            case 1: {
                object = string.substring(3);
                break;
            }
            case 2: {
                object = string;
                break;
            }
            case 3: {
                object = string.substring(1);
                break;
            }
            case 4: {
                object = string;
                break;
            }
            case 5: {
                int n = string.indexOf(Messages.AndroidLocaleAttribute_11);
                object = string.substring(0, n);
                break;
            }
            case 6: {
                object = string;
                break;
            }
            case 7: {
                object = string;
                break;
            }
            default: {
                break;
            }
            case 8: {
                object = string;
                break;
            }
            case 9: {
                object = string;
                break;
            }
            case 10: {
                String[] stringArray = string.split(Messages.AndroidLocaleAttribute_12);
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                object = new Dimension(n, n2);
            }
        }
        return object;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public void setAndroidValue(Object object) {
        switch (this.androidType) {
            case 0: {
                this.setCountryCodeNode(object);
                break;
            }
            case 1: {
                this.setNetworkCodeNode(object);
                break;
            }
            case 2: {
                this.setLanguageNode(object);
                break;
            }
            case 3: {
                this.setRegionNode(object);
                break;
            }
            case 4: {
                this.setOrientationNode(object);
                break;
            }
            case 5: {
                this.setPixelNode(object);
                break;
            }
            case 6: {
                this.setTouchNode(object);
                break;
            }
            case 7: {
                this.setKeyboardNode(object);
                break;
            }
            case 8: {
                this.setTextInputNode(object);
                break;
            }
            case 9: {
                this.setNavigationNode(object);
                break;
            }
            case 10: {
                this.setDimensionNode(object);
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.Unknown_Andr_Type);
            }
        }
        this.isSet = true;
    }

    public void setAttribute() {
        this.isSet = true;
    }

    private void setCountryCodeNode(Object object) {
        this.displayName = Messages.AndroidLocaleAttribute_13;
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 3;
        this.maximumSize = 3;
        this.allowedValues = null;
        this.setIntValue(object);
        this.folderValue = this.getCountryCodeFolder(this.displayValue);
    }

    private void setDimensionNode(Object object) {
        if (!(object instanceof Dimension)) {
            throw new IllegalArgumentException(Messages.Invalid_Andr_Value);
        }
        this.displayName = Messages.AndroidLocaleAttribute_14;
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = null;
        double d = ((Dimension)object).getWidth();
        double d2 = ((Dimension)object).getHeight();
        this.folderValue = this.displayValue = String.valueOf((int)d2) + Messages.AndroidLocaleAttribute_15 + (int)d;
    }

    public void setIntValue(Object object) {
        Integer n = -1;
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof String) {
            n = Integer.parseInt((String)object);
        } else {
            throw new IllegalArgumentException(Messages.Invalid_Andr_Value);
        }
        if (this.fixedSize > 0 && n.toString().length() != this.fixedSize) {
            throw new IllegalArgumentException(String.valueOf(Messages.Invalid_Andr_Value_Size) + this.fixedSize);
        }
        if (this.maximumSize > 0 && n.toString().length() > this.maximumSize) {
            throw new IllegalArgumentException(String.valueOf(Messages.Invalid_Andr_Value_Size) + this.maximumSize);
        }
        this.displayValue = n.toString();
    }

    private void setKeyboardNode(Object object) {
        this.displayName = Messages.AndroidLocaleAttribute_16;
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = new HashMap();
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setLanguageNode(Object object) {
        this.displayName = Messages.AndroidLocaleAttribute_17;
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 2;
        this.maximumSize = 2;
        this.allowedValues = null;
        this.setStringValue(object);
        this.folderValue = this.getLanguageFolder(this.displayValue);
    }

    private void setNavigationNode(Object object) {
        this.displayName = Messages.AndroidLocaleAttribute_18;
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.allowedValues = new HashMap();
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setNetworkCodeNode(Object object) {
        this.displayName = Messages.AndroidLocaleAttribute_19;
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 3;
        this.allowedValues = null;
        this.setIntValue(object);
        this.folderValue = this.getNetworkCodeFolder(this.displayValue);
    }

    private void setOrientationNode(Object object) {
        this.displayName = Messages.AndroidLocaleAttribute_20;
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = new HashMap();
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setPixelNode(Object object) {
        this.displayName = Messages.AndroidLocaleAttribute_21;
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = null;
        this.setStringValue(object);
        this.folderValue = this.getPixelFolder(this.displayValue);
    }

    private void setRegionNode(Object object) {
        this.displayName = Messages.AndroidLocaleAttribute_22;
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 2;
        this.maximumSize = 2;
        this.allowedValues = null;
        this.setStringValue(object);
        this.folderValue = this.getRegionCodeFolder(this.displayValue);
    }

    private void setStringValue(Object object) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException(Messages.Invalid_Andr_Value);
        }
        if (this.type == FIXED_TEXT_TYPE) {
            this.setValuesBasedOnDisplayValue((String)object);
        } else {
            if (this.fixedSize > 0 && ((String)object).length() != this.fixedSize) {
                throw new IllegalArgumentException(String.valueOf(Messages.Invalid_Andr_Value_Size) + this.fixedSize);
            }
            if (this.maximumSize > 0 && ((String)object).length() > this.maximumSize) {
                throw new IllegalArgumentException(String.valueOf(Messages.Invalid_Andr_Value_Size) + this.maximumSize);
            }
            this.displayValue = (String)object;
        }
    }

    public void setStringValue(String string) {
        this.stringValue = string;
    }

    private void setTextInputNode(Object object) {
        this.displayName = Messages.AndroidLocaleAttribute_23;
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setTouchNode(Object object) {
        this.displayName = Messages.AndroidLocaleAttribute_24;
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.setValuesBasedOnDisplayValue((String)object);
    }

    public void unsetAttribute() {
        this.isSet = false;
    }
}

