/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.AbstractContextProvider;
import org.eclipse.help.IContext;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.context.Context;

public class ContextManager {
    private static final String EXTENSION_POINT_ID_CONTEXT = "org.eclipse.help.contexts";
    private static final String ELEMENT_NAME_CONTEXT_PROVIDER = "contextProvider";
    private static final String ATTRIBUTE_NAME_CLASS = "class";
    private Map providersByPluginId;
    private List globalProviders;

    public IContext getContext(String contextId, String locale) {
        int index;
        if (HelpPlugin.DEBUG_CONTEXT && contextId != null) {
            System.out.println("ContextManager.getContext(\"" + contextId + "\")");
        }
        if ((index = contextId.lastIndexOf(46)) != -1) {
            String pluginId = contextId.substring(0, index);
            Iterator iter = this.getContextProviders(pluginId).iterator();
            while (iter.hasNext()) {
                AbstractContextProvider provider = (AbstractContextProvider)iter.next();
                try {
                    IContext context = provider.getContext(contextId, locale);
                    if (context == null) continue;
                    if (HelpPlugin.DEBUG_CONTEXT) {
                        System.out.println("ContextManager.getContext found context, description = \"" + context.getText() + '\"');
                    }
                    return new Context(context, contextId);
                }
                catch (Throwable t) {
                    String msg = "Error querying context provider (" + provider.getClass().getName() + ") with context Id: " + contextId;
                    HelpPlugin.logError(msg, t);
                }
            }
        }
        if (HelpPlugin.DEBUG_CONTEXT) {
            System.out.println("ContextManager.getContext - no context found");
        }
        return null;
    }

    private List getContextProviders(String pluginId) {
        if (this.providersByPluginId == null) {
            this.loadContextProviders();
        }
        ArrayList list = new ArrayList();
        List forPlugin = (List)this.providersByPluginId.get(pluginId);
        if (forPlugin != null) {
            list.addAll(forPlugin);
        }
        list.addAll(this.globalProviders);
        return list;
    }

    private void loadContextProviders() {
        this.providersByPluginId = new HashMap();
        this.globalProviders = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(EXTENSION_POINT_ID_CONTEXT);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement elem = elements[i];
            if (elem.getName().equals(ELEMENT_NAME_CONTEXT_PROVIDER)) {
                try {
                    AbstractContextProvider provider = (AbstractContextProvider)elem.createExecutableExtension(ATTRIBUTE_NAME_CLASS);
                    String[] plugins = provider.getPlugins();
                    if (plugins != null) {
                        int j = 0;
                        while (j < plugins.length) {
                            ArrayList<AbstractContextProvider> list = (ArrayList<AbstractContextProvider>)this.providersByPluginId.get(plugins[j]);
                            if (list == null) {
                                list = new ArrayList<AbstractContextProvider>();
                                this.providersByPluginId.put(plugins[j], list);
                            }
                            list.add(provider);
                            ++j;
                        }
                    } else {
                        this.globalProviders.add(provider);
                    }
                }
                catch (CoreException e) {
                    String msg = "Error instantiating context-sensitive help provider class \"" + elem.getAttribute(ATTRIBUTE_NAME_CLASS) + '\"';
                    HelpPlugin.logError(msg, e);
                }
            }
            ++i;
        }
    }
}

