/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.browser;

import java.util.Enumeration;
import java.util.Locale;
import org.eclipse.rwt.internal.service.ContextProvider;

public abstract class Browser {
    public static final String DEFAULT = "Default";
    public static final String NAVIGATOR_6_UP = "Nav6up";
    public static final String INTERNETEXPLORER_5_UP = "Ie5up";
    private static final String PACKAGE = "org.eclipse.rap.util.browser.";
    private final boolean scriptEnabled;
    private final boolean ajaxEnabled;
    protected boolean ajaxCapable = false;
    private Locale locale;
    private Enumeration locales;
    private String remoteAddr;
    private String remoteHost;

    public Browser(boolean scriptEnabled) {
        this(scriptEnabled, false);
    }

    public Browser(boolean scriptEnabled, boolean ajaxEnabled) {
        this.scriptEnabled = scriptEnabled;
        this.ajaxEnabled = ajaxEnabled;
        this.locale = ContextProvider.getRequest().getLocale();
        this.locales = ContextProvider.getRequest().getLocales();
        this.remoteAddr = ContextProvider.getRequest().getRemoteAddr();
        this.remoteHost = ContextProvider.getRequest().getRemoteHost();
    }

    public Browser(Browser browser) {
        this.scriptEnabled = browser.scriptEnabled;
        this.ajaxEnabled = browser.ajaxEnabled;
        this.ajaxCapable = browser.ajaxCapable;
        this.locale = browser.getLocale();
        this.locales = browser.getLocales();
        this.remoteAddr = browser.getRemoteAddr();
        this.remoteHost = browser.getRemoteHost();
    }

    public boolean isCompatible(String anotherBrowser) {
        boolean result = false;
        String thisBrowser = this.toString();
        if (thisBrowser.equals(anotherBrowser)) {
            result = true;
        }
        if (!result) {
            try {
                String name;
                Class<?> anotherClass = Class.forName(PACKAGE + anotherBrowser);
                if (this.getClass().isAssignableFrom(anotherClass)) {
                    result = true;
                }
                if (!result && !thisBrowser.endsWith("up") && Class.forName(name = String.valueOf(this.getClass().getName()) + "up").isAssignableFrom(anotherClass)) {
                    result = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return result;
    }

    public boolean isScriptEnabled() {
        return this.scriptEnabled;
    }

    public boolean isAjaxEnabled() {
        return this.ajaxCapable && this.ajaxEnabled;
    }

    public String toString() {
        String result = this.getClass().getName();
        int index = result.lastIndexOf(46) + 1;
        return result.substring(index);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getLocales() {
        return this.locales;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public boolean isXHTMLCapable() {
        return false;
    }
}

