/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.lifecycle.RWTRequestVersionControl;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.LifeCycleServiceHandler;
import org.eclipse.rwt.service.ISessionStore;

public class RWTLifeCycleServiceHandlerSync
extends LifeCycleServiceHandler.LifeCycleServiceHandlerSync {
    private static final String PATTERN_RELOAD = "qx.core.Init.getInstance().getApplication().reload( \"{0}\" )";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service() throws ServletException, IOException {
        ISessionStore iSessionStore = ContextProvider.getSession();
        synchronized (iSessionStore) {
            this.serviceInternal();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void serviceInternal() throws ServletException, IOException {
        LifeCycleServiceHandler.initializeStateInfo();
        RWTRequestVersionControl.beforeService();
        try {
            if (RWTRequestVersionControl.isValid() || LifeCycleServiceHandler.isSessionRestart() || ContextProvider.getRequest().getSession().isNew()) {
                this.doService();
            } else {
                this.handleInvalidRequestCounter();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            RWTRequestVersionControl.afterService();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        RWTRequestVersionControl.afterService();
    }

    private void handleInvalidRequestCounter() throws IOException {
        LifeCycleServiceHandler.initializeStateInfo();
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HtmlResponseWriter out = stateInfo.getResponseWriter();
        String message = RWTMessages.getMessage("RWT_MultipleInstancesError");
        Object[] args = new Object[]{message};
        out.write(MessageFormat.format(PATTERN_RELOAD, args));
        HttpServletResponse response = ContextProvider.getResponse();
        response.setContentType("text/javascript; charset=UTF-8");
        LifeCycleServiceHandler.writeOutput();
    }
}

