/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.LifeCycleServiceHandler;
import org.eclipse.rwt.internal.service.TemplateHolder;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.SimpleSelector;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.internal.util.EntitiesUtil;
import org.eclipse.rwt.internal.util.HTMLUtil;
import org.eclipse.rwt.internal.util.URLHelper;

public final class BrowserSurvey {
    static /* synthetic */ Class class$0;

    static void sendBrowserSurvey() throws ServletException {
        if (LifeCycleServiceHandler.configurer.isStartupPageModifiedSince()) {
            HttpServletRequest request = ContextProvider.getRequest();
            String survey = request.getParameter("w4t_survey");
            if (survey != null && survey.equals("true")) {
                String msg = "Initialization fault. Browser survey failed.";
                throw new ServletException(msg);
            }
            try {
                if (BrowserSurvey.isAjaxRequest()) {
                    BrowserSurvey.renderAjax();
                }
                BrowserSurvey.renderScript();
            }
            catch (IOException e) {
                String txt = "Failed to load Browser Survey HTML Page (Reason: {0})";
                Object[] param = new Object[]{e.getMessage()};
                String msg = MessageFormat.format(txt, param);
                throw new ServletException(msg, (Throwable)e);
            }
        } else {
            AbstractBranding branding = BrandingUtil.findBranding();
            if (branding.getThemeId() != null) {
                ThemeUtil.setCurrentThemeId(branding.getThemeId());
            }
        }
    }

    private static String getBgImage() {
        QxImage image;
        String resourceName;
        String result = "";
        QxType cssValue = ThemeUtil.getCssValue("Display", "background-image", SimpleSelector.DEFAULT);
        if (cssValue instanceof QxImage && (resourceName = (image = (QxImage)cssValue).getResourceName()) != null) {
            result = RWT.getResourceManager().getLocation(resourceName);
        }
        return result;
    }

    public static String getSerlvetName() {
        String result = ContextProvider.getRequest().getServletPath();
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public static void replacePlaceholder(StringBuffer buffer, String placeHolder, String replacement) {
        int index = buffer.indexOf(placeHolder);
        while (index != -1) {
            buffer.replace(index, index + placeHolder.length(), replacement);
            index = buffer.indexOf(placeHolder);
        }
    }

    private static void renderScript() throws IOException {
        ContextProvider.getResponse().setContentType("text/html");
        TemplateHolder template = LifeCycleServiceHandler.configurer.getTemplateOfStartupPage();
        template.replace(TemplateHolder.VAR_BACKGROUND_IMAGE, BrowserSurvey.getBgImage());
        template.replace(TemplateHolder.VAR_SERVLET, BrowserSurvey.getSerlvetName());
        template.replace(TemplateHolder.VAR_FALLBACK_URL, BrowserSurvey.createURL());
        template.replace(TemplateHolder.VAR_ADMIN_OR_STARTUP, BrowserSurvey.adminOrStartup());
        template.replace(TemplateHolder.VAR_ENTRY_POINT, EntitiesUtil.encodeHTMLEntities(BrowserSurvey.getEntryPoint()));
        String[] tokens = template.getTokens();
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i] != null) {
                BrowserSurvey.getResponseWriter().append(tokens[i]);
            }
            ++i;
        }
    }

    private static void renderAjax() {
        ContextProvider.getResponse().setContentType("text/xml");
        HtmlResponseWriter writer = BrowserSurvey.getResponseWriter();
        writer.append(HTMLUtil.createXmlProcessingInstruction());
        writer.append("<ajax-response>");
        StringBuffer code = new StringBuffer();
        code.append("alert('");
        code.append("Your request was sent to an expired session.\\n");
        code.append("A new session will be initiated.");
        code.append("');");
        code.append("window.open( '");
        code.append(URLHelper.getURLString(false));
        code.append("', '_self' );");
        writer.append(HTMLUtil.createJavaScriptInline(code.toString()));
        writer.append("</ajax-response>");
    }

    static String getResourceName() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.BrowserSurvey");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String name = clazz.getPackage().getName();
        return String.valueOf(name.replace('.', '/')) + "/index.html";
    }

    private static String createURL() {
        StringBuffer url = new StringBuffer();
        url.append(URLHelper.getURLString(false));
        URLHelper.appendFirstParam(url, BrowserSurvey.adminOrStartup(), BrowserSurvey.getEntryPoint());
        URLHelper.appendParam(url, "w4t_scriptEnabled", "false");
        URLHelper.appendParam(url, "w4t_ajaxEnabled", "false");
        return ContextProvider.getResponse().encodeURL(url.toString());
    }

    private static String getEntryPoint() {
        HttpServletRequest request = ContextProvider.getRequest();
        String result = request.getParameter("startup");
        if (result == null) {
            result = "default";
        }
        return result;
    }

    private static String adminOrStartup() {
        HttpServletRequest request = ContextProvider.getRequest();
        String parameter = request.getParameter("w4t_admin");
        boolean admin = "true".equals(parameter);
        return admin ? "w4t_admin" : "startup";
    }

    private static HtmlResponseWriter getResponseWriter() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        return stateInfo.getResponseWriter();
    }

    private static boolean isAjaxRequest() {
        HttpServletRequest request = ContextProvider.getRequest();
        String paramValue = request.getParameter("w4t_isAjaxRequest");
        return "true".equals(paramValue);
    }
}

