/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rwt.internal.theme.ThemeCssElement;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ThemeDefinitionReader {
    private static final String ELEM_ROOT = "theme";
    private static final String ELEM_ELEMENT = "element";
    private static final String ELEM_PROPERTY = "property";
    private static final String ELEM_STYLE = "style";
    private static final String ELEM_STATE = "state";
    private static final String ATTR_NAME = "name";
    private static final String THEME_DEF_SCHEMA = "themedef.xsd";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private final InputStream inputStream;
    private final String fileName;
    private final Collection cssElements;
    static /* synthetic */ Class class$0;

    public ThemeDefinitionReader(InputStream inputStream, String fileName) {
        if (inputStream == null) {
            throw new NullPointerException("null argument");
        }
        this.inputStream = inputStream;
        this.fileName = fileName;
        this.cssElements = new ArrayList();
    }

    public void read() throws SAXException, IOException {
        Document document = this.parseThemeDefinition(this.inputStream);
        Node root = document.getElementsByTagName(ELEM_ROOT).item(0);
        NodeList childNodes = root.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && ELEM_ELEMENT.equals(node.getNodeName())) {
                this.readElement(node);
            }
            ++i;
        }
    }

    public IThemeCssElement[] getThemeCssElements() {
        IThemeCssElement[] result = new IThemeCssElement[this.cssElements.size()];
        this.cssElements.toArray(result);
        return result;
    }

    private void readElement(Node node) {
        String name = ThemeDefinitionReader.getAttributeValue(node, ATTR_NAME);
        ThemeCssElement themeElement = new ThemeCssElement(name);
        this.cssElements.add(themeElement);
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1) {
                if (ELEM_ELEMENT.equals(childNode.getNodeName())) {
                    this.readElement(childNode);
                } else if (ELEM_PROPERTY.equals(childNode.getNodeName())) {
                    themeElement.addProperty(ThemeDefinitionReader.getAttributeValue(childNode, ATTR_NAME));
                } else if (ELEM_STYLE.equals(childNode.getNodeName())) {
                    themeElement.addStyle(ThemeDefinitionReader.getAttributeValue(childNode, ATTR_NAME));
                } else if (ELEM_STATE.equals(childNode.getNodeName())) {
                    themeElement.addState(ThemeDefinitionReader.getAttributeValue(childNode, ATTR_NAME));
                }
            }
            ++i;
        }
    }

    private Document parseThemeDefinition(InputStream is) throws SAXException, IOException {
        DocumentBuilder builder;
        ClassLoader loader;
        URL schema;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.theme.ThemeDefinitionReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        factory.setValidating((schema = (loader = clazz.getClassLoader()).getResource(THEME_DEF_SCHEMA)) != null);
        try {
            factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            factory.setNamespaceAware(false);
            factory.setValidating(false);
        }
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String message = "Failed to initialize parser for theme definition files";
            throw new RuntimeException(message, e);
        }
        builder.setErrorHandler(new ThemeDefinitionErrorHandler());
        return builder.parse(is);
    }

    private static String getAttributeValue(Node node, String name) {
        Node namedItem;
        String result = null;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (namedItem = attributes.getNamedItem(name)) != null) {
            result = namedItem.getNodeValue();
        }
        return result;
    }

    private class ThemeDefinitionErrorHandler
    implements ErrorHandler {
        private ThemeDefinitionErrorHandler() {
        }

        public void error(SAXParseException spe) throws SAXException {
            System.err.println("Error parsing theme definition " + this.getPosition(spe) + ":");
            System.err.println(spe.getMessage());
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            System.err.println("Fatal error parsing theme definition " + this.getPosition(spe) + ":");
            System.err.println(spe.getMessage());
        }

        public void warning(SAXParseException spe) throws SAXException {
            System.err.println("Warning parsing theme definition " + this.getPosition(spe) + ":");
            System.err.println(spe.getMessage());
        }

        private String getPosition(SAXParseException spe) {
            return "in file '" + ThemeDefinitionReader.this.fileName + "' at line " + spe.getLineNumber() + ", col " + spe.getColumnNumber();
        }
    }
}

