/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterUtil;
import org.eclipse.rwt.internal.resources.ResourceManager;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.theme.AppearancesUtil;
import org.eclipse.rwt.internal.theme.IThemeAdapter;
import org.eclipse.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxTheme;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.ResourceLoader;
import org.eclipse.rwt.internal.theme.StyleSheetBuilder;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeDefinitionReader;
import org.eclipse.rwt.internal.theme.ThemeManagerException;
import org.eclipse.rwt.internal.theme.ThemeStoreWriter;
import org.eclipse.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rwt.internal.theme.ThemeableWidgetHolder;
import org.eclipse.rwt.internal.theme.css.CssElementHolder;
import org.eclipse.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rwt.internal.theme.css.StyleSheet;
import org.eclipse.rwt.resources.IResourceManager;
import org.w3c.css.sac.CSSException;

public final class ThemeManager {
    private static final ResourceLoader STANDARD_RESOURCE_LOADER = new ResourceLoader(){
        ClassLoader classLoader = this.getClass().getClassLoader();

        public InputStream getResourceAsStream(String resourceName) throws IOException {
            return this.classLoader.getResourceAsStream(resourceName);
        }
    };
    private static final String CHARSET = "UTF-8";
    private static final String LOG_SYSTEM_PROPERTY;
    private static final boolean DEBUG;
    private static final String CLIENT_LIBRARY_VARIANT = "org.eclipse.rwt.clientLibraryVariant";
    private static final String DEBUG_CLIENT_LIBRARY_VARIANT = "DEBUG";
    private static final String[] WIDGET_NOTHEME_RESOURCES;
    private static final String WIDGET_RESOURCES_SRC = "resource/widget/rap/";
    private static final String THEME_RESOURCE_DEST = "themes";
    static final String IMAGE_DEST_PATH = "themes/images";
    private static final String THEME_PREFIX = "org.eclipse.swt.theme.";
    private static final String PREDEFINED_THEME_ID = "org.eclipse.swt.theme.Default";
    private static final String PREDEFINED_THEME_NAME = "RAP Default Theme";
    private static final Class[] THEMEABLE_WIDGETS;
    private static ThemeManager instance;
    private final Set customAppearances;
    private final Map themes;
    private final Map adapters;
    private final Set registeredThemeFiles;
    private boolean initialized = false;
    private Theme predefinedTheme;
    private ThemeableWidgetHolder themeableWidgets = new ThemeableWidgetHolder();
    private StyleSheetBuilder defaultStyleSheetBuilder;
    private int themeCount;
    private CssElementHolder registeredCssElements;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;
    static /* synthetic */ Class class$27;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.theme.ThemeManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG_SYSTEM_PROPERTY = System.getProperty(String.valueOf(clazz.getName()) + ".log");
        DEBUG = "true".equals(LOG_SYSTEM_PROPERTY);
        WIDGET_NOTHEME_RESOURCES = new String[]{"arrows/down.gif", "arrows/down_small.gif", "arrows/down_tiny.gif", "arrows/first.png", "arrows/forward.gif", "arrows/last.png", "arrows/left.png", "arrows/minimize.gif", "arrows/next.gif", "arrows/previous.gif", "arrows/rewind.gif", "arrows/right.png", "arrows/up.gif", "arrows/up_small.gif", "arrows/up_tiny.gif", "ctabfolder/maximize.gif", "ctabfolder/minimize.gif", "ctabfolder/restore.gif", "ctabfolder/close.gif", "ctabfolder/close_hover.gif", "ctabfolder/chevron.gif", "cursors/alias.gif", "cursors/copy.gif", "cursors/move.gif", "cursors/nodrop.gif", "tree/cross.gif", "tree/cross_minus.gif", "tree/cross_plus.gif", "tree/end.gif", "tree/end_minus.gif", "tree/end_plus.gif", "tree/folder_open.gif", "tree/folder_closed.gif", "tree/line.gif", "tree/minus.gif", "tree/only_minus.gif", "tree/only_plus.gif", "tree/plus.gif", "tree/start_minus.gif", "tree/start_plus.gif", "scale/h_line.gif", "scale/v_line.gif", "scale/h_thumb.gif", "scale/v_thumb.gif", "scale/h_marker_big.gif", "scale/v_marker_big.gif", "scale/h_marker_small.gif", "scale/v_marker_small.gif"};
        Class[] classArray = new Class[27];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.swt.widgets.Widget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.swt.widgets.Control");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.swt.widgets.Composite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.swt.widgets.Button");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz5;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.swt.widgets.Combo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz6;
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.swt.widgets.CoolBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[5] = clazz7;
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("org.eclipse.swt.custom.CTabFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[6] = clazz8;
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("org.eclipse.swt.widgets.Group");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[7] = clazz9;
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("org.eclipse.swt.widgets.Label");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[8] = clazz10;
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("org.eclipse.swt.widgets.Link");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[9] = clazz11;
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("org.eclipse.swt.widgets.List");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[10] = clazz12;
        Class<?> clazz13 = class$12;
        if (clazz13 == null) {
            try {
                clazz13 = class$12 = Class.forName("org.eclipse.swt.widgets.Menu");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[11] = clazz13;
        Class<?> clazz14 = class$13;
        if (clazz14 == null) {
            try {
                clazz14 = class$13 = Class.forName("org.eclipse.swt.widgets.ProgressBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[12] = clazz14;
        Class<?> clazz15 = class$14;
        if (clazz15 == null) {
            try {
                clazz15 = class$14 = Class.forName("org.eclipse.swt.widgets.Shell");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[13] = clazz15;
        Class<?> clazz16 = class$15;
        if (clazz16 == null) {
            try {
                clazz16 = class$15 = Class.forName("org.eclipse.swt.widgets.Spinner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[14] = clazz16;
        Class<?> clazz17 = class$16;
        if (clazz17 == null) {
            try {
                clazz17 = class$16 = Class.forName("org.eclipse.swt.widgets.TabFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[15] = clazz17;
        Class<?> clazz18 = class$17;
        if (clazz18 == null) {
            try {
                clazz18 = class$17 = Class.forName("org.eclipse.swt.widgets.Table");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[16] = clazz18;
        Class<?> clazz19 = class$18;
        if (clazz19 == null) {
            try {
                clazz19 = class$18 = Class.forName("org.eclipse.swt.widgets.Text");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[17] = clazz19;
        Class<?> clazz20 = class$19;
        if (clazz20 == null) {
            try {
                clazz20 = class$19 = Class.forName("org.eclipse.swt.widgets.ToolBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[18] = clazz20;
        Class<?> clazz21 = class$20;
        if (clazz21 == null) {
            try {
                clazz21 = class$20 = Class.forName("org.eclipse.swt.widgets.Tree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[19] = clazz21;
        Class<?> clazz22 = class$21;
        if (clazz22 == null) {
            try {
                clazz22 = class$21 = Class.forName("org.eclipse.swt.widgets.Scale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[20] = clazz22;
        Class<?> clazz23 = class$22;
        if (clazz23 == null) {
            try {
                clazz23 = class$22 = Class.forName("org.eclipse.swt.widgets.DateTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[21] = clazz23;
        Class<?> clazz24 = class$23;
        if (clazz24 == null) {
            try {
                clazz24 = class$23 = Class.forName("org.eclipse.swt.widgets.ExpandBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[22] = clazz24;
        Class<?> clazz25 = class$24;
        if (clazz25 == null) {
            try {
                clazz25 = class$24 = Class.forName("org.eclipse.swt.widgets.Sash");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[23] = clazz25;
        Class<?> clazz26 = class$25;
        if (clazz26 == null) {
            try {
                clazz26 = class$25 = Class.forName("org.eclipse.swt.widgets.Slider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[24] = clazz26;
        Class<?> clazz27 = class$26;
        if (clazz27 == null) {
            try {
                clazz27 = class$26 = Class.forName("org.eclipse.swt.custom.CCombo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[25] = clazz27;
        Class<?> clazz28 = class$27;
        if (clazz28 == null) {
            try {
                clazz28 = class$27 = Class.forName("org.eclipse.swt.custom.CLabel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[26] = clazz28;
        THEMEABLE_WIDGETS = classArray;
    }

    private ThemeManager() {
        this.customAppearances = new HashSet();
        this.themes = new LinkedHashMap();
        this.adapters = new HashMap();
        this.registeredThemeFiles = new HashSet();
        this.registeredCssElements = new CssElementHolder();
        this.defaultStyleSheetBuilder = new StyleSheetBuilder();
    }

    public static ThemeManager getInstance() {
        if (instance == null) {
            instance = new ThemeManager();
        }
        return instance;
    }

    public void initialize() {
        ThemeManager.log("Start ThemeManager initialization");
        if (!this.initialized) {
            this.addDefaultThemableWidgets();
            ThemeableWidget[] widgets = this.themeableWidgets.getAll();
            int i = 0;
            while (i < widgets.length) {
                this.processThemeableWidget(widgets[i]);
                ++i;
            }
            StyleSheet defaultStyleSheet = this.defaultStyleSheetBuilder.getStyleSheet();
            this.predefinedTheme = new Theme(PREDEFINED_THEME_ID, PREDEFINED_THEME_NAME, defaultStyleSheet, this.themeableWidgets.getAll());
            this.themes.put(PREDEFINED_THEME_ID, this.predefinedTheme);
            this.initialized = true;
            this.logRegisteredThemeAdapters();
        }
    }

    public void reset() {
        if (this.initialized) {
            this.themeableWidgets = new ThemeableWidgetHolder();
            this.customAppearances.clear();
            this.themes.clear();
            this.adapters.clear();
            this.registeredCssElements.clear();
            this.defaultStyleSheetBuilder = new StyleSheetBuilder();
            this.predefinedTheme = null;
            this.initialized = false;
            ThemeManager.log("ThemeManager reset");
        }
    }

    public void addThemeableWidget(Class widget, ResourceLoader loader) {
        if (this.initialized) {
            throw new IllegalStateException("ThemeManager is already initialized");
        }
        if (widget == null) {
            throw new NullPointerException("widget");
        }
        if (loader == null) {
            throw new NullPointerException("loader");
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.widgets.Widget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(widget)) {
            String message = "Themeable widget is not a subtype of Widget: " + widget.getName();
            throw new IllegalArgumentException(message);
        }
        this.themeableWidgets.add(new ThemeableWidget(widget, loader));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerTheme(String id, String name, String fileName, ResourceLoader loader) throws IOException {
        this.checkInitialized();
        ThemeManager.log("Register theme " + id + " from " + fileName);
        this.checkId(id);
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (loader == null) {
            throw new NullPointerException("loader");
        }
        if (this.themes.containsKey(id)) {
            String pattern = "Theme with id ''{0}'' exists already";
            Object[] arguments = new Object[]{id};
            String msg = MessageFormat.format(pattern, arguments);
            throw new IllegalArgumentException(msg);
        }
        ++this.themeCount;
        String jsId = "org.eclipse.swt.theme.Custom_" + this.themeCount;
        InputStream inputStream = loader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("Could not open resource " + fileName);
        }
        try {
            StyleSheet styleSheet;
            CssFileReader reader = new CssFileReader();
            try {
                styleSheet = reader.parse(inputStream, fileName, loader);
            }
            catch (CSSException e) {
                throw new ThemeManagerException("Failed parsing CSS file", e);
            }
            Theme theme = new Theme(jsId, name != null ? name : jsId, styleSheet, this.themeableWidgets.getAll());
            this.themes.put(id, theme);
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            inputStream.close();
            throw throwable;
        }
        {
            Object var10_16 = null;
        }
        inputStream.close();
    }

    public String[] getRegisteredThemeIds() {
        this.checkInitialized();
        String[] result = new String[this.themes.size()];
        return this.themes.keySet().toArray(result);
    }

    public String getDefaultThemeId() {
        this.checkInitialized();
        return PREDEFINED_THEME_ID;
    }

    public void registerResources() {
        this.checkInitialized();
        ThemeManager.log("ThemeManager registers resources");
        String libraryVariant = System.getProperty(CLIENT_LIBRARY_VARIANT);
        boolean compress = !DEBUG_CLIENT_LIBRARY_VARIANT.equals(libraryVariant);
        Iterator iterator = this.themes.keySet().iterator();
        while (iterator.hasNext()) {
            String themeId = (String)iterator.next();
            this.registerThemeFiles(themeId, compress);
        }
    }

    public boolean hasTheme(String themeId) {
        this.checkInitialized();
        return this.themes.containsKey(themeId);
    }

    public Theme getTheme(String themeId) {
        this.checkInitialized();
        Theme result = null;
        if (this.themes.containsKey(themeId)) {
            result = (Theme)this.themes.get(themeId);
        }
        return result;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IThemeAdapter getThemeAdapter(Class widgetClass) {
        Class<?> clazz;
        this.checkInitialized();
        IThemeAdapter result = null;
        if (this.adapters.containsKey(widgetClass)) {
            return (IThemeAdapter)this.adapters.get(widgetClass);
        }
        Class clazz2 = widgetClass;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                clazz2 = clazz2.getSuperclass();
            }
            if (clazz2 == null) break;
            clazz = class$1;
            if (clazz != null) continue;
            try {
                clazz = Class.forName("org.eclipse.swt.widgets.Widget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz2 != clazz && !this.adapters.containsKey(clazz2));
        if (this.adapters.containsKey(clazz2)) {
            return (IThemeAdapter)this.adapters.get(clazz2);
        }
        String msg = "No theme adapter registered for class " + widgetClass.getName();
        throw new IllegalArgumentException(msg);
    }

    ThemeableWidget getThemeableWidget(Class widget) {
        return this.themeableWidgets.get(widget);
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("ThemeManager not initialized");
        }
    }

    private void addDefaultThemableWidgets() {
        int i = 0;
        while (i < THEMEABLE_WIDGETS.length) {
            this.addThemeableWidget(THEMEABLE_WIDGETS[i], STANDARD_RESOURCE_LOADER);
            ++i;
        }
    }

    private void processThemeableWidget(ThemeableWidget themeWidget) {
        ThemeManager.log("Processing widget: " + themeWidget.widget.getName());
        String packageName = themeWidget.widget.getPackage().getName();
        String[] variants = LifeCycleAdapterUtil.getPackageVariants(packageName);
        String className = LifeCycleAdapterUtil.getSimpleClassName(themeWidget.widget);
        boolean found = false;
        try {
            int i = 0;
            while (i < variants.length && !found) {
                String pkgName = String.valueOf(variants[i]) + "." + className.toLowerCase() + "kit";
                ThemeManager.log("  looking through package " + pkgName);
                found |= this.loadThemeDef(themeWidget, pkgName, className);
                found |= this.loadAppearanceJs(themeWidget, pkgName, className);
                found |= this.loadThemeAdapter(themeWidget, pkgName, className);
                found |= this.loadDefaultCss(themeWidget, pkgName, className);
                ++i;
            }
            if (themeWidget.elements == null) {
                ThemeManager.log("WARNING: No elements defined for themeable widget: " + themeWidget.widget.getName());
            }
            if (themeWidget.defaultStyleSheet != null) {
                this.defaultStyleSheetBuilder.addStyleSheet(themeWidget.defaultStyleSheet);
            }
        }
        catch (IOException e) {
            String message = "Failed to initialize themeable widget " + themeWidget.widget.getName();
            throw new ThemeManagerException(message, e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadThemeDef(ThemeableWidget themeWidget, String pkgName, String className) throws IOException {
        boolean result = false;
        String resPkgName = pkgName.replace('.', '/');
        String fileName = String.valueOf(resPkgName) + "/" + className + ".theme.xml";
        InputStream inStream = themeWidget.loader.getResourceAsStream(fileName);
        if (inStream == null) return result;
        ThemeManager.log("Found theme definition file: " + fileName);
        result = true;
        try {
            try {
                ThemeDefinitionReader reader = new ThemeDefinitionReader(inStream, fileName);
                reader.read();
                themeWidget.elements = reader.getThemeCssElements();
                int i = 0;
                while (i < themeWidget.elements.length) {
                    this.registeredCssElements.addElement(themeWidget.elements[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                String message = "Failed to parse theme definition file " + fileName;
                throw new ThemeManagerException(message, e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            inStream.close();
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        inStream.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadAppearanceJs(ThemeableWidget themeWidget, String pkgName, String className) throws IOException {
        boolean result = false;
        String resPkgName = pkgName.replace('.', '/');
        String fileName = String.valueOf(resPkgName) + "/" + className + ".appearances.js";
        InputStream inStream = themeWidget.loader.getResourceAsStream(fileName);
        if (inStream == null) return result;
        ThemeManager.log("Found appearance js file: " + fileName);
        try {
            String content = AppearancesUtil.readAppearanceFile(inStream);
            this.customAppearances.add(content);
            result = true;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            inStream.close();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        inStream.close();
        return result;
    }

    private boolean loadThemeAdapter(ThemeableWidget themeWidget, String pkgName, String className) {
        boolean result = false;
        IThemeAdapter themeAdapter = null;
        String adapterClassName = String.valueOf(pkgName) + '.' + className + "ThemeAdapter";
        try {
            ClassLoader classLoader = themeWidget.widget.getClassLoader();
            Class<?> adapterClass = classLoader.loadClass(adapterClassName);
            themeAdapter = (IThemeAdapter)adapterClass.newInstance();
            if (themeAdapter != null) {
                ThemeManager.log("Found theme adapter class: " + themeAdapter.getClass().getName());
                result = true;
                this.adapters.put(themeWidget.widget, themeAdapter);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException e) {
            String message = "Failed to instantiate theme adapter class " + adapterClassName;
            throw new ThemeManagerException(message, e);
        }
        catch (IllegalAccessException e) {
            String message = "Failed to instantiate theme adapter class " + adapterClassName;
            throw new ThemeManagerException(message, e);
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadDefaultCss(ThemeableWidget themeWidget, String pkgName, String className) throws IOException {
        boolean result = false;
        ResourceLoader resLoader = themeWidget.loader;
        String resPkgName = pkgName.replace('.', '/');
        String fileName = String.valueOf(resPkgName) + "/" + className + ".default.css";
        InputStream inStream = resLoader.getResourceAsStream(fileName);
        if (inStream == null) return result;
        ThemeManager.log("Found default css file: " + fileName);
        try {
            CssFileReader reader = new CssFileReader();
            themeWidget.defaultStyleSheet = reader.parse(inStream, fileName, resLoader);
            result = true;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            inStream.close();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        inStream.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerThemeFiles(String themeId, boolean compress) {
        Set set = this.registeredThemeFiles;
        synchronized (set) {
            if (!this.registeredThemeFiles.contains(themeId)) {
                Theme theme = (Theme)this.themes.get(themeId);
                String jsId = theme.getJsId();
                this.registerNonThemeableWidgetImages(themeId);
                this.registerThemeableWidgetImages(themeId);
                StringBuffer sb = new StringBuffer();
                sb.append(this.createQxThemes(theme));
                IThemeCssElement[] elements = this.registeredCssElements.getAllElements();
                ThemeStoreWriter storeWriter = new ThemeStoreWriter(elements);
                storeWriter.addTheme(theme, theme == this.predefinedTheme);
                sb.append(storeWriter.createJs());
                String themeCode = sb.toString();
                ThemeManager.log("-- REGISTERED THEME CODE FOR " + themeId + " --");
                ThemeManager.log(themeCode);
                ThemeManager.log("-- END REGISTERED THEME CODE --");
                String name = String.valueOf(jsId.replace('.', '/')) + ".js";
                ThemeManager.registerJsLibrary(name, themeCode, compress);
                this.registeredThemeFiles.add(themeId);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerNonThemeableWidgetImages(String themeId) {
        Theme theme = (Theme)this.themes.get(themeId);
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.rwt.internal.theme.ThemeManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        ClassLoader classLoader = clazz.getClassLoader();
        ThemeManager.log(" == register non-themeable images for theme " + themeId);
        int i = 0;
        while (i < WIDGET_NOTHEME_RESOURCES.length) {
            Object var12_12;
            String imagePath = WIDGET_NOTHEME_RESOURCES[i];
            String res = WIDGET_RESOURCES_SRC + imagePath;
            InputStream inputStream = classLoader.getResourceAsStream(res);
            if (inputStream == null) {
                String mesg = "Resource not found: " + res;
                throw new IllegalArgumentException(mesg);
            }
            try {
                String jsId = theme.getJsId();
                String registerPath = String.valueOf(this.getWidgetDestPath(jsId)) + "/" + imagePath;
                IResourceManager resMgr = ResourceManager.getInstance();
                resMgr.register(registerPath, inputStream);
                String location = resMgr.getLocation(registerPath);
                ThemeManager.log(" notheme image registered @ " + location);
            }
            catch (Throwable throwable) {
                var12_12 = null;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            {
                var12_12 = null;
            }
            try {}
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            inputStream.close();
            ++i;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerThemeableWidgetImages(String themeId) {
        Theme theme = (Theme)this.themes.get(themeId);
        ThemeManager.log(" == register themeable images for theme " + themeId);
        QxType[] values = theme.getValuesMap().getAllValues();
        int i = 0;
        while (i < values.length) {
            QxType value = values[i];
            if (value instanceof QxImage) {
                QxImage image = (QxImage)value;
                String key = Theme.createCssKey(value);
                String path = image.path;
                ThemeManager.log(" register theme image " + key + ", path=" + path);
                if (!image.none) {
                    Object var14_15;
                    InputStream inputStream;
                    try {
                        inputStream = image.loader.getResourceAsStream(path);
                    }
                    catch (IOException e) {
                        String message = "Failed to load resource " + path;
                        throw new ThemeManagerException(message, e);
                    }
                    if (inputStream == null) {
                        String pattern = "Resource ''{0}'' not found for theme ''{1}''";
                        Object[] arguments = new Object[]{path, theme.getName()};
                        String mesg = MessageFormat.format(pattern, arguments);
                        throw new IllegalArgumentException(mesg);
                    }
                    try {
                        String widgetDestPath = IMAGE_DEST_PATH;
                        String registerPath = String.valueOf(widgetDestPath) + "/" + key;
                        IResourceManager resMgr = ResourceManager.getInstance();
                        resMgr.register(registerPath, inputStream);
                        String location = resMgr.getLocation(registerPath);
                        ThemeManager.log(" theme image registered @ " + location);
                    }
                    catch (Throwable throwable) {
                        var14_15 = null;
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    {
                        var14_15 = null;
                    }
                    try {}
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    inputStream.close();
                }
            }
            ++i;
        }
        return;
    }

    private static void registerJsLibrary(String name, String code, boolean compress) {
        IResourceManager manager = ResourceManager.getInstance();
        IResourceManager.RegisterOptions option = IResourceManager.RegisterOptions.VERSION;
        if (compress) {
            option = IResourceManager.RegisterOptions.VERSION_AND_COMPRESS;
        }
        if (code != null) {
            byte[] buffer;
            try {
                buffer = code.getBytes(CHARSET);
            }
            catch (UnsupportedEncodingException shouldNotHappen) {
                throw new RuntimeException(shouldNotHappen);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer);
            manager.register(name, inputStream, CHARSET, option);
        } else {
            manager.register(name, CHARSET, option);
        }
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HtmlResponseWriter responseWriter = stateInfo.getResponseWriter();
        responseWriter.useJSLibrary(name);
    }

    private String createQxThemes(Theme theme) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.createQxTheme(theme, 3));
        buffer.append(this.createQxTheme(theme, 4));
        buffer.append(this.createQxTheme(theme, 2));
        buffer.append(this.createQxTheme(theme, 5));
        buffer.append(this.createQxTheme(theme, 6));
        buffer.append(this.createQxTheme(theme, 7));
        buffer.append(this.createQxTheme(theme, 1));
        return buffer.toString();
    }

    private String createQxTheme(Theme theme, int type) {
        String jsId = theme.getJsId();
        String base = null;
        if (type == 4) {
            base = "org.eclipse.swt.theme.BordersBase";
        } else if (type == 7) {
            base = "org.eclipse.swt.theme.AppearancesBase";
        }
        QxTheme qxTheme = new QxTheme(jsId, theme.getName(), type, base);
        if (type == 6 || type == 5) {
            String uri = "rwt-resources/" + this.getWidgetDestPath(jsId);
            qxTheme.appendUri(uri);
        } else if (type == 7) {
            Iterator iterator = this.customAppearances.iterator();
            while (iterator.hasNext()) {
                String appearance = (String)iterator.next();
                qxTheme.appendValues(appearance);
            }
        } else if (type == 1) {
            qxTheme.appendTheme("color", String.valueOf(jsId) + "Colors");
            qxTheme.appendTheme("border", String.valueOf(jsId) + "Borders");
            qxTheme.appendTheme("font", String.valueOf(jsId) + "Fonts");
            qxTheme.appendTheme("icon", String.valueOf(jsId) + "Icons");
            qxTheme.appendTheme("widget", String.valueOf(jsId) + "Widgets");
            qxTheme.appendTheme("appearance", String.valueOf(jsId) + "Appearances");
        }
        return qxTheme.getJsCode();
    }

    private String getWidgetDestPath(String jsThemeId) {
        int start = jsThemeId.lastIndexOf(46) + 1;
        int end = jsThemeId.length();
        String jsThemeName = jsThemeId.substring(start, end);
        return "themes/" + jsThemeName + "/widgets";
    }

    private void checkId(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException("empty id");
        }
    }

    private void logRegisteredThemeAdapters() {
        ThemeManager.log("=== REGISTERED ADAPTERS ===");
        Iterator iter = this.adapters.keySet().iterator();
        while (iter.hasNext()) {
            Class key = (Class)iter.next();
            Object adapter = this.adapters.get(key);
            ThemeManager.log(String.valueOf(key.getName()) + ": " + adapter);
        }
        ThemeManager.log("=== END REGISTERED ADAPTERS ===");
    }

    private static void log(String mesg) {
        if (DEBUG) {
            System.out.println(mesg);
        }
    }
}

