/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rwt.internal.theme.JsonArray;
import org.eclipse.rwt.internal.theme.JsonObject;
import org.eclipse.rwt.internal.theme.JsonValue;
import org.eclipse.rwt.internal.theme.QxBorder;
import org.eclipse.rwt.internal.theme.QxBoxDimensions;
import org.eclipse.rwt.internal.theme.QxColor;
import org.eclipse.rwt.internal.theme.QxDimension;
import org.eclipse.rwt.internal.theme.QxFont;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeCssValuesMap;
import org.eclipse.rwt.internal.theme.css.ConditionalValue;

public final class ThemeStoreWriter {
    private Set valueSet = new HashSet();
    private final IThemeCssElement[] elements;
    private StringBuffer cssValuesBuffer;

    public ThemeStoreWriter(IThemeCssElement[] elements) {
        this.elements = elements;
        this.cssValuesBuffer = new StringBuffer();
    }

    public void addTheme(Theme theme, boolean isDefault) {
        QxType[] values = theme.getValuesMap().getAllValues();
        int i = 0;
        while (i < values.length) {
            this.valueSet.add(values[i]);
            ++i;
        }
        this.createThemeStoreCss(theme, isDefault);
    }

    public String createJs() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ts = org.eclipse.swt.theme.ThemeStore.getInstance();\n");
        JsonObject valuesMap = this.createValues();
        buffer.append("ts.defineValues(" + valuesMap + ");\n");
        buffer.append(this.cssValuesBuffer);
        buffer.append("delete ts;\n");
        return buffer.toString();
    }

    private JsonObject createValues() {
        JsonObject dimensionMap = new JsonObject();
        JsonObject boxDimensionMap = new JsonObject();
        JsonObject imageMap = new JsonObject();
        JsonObject gradientMap = new JsonObject();
        JsonObject colorMap = new JsonObject();
        JsonObject fontMap = new JsonObject();
        JsonObject borderMap = new JsonObject();
        QxType[] values = new QxType[this.valueSet.size()];
        this.valueSet.toArray(values);
        int i = 0;
        while (i < values.length) {
            QxType value = values[i];
            String key = Theme.createCssKey(value);
            if (value instanceof QxDimension) {
                QxDimension dim = (QxDimension)value;
                dimensionMap.append(key, dim.value);
            } else if (value instanceof QxBoxDimensions) {
                QxBoxDimensions boxdim = (QxBoxDimensions)value;
                JsonArray boxArray = new JsonArray();
                boxArray.append(boxdim.top);
                boxArray.append(boxdim.right);
                boxArray.append(boxdim.bottom);
                boxArray.append(boxdim.left);
                boxDimensionMap.append(key, boxArray);
            } else if (value instanceof QxImage) {
                QxImage image = (QxImage)value;
                if (image.none) {
                    JsonObject gradientObject = null;
                    if (image.gradientColors != null && image.gradientPercents != null) {
                        gradientObject = new JsonObject();
                        JsonArray percents = JsonArray.valueOf(image.gradientPercents);
                        gradientObject.append("percents", percents);
                        JsonArray colors = JsonArray.valueOf(image.gradientColors);
                        gradientObject.append("colors", colors);
                    }
                    imageMap.append(key, JsonValue.NULL);
                    gradientMap.append(key, gradientObject);
                } else {
                    JsonArray imageArray = new JsonArray();
                    imageArray.append(key);
                    imageArray.append(image.width);
                    imageArray.append(image.height);
                    imageMap.append(key, imageArray);
                    gradientMap.append(key, JsonValue.NULL);
                }
            } else if (value instanceof QxColor) {
                QxColor color = (QxColor)value;
                if (color.transparent) {
                    colorMap.append(key, "undefined");
                } else {
                    colorMap.append(key, QxColor.toHtmlString(color.red, color.green, color.blue));
                }
            } else if (value instanceof QxFont) {
                QxFont font = (QxFont)value;
                JsonObject fontObject = new JsonObject();
                fontObject.append("family", JsonArray.valueOf(font.family));
                fontObject.append("size", font.size);
                fontObject.append("bold", font.bold);
                fontObject.append("italic", font.italic);
                fontMap.append(key, fontObject);
            } else if (value instanceof QxBorder) {
                QxBorder border = (QxBorder)value;
                JsonObject borderObject = new JsonObject();
                borderObject.append("width", border.width);
                borderObject.append("style", border.style);
                borderObject.append("color", border.color);
                borderMap.append(key, borderObject);
            }
            ++i;
        }
        JsonObject valuesMap = new JsonObject();
        valuesMap.append("dimensions", dimensionMap);
        valuesMap.append("boxdims", boxDimensionMap);
        valuesMap.append("images", imageMap);
        valuesMap.append("gradients", gradientMap);
        valuesMap.append("colors", colorMap);
        valuesMap.append("fonts", fontMap);
        valuesMap.append("borders", borderMap);
        return valuesMap;
    }

    private void createThemeStoreCss(Theme theme, boolean isDefault) {
        ThemeCssValuesMap valuesMap = theme.getValuesMap();
        JsonObject mainObject = new JsonObject();
        int i = 0;
        while (i < this.elements.length) {
            IThemeCssElement element = this.elements[i];
            String elementName = element.getName();
            JsonObject elementObj = new JsonObject();
            String[] properties = element.getProperties();
            int j = 0;
            while (j < properties.length) {
                String propertyName = properties[j];
                JsonArray valuesArray = new JsonArray();
                ConditionalValue[] values = valuesMap.getValues(elementName, propertyName);
                int k = 0;
                while (k < values.length) {
                    ConditionalValue conditionalValue = values[k];
                    JsonArray array = new JsonArray();
                    array.append(JsonArray.valueOf(conditionalValue.constraints));
                    array.append(Theme.createCssKey(conditionalValue.value));
                    valuesArray.append(array);
                    ++k;
                }
                elementObj.append(propertyName, valuesArray);
                ++j;
            }
            mainObject.append(elementName, elementObj);
            ++i;
        }
        this.cssValuesBuffer.append("ts.setThemeCssValues( ");
        this.cssValuesBuffer.append(JsonValue.quoteString(theme.getJsId()));
        this.cssValuesBuffer.append(", ");
        this.cssValuesBuffer.append(mainObject);
        this.cssValuesBuffer.append(", ");
        this.cssValuesBuffer.append(isDefault);
        this.cssValuesBuffer.append(" );\n");
    }
}

