/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.widgets;

import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.IBrowserHistory;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.events.BrowserHistoryEvent;
import org.eclipse.rwt.events.BrowserHistoryListener;
import org.eclipse.rwt.internal.AdapterManagerImpl;
import org.eclipse.rwt.internal.events.EventAdapter;
import org.eclipse.rwt.internal.events.IEventAdapter;
import org.eclipse.rwt.internal.lifecycle.CommonPatterns;
import org.eclipse.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rwt.internal.lifecycle.RWTLifeCycle;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.widgets.JSExecutor;
import org.eclipse.rwt.lifecycle.PhaseEvent;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.service.SessionStoreEvent;
import org.eclipse.rwt.service.SessionStoreListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public final class BrowserHistory
implements IBrowserHistory,
PhaseListener,
Adaptable,
SessionStoreListener {
    private static final long serialVersionUID = 1L;
    private static final String EVENT_HISTORY_NAVIGATED = "org.eclipse.rwt.events.historyNavigated";
    private static final String EVENT_HISTORY_NAVIGATED_ENTRY_ID = "org.eclipse.rwt.events.historyNavigated.entryId";
    private static final String ADD_TO_HISTORY = "qx.client.History.getInstance().addToHistory( {0}, {1} );";
    private final Display display = Display.getCurrent();
    private IEventAdapter eventAdapter;
    static /* synthetic */ Class class$0;

    public BrowserHistory() {
        LifeCycleFactory.getLifeCycle().addPhaseListener(this);
        RWT.getSessionStore().addSessionStoreListener(this);
    }

    public void createEntry(String id, String text) {
        if (id == null) {
            SWT.error(4);
        }
        if (id.length() == 0) {
            SWT.error(5);
        }
        String quotedId = "\"" + CommonPatterns.escapeDoubleQuoted(id) + "\"";
        String quotedText = text;
        if (quotedText != null) {
            quotedText = "\"" + CommonPatterns.escapeDoubleQuoted(text) + "\"";
        }
        Object[] args = new String[]{quotedId, quotedText};
        JSExecutor.executeJS(MessageFormat.format(ADD_TO_HISTORY, args));
    }

    public void addBrowserHistoryListener(BrowserHistoryListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        BrowserHistoryEvent.addListener(this, listener);
    }

    public void removeBrowserHistoryListener(BrowserHistoryListener lsnr) {
        if (lsnr == null) {
            SWT.error(4);
        }
        BrowserHistoryEvent.removeListener(this, lsnr);
    }

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        HttpServletRequest request;
        String isEvent;
        if (this.display == RWTLifeCycle.getSessionDisplay() && Boolean.valueOf(isEvent = (request = ContextProvider.getRequest()).getParameter(EVENT_HISTORY_NAVIGATED)).booleanValue()) {
            String entryId = request.getParameter(EVENT_HISTORY_NAVIGATED_ENTRY_ID);
            BrowserHistoryEvent evt = new BrowserHistoryEvent((Object)this, entryId);
            evt.processEvent();
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.PROCESS_ACTION;
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.events.IEventAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            if (this.eventAdapter == null) {
                this.eventAdapter = new EventAdapter();
            }
            result = this.eventAdapter;
        } else {
            result = AdapterManagerImpl.getInstance().getAdapter(this, adapter);
        }
        return result;
    }

    public void beforeDestroy(SessionStoreEvent event) {
        LifeCycleFactory.getLifeCycle().removePhaseListener(this);
    }
}

