/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.widgets;

import java.text.MessageFormat;
import org.eclipse.rwt.internal.widgets.JSExecutor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public final class ExternalBrowser {
    public static final int LOCATION_BAR = 2;
    public static final int NAVIGATION_BAR = 4;
    public static final int STATUS = 8;
    private static final String OPEN = "org.eclipse.rwt.widgets.ExternalBrowser.open( \"{0}\", \"{1}\", \"{2}\" );";
    private static final String CLOSE = "org.eclipse.rwt.widgets.ExternalBrowser.close( \"{0}\" );";

    public static void open(String id, String url, int style) {
        ExternalBrowser.checkWidget();
        if (id == null || url == null) {
            SWT.error(4);
        }
        if (id.length() == 0) {
            SWT.error(5);
        }
        JSExecutor.executeJS(ExternalBrowser.getOpenJS(id, url, style));
    }

    public static void close(String id) {
        ExternalBrowser.checkWidget();
        if (id == null) {
            SWT.error(4);
        }
        if (id.length() == 0) {
            SWT.error(5);
        }
        JSExecutor.executeJS(ExternalBrowser.getCloseJS(id));
    }

    private static String getOpenJS(String id, String url, int style) {
        Object[] args = new String[]{ExternalBrowser.escapeId(id), url, ExternalBrowser.getFeatures(style)};
        return MessageFormat.format(OPEN, args);
    }

    private static String getCloseJS(String id) {
        return MessageFormat.format(CLOSE, ExternalBrowser.escapeId(id));
    }

    static String escapeId(String id) {
        String result = id;
        result = result.replaceAll("\\_", "\\_0");
        result = result.replaceAll("\\.", "\\_");
        result = result.replaceAll(" ", "\\__");
        return result;
    }

    private static String getFeatures(int style) {
        StringBuffer result = new StringBuffer();
        ExternalBrowser.appendFeature(result, "dependent", true);
        ExternalBrowser.appendFeature(result, "scrollbars", true);
        ExternalBrowser.appendFeature(result, "resizable", true);
        ExternalBrowser.appendFeature(result, "status", (style & 8) != 0);
        ExternalBrowser.appendFeature(result, "location", (style & 2) != 0);
        boolean navigation = (style & 4) != 0;
        ExternalBrowser.appendFeature(result, "toolbar", navigation);
        ExternalBrowser.appendFeature(result, "menubar", navigation);
        return result.toString();
    }

    private static void appendFeature(StringBuffer features, String feature, boolean enable) {
        if (features.length() > 0) {
            features.append(",");
        }
        features.append(feature);
        features.append("=");
        features.append(enable ? 1 : 0);
    }

    private static void checkWidget() {
        if (Display.getCurrent().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
    }

    private ExternalBrowser() {
    }
}

