/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.ITextAdapter;
import org.eclipse.swt.internal.widgets.textkit.TextThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;

public class Text
extends Scrollable {
    private static final double LINE_HEIGHT_FACTOR = 1.2;
    public static final int LIMIT = Integer.MAX_VALUE;
    private final ITextAdapter textAdapter;
    private String text = "";
    private int textLimit = Integer.MAX_VALUE;
    private final Point selection = new Point(0, 0);
    static /* synthetic */ Class class$0;

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
        this.textAdapter = new ITextAdapter(){

            public void setText(String text, Point selection) {
                Text.this.setText(text, selection);
            }
        };
    }

    void initState() {
        if ((this.style & 8) != 0 && (this.style & 0xB00) == 0) {
            this.state |= 0x100;
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITextAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object result = clazz.equals(adapter) ? this.textAdapter : super.getAdapter(adapter);
        return result;
    }

    public void setText(String text) {
        String verifiedText;
        this.checkWidget();
        if (text == null) {
            SWT.error(4);
        }
        if ((verifiedText = this.verifyText(text, 0, this.text.length())) != null) {
            this.text = verifiedText.length() > this.textLimit ? verifiedText.substring(0, this.textLimit) : verifiedText;
            this.selection.x = 0;
            this.selection.y = 0;
            ModifyEvent modifyEvent = new ModifyEvent(this);
            modifyEvent.processEvent();
        }
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.setText(String.valueOf(this.text) + string);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return "\n";
    }

    public int getLineHeight() {
        this.checkWidget();
        Font font = this.getFont();
        int fontSize = font.getFontData()[0].getHeight();
        return (int)Math.floor((double)fontSize * 1.2);
    }

    public void setTextLimit(int textLimit) {
        this.checkWidget();
        if (textLimit == 0) {
            this.error(7);
        }
        this.textLimit = textLimit;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getCharCount() {
        this.checkWidget();
        return this.text.length();
    }

    public void setSelection(int start) {
        this.checkWidget();
        this.setSelection(start, start);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        int validatedStart = this.selection.x;
        int validatedEnd = this.selection.y;
        if (start >= 0 && end >= start) {
            validatedStart = Math.min(start, this.text.length());
            validatedEnd = Math.min(end, this.text.length());
        } else if (end >= 0 && start > end) {
            validatedStart = Math.min(end, this.text.length());
            validatedEnd = Math.min(start, this.text.length());
        }
        this.selection.x = validatedStart;
        this.selection.y = validatedEnd;
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public Point getSelection() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y);
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selection.y - this.selection.x;
    }

    public String getSelectionText() {
        this.checkWidget();
        return this.text.substring(this.selection.x, this.selection.y);
    }

    public void clearSelection() {
        this.checkWidget();
        this.selection.x = this.selection.y;
    }

    public void selectAll() {
        this.checkWidget();
        this.selection.x = 0;
        this.selection.y = this.text.length();
    }

    public int getCaretPosition() {
        this.checkWidget();
        return this.selection.x;
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!editable) {
            this.style |= 8;
        }
    }

    public boolean getEditable() {
        this.checkWidget();
        return (this.style & 8) == 0;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(5);
        }
        String oldText = this.getText();
        Point sel = this.getSelection();
        String replace = oldText.substring(0, sel.x);
        replace = String.valueOf(replace) + string;
        replace = String.valueOf(replace) + oldText.substring(sel.y);
        this.setText(replace);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int height = 0;
        int width = 0;
        if (wHint == -1 || hHint == -1) {
            boolean wrap = (this.style & 0x42) != 0;
            int wrapWidth = 0;
            if (wrap && wHint != -1) {
                wrapWidth = wHint;
            }
            Point extent = (this.getStyle() & 4) != 0 ? TextSizeDetermination.stringExtent(this.getFont(), this.text) : TextSizeDetermination.textExtent(this.getFont(), this.text, wrapWidth);
            Rectangle padding = this.getPadding();
            if (extent.x != 0) {
                width = extent.x + padding.width;
            }
            if (extent.y != 0) {
                height = extent.y + padding.height;
            }
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height += 2);
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle result = super.computeTrim(x, y, width, height);
        if ((this.style & 0x100) != 0) {
            ++result.width;
        }
        return result;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        ModifyEvent.addListener(this, listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        ModifyEvent.removeListener(this, listener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        VerifyEvent.addListener((Adaptable)this, verifyListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        VerifyEvent.removeListener((Adaptable)this, verifyListener);
    }

    boolean isTabGroup() {
        return true;
    }

    private Rectangle getPadding() {
        ThemeManager manager = ThemeManager.getInstance();
        TextThemeAdapter adapter = (TextThemeAdapter)manager.getThemeAdapter(this.getClass());
        return adapter.getPadding(this);
    }

    private String verifyText(String text, int start, int end) {
        VerifyEvent event = new VerifyEvent(this);
        event.text = text;
        event.start = start;
        event.end = end;
        event.processEvent();
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        String result = event.text;
        return result;
    }

    private void setText(String text, Point selection) {
        String verifiedText = this.verifyText(text, 0, this.text.length());
        if (verifiedText != null) {
            this.text = verifiedText;
            if (selection != null) {
                this.setSelection(selection.x, selection.y);
            }
            ModifyEvent modifyEvent = new ModifyEvent(this);
            modifyEvent.processEvent();
        }
    }

    private static int checkStyle(int style) {
        int result = style;
        if ((result & 4) != 0 && (result & 2) != 0) {
            result &= 0xFFFFFFFD;
        }
        if (((result = Text.checkBits(result, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            result &= 0xFFFFFCBF;
        }
        if ((result & 0x40) != 0) {
            result |= 2;
            result &= 0xFFFFFEFF;
        }
        if ((result & 2) != 0) {
            result &= 0xFFBFFFFF;
        }
        if ((result & 6) != 0) {
            return result;
        }
        if ((style & 0x300) != 0) {
            return result | 2;
        }
        return result | 4;
    }
}

