/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;

public class Intrinsics {
    public static final String[] intrinsics = new String[]{"associated", "present", "kind", "abs", "aimag", "aint", "anint", "ceiling", "cmplx", "floor", "int", "nint", "real", "conjg", "dim", "max", "min", "mod", "modulo", "sign", "acos", "asin", "atan", "atan2", "cos", "cosh", "exp", "log", "log10", "sin", "sinh", "sqrt", "tan", "tanh", "achar", "char", "iachar", "ichar", "lge", "lgt", "lle", "llt", "adjustl", "adjustr", "index", "len_trim", "scan", "verify", "logical", "len", "repeat", "trim", "digits", "epsilon", "huge", "maxexponent", "minexponent", "precision", "radix", "range", "tiny", "exponent", "fraction", "nearest", "rrspacing", "scale", "set_exponent", "spacing", "selected_int_kind", "selected_real_kind", "bit_size", "btest", "iand", "ibclr", "ibits", "ibset", "ieor", "ior", "ishft", "ishftc", "not", "dot_product", "matmul", "all", "any", "count", "maxval", "minval", "product", "sum", "allocated", "lbound", "shape", "size", "ubound", "merge", "pack", "unpack", "reshape", "spread", "cshift", "eoshift", "transpose", "maxloc", "minloc", "null", "mvbits", "date_and_time", "system_clock", "cpu_time", "random_number", "random_seed"};

    public static Definition resolveIntrinsic(Token identifier) {
        String canonicalizedName = PhotranVPG.canonicalizeIdentifier(identifier.getText());
        String[] stringArray = intrinsics;
        int n = intrinsics.length;
        int n2 = 0;
        while (n2 < n) {
            String intrinsic = stringArray[n2];
            if (intrinsic.matches(canonicalizedName)) {
                return new Intrinsic(identifier.getText(), identifier.getTokenRef());
            }
            ++n2;
        }
        return null;
    }

    private static class Intrinsic
    extends Definition {
        private static final long serialVersionUID = 1L;

        public Intrinsic(String declaredName, PhotranTokenRef tokenRef) {
            super(declaredName, tokenRef, Definition.Classification.INTRINSIC, Type.UNKNOWN);
        }

        public boolean isExternallyVisibleSubprogramDefinition() {
            return false;
        }

        public boolean isSubprogram() {
            return true;
        }
    }
}

