/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.dependence;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.photran.internal.core.analysis.dependence.PerfectLoopNest;
import org.eclipse.photran.internal.core.analysis.dependence.VariableReference;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.GenericASTVisitorWithLoops;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.rephraserengine.core.analysis.dependence.Dependence;
import org.eclipse.rephraserengine.core.analysis.dependence.DependenceTestFailure;
import org.eclipse.rephraserengine.core.analysis.dependence.Direction;
import org.eclipse.rephraserengine.core.analysis.dependence.IDependenceTester;
import org.eclipse.rephraserengine.core.analysis.dependence.IVariableReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoopDependences {
    private IDependenceTester[] testers;
    private PerfectLoopNest loopNest;
    private ArrayList<VariableReference> varRefs;
    private ArrayList<Dependence> dependences;

    private LoopDependences(ASTProperLoopConstructNode perfectLoopNest, IDependenceTester ... testers) {
        this.testers = testers;
        this.loopNest = new PerfectLoopNest(perfectLoopNest);
        this.varRefs = new ArrayList();
        this.dependences = new ArrayList();
    }

    public static LoopDependences computeFor(ASTProperLoopConstructNode perfectLoopNest, IDependenceTester ... testers) throws DependenceTestFailure {
        return new LoopDependences(perfectLoopNest, testers).collect();
    }

    private LoopDependences collect() {
        if (this.loopNest.containsDoWhileLoops()) {
            throw new DependenceTestFailure("The loop nest contains a do-while loop");
        }
        this.collectReadsAndWrites();
        this.collectDependences();
        return this;
    }

    private void collectReadsAndWrites() {
        this.loopNest.getBody().accept(new Visitor());
    }

    public Collection<VariableReference> getReads() {
        ArrayList<VariableReference> result = new ArrayList<VariableReference>(this.varRefs.size());
        for (VariableReference ref : this.varRefs) {
            if (ref.isWrite) continue;
            result.add(ref);
        }
        return result;
    }

    public Collection<VariableReference> getWrites() {
        ArrayList<VariableReference> result = new ArrayList<VariableReference>(this.varRefs.size());
        for (VariableReference ref : this.varRefs) {
            if (!ref.isWrite) continue;
            result.add(ref);
        }
        return result;
    }

    private void collectDependences() {
        int i = 0;
        while (i < this.varRefs.size()) {
            VariableReference from = this.varRefs.get(i);
            int j = 0;
            while (j < this.varRefs.size()) {
                if (j != i) {
                    VariableReference to = this.varRefs.get(j);
                    this.testForDependence(from, to);
                }
                ++j;
            }
            ++i;
        }
    }

    private void testForDependence(VariableReference from, VariableReference to) {
        if (from.variable.equals(to.variable) && (from.isWrite || to.isWrite) && (from.isScalar() || to.isScalar() || this.loopNest.testForDependenceUsing(this.testers, from, to, new Direction[0]))) {
            this.markDependence(from, to);
        }
    }

    private void markDependence(VariableReference from, VariableReference to) {
        this.dependences.add(new Dependence((IVariableReference)from, (IVariableReference)to));
    }

    public Collection<Dependence> getDependences() {
        return this.dependences;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Reads: ");
        sb.append(this.getReads());
        sb.append("\nWrites: ");
        sb.append(this.getWrites());
        sb.append("\n\nDependences:");
        for (Dependence dep : this.dependences) {
            sb.append("\n    " + dep);
        }
        return sb.toString();
    }

    private class Visitor
    extends GenericASTVisitorWithLoops {
        private IExecutionPartConstruct lastNodeSuccessfullyHandled = null;

        private Visitor() {
        }

        public void visitASTAssignmentStmtNode(ASTAssignmentStmtNode node) {
            if (node.getDerivedTypeComponentRef() != null) {
                throw new DependenceTestFailure("The loop contains an assignment to a derived type component");
            }
            LoopDependences.this.varRefs.addAll(VariableReference.fromRHS(node));
            LoopDependences.this.varRefs.add(VariableReference.fromLHS(node));
            this.lastNodeSuccessfullyHandled = node;
        }

        public void visitIExecutionPartConstruct(IExecutionPartConstruct node) {
            if (node != this.lastNodeSuccessfullyHandled) {
                throw new DependenceTestFailure("The loop contains an " + node.getClass().getSimpleName());
            }
        }
    }
}

