/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.photran.internal.core.lexer.IAccumulatingLexer;
import org.eclipse.photran.internal.core.lexer.SourceForm;

public final class LexerFactory {
    private LexerFactory() {
    }

    public static IAccumulatingLexer createLexer(InputStream in, IFile file, String filename, SourceForm sourceForm, boolean accumulateWhitetext) throws IOException {
        return sourceForm.createLexer(in, file, filename, accumulateWhitetext);
    }

    public static IAccumulatingLexer createLexer(File file, SourceForm sourceForm, boolean accumulateWhitetext) throws IOException {
        return LexerFactory.createLexer(new BufferedInputStream(new FileInputStream(file)), null, file.getAbsolutePath(), sourceForm, accumulateWhitetext);
    }

    public static IAccumulatingLexer createLexer(IFile file, SourceForm sourceForm, boolean accumulateWhitetext) throws CoreException, IOException {
        return LexerFactory.createLexer(file.getContents(true), file, LexerFactory.determineFilename(file), sourceForm, accumulateWhitetext);
    }

    private static String determineFilename(IFile file) {
        if (file == null) {
            return null;
        }
        IPath location = file.getLocation();
        if (location == null) {
            return file.getFullPath().toOSString();
        }
        return location.toOSString();
    }
}

