/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.properties;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class SearchPathProperties {
    public static final String ENABLE_VPG_PROPERTY_NAME = "EnableVPG";
    public static final String ENABLE_DECL_VIEW_PROPERTY_NAME = "EnableDeclView";
    public static final String ENABLE_CONTENT_ASSIST_PROPERTY_NAME = "EnableContentAssist";
    public static final String ENABLE_HOVER_TIP_PROPERTY_NAME = "EnableHoverTip";
    public static final String MODULE_PATHS_PROPERTY_NAME = "FortranModulePaths";
    public static final String INCLUDE_PATHS_PROPERTY_NAME = "FortranIncludePaths";
    protected static ProjectScope pScope = null;
    public static ScopedPreferenceStore scopedStore = null;

    protected static void initProjScope(IProject proj) {
        pScope = new ProjectScope(proj);
        scopedStore = new ScopedPreferenceStore((IScopeContext)pScope, "scoped_pref_store");
        String includeName = INCLUDE_PATHS_PROPERTY_NAME;
        String moduleName = MODULE_PATHS_PROPERTY_NAME;
        String defaultDir = String.valueOf(proj.getFullPath().toOSString()) + File.pathSeparator;
        scopedStore.setDefault(includeName, defaultDir);
        scopedStore.setDefault(moduleName, defaultDir);
    }

    public static String getProperty(IFile file, String propertyName) {
        if (file == null || file.getProject() == null) {
            return "";
        }
        return SearchPathProperties.getProperty(file.getProject(), propertyName);
    }

    public static void setProject(IProject project) {
        if (pScope == null || scopedStore == null) {
            SearchPathProperties.initProjScope(project);
        }
        IPath currPath = pScope.getLocation();
        IPath projPath = project.getLocation();
        if (currPath == null || projPath == null || !currPath.equals((Object)projPath.append(".settings"))) {
            SearchPathProperties.initProjScope(project);
        }
    }

    public static String getProperty(IProject project, String propertyName) {
        SearchPathProperties.setProject(project);
        String result = scopedStore.getString(propertyName);
        if (propertyName.equals(ENABLE_DECL_VIEW_PROPERTY_NAME) || propertyName.equals(ENABLE_CONTENT_ASSIST_PROPERTY_NAME)) {
            return result.equals("true") && SearchPathProperties.getProperty(project, ENABLE_VPG_PROPERTY_NAME).equals("true") ? "true" : "";
        }
        return result == null ? "" : result;
    }

    public static String getPropertyDefault(IProject project, String propertyName) {
        SearchPathProperties.setProject(project);
        return scopedStore.getDefaultString(propertyName);
    }

    public static void setProperty(IProject project, String propertyName, String value) {
        SearchPathProperties.setProject(project);
        scopedStore.setValue(propertyName, value);
    }

    public static String createList(String[] items) {
        StringBuffer path = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            path.append(items[i]);
            path.append(File.pathSeparator);
            ++i;
        }
        return path.toString();
    }

    public static String[] parseString(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, String.valueOf(File.pathSeparator) + "\n\r");
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v.toArray(new String[v.size()]);
    }

    public static IPreferenceStore getPropertyStore(final IProject project, final String propertyName) {
        return new CustomPropertyStore(){

            protected String getProperty() {
                return SearchPathProperties.getProperty(project, propertyName);
            }

            protected String getDefault() {
                return SearchPathProperties.getPropertyDefault(project, propertyName);
            }

            protected void setProperty(String value) {
                SearchPathProperties.setProperty(project, propertyName, value);
            }
        };
    }

    private static abstract class CustomPropertyStore
    implements IPreferenceStore {
        private CustomPropertyStore() {
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener) {
        }

        public boolean contains(String name) {
            throw new Error();
        }

        public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        }

        public boolean getBoolean(String name) {
            return this.getProperty().equals("true");
        }

        public boolean getDefaultBoolean(String name) {
            throw new Error();
        }

        public double getDefaultDouble(String name) {
            throw new Error();
        }

        public float getDefaultFloat(String name) {
            throw new Error();
        }

        public int getDefaultInt(String name) {
            throw new Error();
        }

        public long getDefaultLong(String name) {
            throw new Error();
        }

        public String getDefaultString(String name) {
            return this.getDefault();
        }

        public double getDouble(String name) {
            throw new Error();
        }

        public float getFloat(String name) {
            throw new Error();
        }

        public int getInt(String name) {
            throw new Error();
        }

        public long getLong(String name) {
            throw new Error();
        }

        public String getString(String name) {
            return this.getProperty();
        }

        public boolean isDefault(String name) {
            return this.getProperty() == null || this.getProperty().equals(this.getDefault());
        }

        public boolean needsSaving() {
            return false;
        }

        public void putValue(String name, String value) {
            this.setProperty(value);
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
        }

        public void setDefault(String name, double value) {
        }

        public void setDefault(String name, float value) {
        }

        public void setDefault(String name, int value) {
        }

        public void setDefault(String name, long value) {
        }

        public void setDefault(String name, String defaultObject) {
            throw new Error();
        }

        public void setDefault(String name, boolean value) {
            this.setProperty(null);
        }

        public void setToDefault(String name) {
            this.setProperty(null);
        }

        public void setValue(String name, double value) {
        }

        public void setValue(String name, float value) {
        }

        public void setValue(String name, int value) {
        }

        public void setValue(String name, long value) {
        }

        public void setValue(String name, String value) {
            this.setProperty(value);
        }

        public void setValue(String name, boolean value) {
            this.setProperty(value ? "true" : "false");
        }

        protected abstract String getProperty();

        protected abstract String getDefault();

        protected abstract void setProperty(String var1);
    }
}

