/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockNameNode;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockNode;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockObjectNode;
import org.eclipse.photran.internal.core.parser.ASTCommonStmtNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.ASTUseStmtNode;
import org.eclipse.photran.internal.core.parser.ISpecificationPartConstruct;
import org.eclipse.photran.internal.core.parser.ISpecificationStmt;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.refactoring.infrastructure.Reindenter;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SingleFileFortranRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.refactorings.UserInputString;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveCommonToModuleRefactoring
extends SingleFileFortranRefactoring {
    private static final String CRLF = System.getProperty("line.separator");
    private ASTCommonBlockNode commonBlockToMove = null;
    private String nameOfCommonBlockToMove = null;
    private String newModuleName = null;
    private Set<IFile> affectedFiles = null;

    public String getName() {
        return "Move COMMON Block to Module";
    }

    public String getSuggestedNewModuleName() {
        assert (this.commonBlockToMove != null && this.nameOfCommonBlockToMove != null);
        return this.nameOfCommonBlockToMove.equals("") ? "common" : this.nameOfCommonBlockToMove;
    }

    @UserInputString(label="Create a module named ", defaultValueMethod="getSuggestedNewModuleName")
    public void setNewModuleName(String name) {
        assert (name != null);
        this.newModuleName = name;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.findEnclosingCommonBlock();
        this.determineEnclosingCommonBlockName();
        this.determineAffectedFiles();
    }

    private void findEnclosingCommonBlock() throws VPGRefactoring.PreconditionFailure {
        Token enclosingToken = MoveCommonToModuleRefactoring.findEnclosingToken(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (enclosingToken == null) {
            this.fail("Please select a variable or block in a COMMON statement.");
        }
        this.commonBlockToMove = enclosingToken.findNearestAncestor(ASTCommonBlockNode.class);
        if (this.commonBlockToMove == null) {
            this.fail("Please select a variable or block in a COMMON statement.");
        }
    }

    private void determineEnclosingCommonBlockName() {
        this.nameOfCommonBlockToMove = this.getCommonBlockName(this.commonBlockToMove);
    }

    private String getCommonBlockName(ASTCommonBlockNode commonBlockToMove) {
        ASTCommonBlockNameNode commonBlockNameToken = commonBlockToMove.getName();
        if (commonBlockNameToken != null) {
            return commonBlockNameToken.getCommonBlockName().getText();
        }
        return "";
    }

    private void determineAffectedFiles() throws VPGRefactoring.PreconditionFailure {
        this.affectedFiles = new HashSet<IFile>();
        this.affectedFiles.add(this.fileInEditor);
        this.affectedFiles.addAll(((PhotranVPG)this.vpg).findFilesThatUseCommonBlock(this.nameOfCommonBlockToMove));
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        assert (this.commonBlockToMove != null && this.nameOfCommonBlockToMove != null && this.affectedFiles != null);
        assert (this.newModuleName != null);
        if (!MoveCommonToModuleRefactoring.isValidIdentifier(this.newModuleName)) {
            this.fail(String.valueOf(this.newModuleName) + " is not a valid identifier");
        }
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        assert (this.commonBlockToMove != null && this.nameOfCommonBlockToMove != null && this.affectedFiles != null);
        assert (this.newModuleName != null);
        try {
            for (IFile file : this.affectedFiles) {
                if (file.equals((Object)this.fileInEditor)) {
                    this.createModule();
                }
                this.replaceCommonBlockWithModuleUseIn(file);
                this.addChangeFromModifiedAST(file, pm);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void createModule() {
        ASTModuleNode module = this.createEmptyModule();
        for (ASTCommonBlockObjectNode obj : this.commonBlockToMove.getCommonBlockObjectList()) {
            this.populateModuleWithDeclarations(module, obj.getVariableName());
        }
        this.addModuleAtBeginningOfFile(module);
    }

    private ASTModuleNode createEmptyModule() {
        String moduleSource = "module " + this.newModuleName + CRLF + "    implicit none" + CRLF + "end module " + this.newModuleName + CRLF;
        return (ASTModuleNode)MoveCommonToModuleRefactoring.parseLiteralProgramUnit(moduleSource);
    }

    private void populateModuleWithDeclarations(ASTModuleNode module, Token variable) {
        List<ISpecificationPartConstruct> specificationStmts = this.findSpecificationStmtsFor(variable);
        module.getModuleBody().addAll(specificationStmts);
    }

    private List<ISpecificationPartConstruct> findSpecificationStmtsFor(Token variable) {
        List<Definition> defs = variable.resolveBinding();
        if (defs.size() == 1) {
            return this.findSpecificationStmtsFor(defs.get(0));
        }
        throw new Error();
    }

    private List<ISpecificationPartConstruct> findSpecificationStmtsFor(Definition def) {
        LinkedList<ISpecificationPartConstruct> result = new LinkedList<ISpecificationPartConstruct>();
        ASTTypeDeclarationStmtNode typeDecl = def.getTokenRef().findToken().findNearestAncestor(ASTTypeDeclarationStmtNode.class);
        if (typeDecl != null) {
            result.add((ISpecificationPartConstruct)typeDecl.clone());
        }
        for (PhotranTokenRef tokRef : def.findAllReferences(false)) {
            ISpecificationStmt enclosingSpecStmt = tokRef.findToken().findNearestAncestor(ISpecificationStmt.class);
            if (enclosingSpecStmt == null || enclosingSpecStmt instanceof ASTCommonStmtNode) continue;
            result.add((ISpecificationPartConstruct)enclosingSpecStmt.clone());
        }
        return result;
    }

    private void addModuleAtBeginningOfFile(ASTModuleNode module) {
        this.astOfFileInEditor.getRoot().getProgramUnitList().add(0, module);
        Reindenter.reindent(module, this.astOfFileInEditor, Reindenter.Strategy.REINDENT_EACH_LINE);
    }

    private void replaceCommonBlockWithModuleUseIn(IFile file) {
        IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquireTransientAST(file);
        for (ASTCommonBlockNode commonBlock : this.findCommonBlocksWithCorrectNameIn(ast)) {
            this.removeSpecificationStmtsForCommonBlockVars(commonBlock);
            ASTCommonStmtNode enclosingCommonStmt = commonBlock.findNearestAncestor(ASTCommonStmtNode.class);
            this.addUseStmtAtBeginningOfScopeContaining(enclosingCommonStmt, ast);
            if (this.commonStmtContainsOnlyOneCommonBlock(enclosingCommonStmt)) {
                enclosingCommonStmt.removeFromTree();
                continue;
            }
            commonBlock.removeFromTree();
        }
    }

    private List<ASTCommonBlockNode> findCommonBlocksWithCorrectNameIn(IFortranAST ast) {
        final LinkedList<ASTCommonBlockNode> result = new LinkedList<ASTCommonBlockNode>();
        ast.accept(new Parser.GenericASTVisitor(){

            public void visitASTCommonBlockNode(ASTCommonBlockNode commonBlock) {
                if (MoveCommonToModuleRefactoring.this.commonBlockHasSameName(commonBlock)) {
                    result.add(commonBlock);
                }
            }
        });
        return result;
    }

    private void removeSpecificationStmtsForCommonBlockVars(ASTCommonBlockNode commonBlock) {
        for (ASTCommonBlockObjectNode obj : commonBlock.getCommonBlockObjectList()) {
            for (ISpecificationPartConstruct specStmt : this.findSpecificationStmtsFor(obj.getVariableName())) {
                try {
                    specStmt.removeFromTree();
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }

    private void addUseStmtAtBeginningOfScopeContaining(ASTCommonStmtNode enclosingCommonStmt, IFortranAST ast) {
        ASTUseStmtNode useStmt = (ASTUseStmtNode)MoveCommonToModuleRefactoring.parseLiteralStatement("use " + this.newModuleName);
        ScopingNode enclosingScope = enclosingCommonStmt.findNearestAncestor(ScopingNode.class);
        enclosingScope.getBody().add(0, useStmt);
        Reindenter.reindent(useStmt, ast);
    }

    private boolean commonBlockHasSameName(ASTCommonBlockNode commonBlock) {
        String cnameOfThisCommonBlock = PhotranVPG.canonicalizeIdentifier(this.getCommonBlockName(commonBlock));
        String cnameOfCommonBlockToMove = PhotranVPG.canonicalizeIdentifier(this.nameOfCommonBlockToMove);
        return cnameOfThisCommonBlock.equals(cnameOfCommonBlockToMove);
    }

    private boolean commonStmtContainsOnlyOneCommonBlock(ASTCommonStmtNode enclosingCommonStmt) {
        return enclosingCommonStmt.getCommonBlockList().size() == 1;
    }
}

