/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTObjectNameNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.refactoring.infrastructure.MultipleFileFortranRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveUnusedVariablesRefactoring
extends MultipleFileFortranRefactoring {
    public String getName() {
        return "Remove Unused Local Variables";
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
        this.ensureAllScopesAreImplicitNone(status);
    }

    private void ensureAllScopesAreImplicitNone(RefactoringStatus status) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError("One of the selected files (" + file.getName() + ") cannot be parsed.");
                    continue;
                }
                this.ensureAllScopesAreImplicitNone(file, ast);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void ensureAllScopesAreImplicitNone(IFile file, IFortranAST ast) throws VPGRefactoring.PreconditionFailure {
        for (ScopingNode scope : ast.getRoot().getAllContainedScopes()) {
            if (scope instanceof ASTExecutableProgramNode || scope.isImplicitNone()) continue;
            this.fail("All of the selected files must be IMPLICIT NONE. Please use the Introduce Implict None refactoring first to introduce IMPLICIT NONE statements in the file " + file.getName() + ".");
        }
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError("One of the selected files (" + file.getName() + ") cannot be parsed.");
                    continue;
                }
                this.makeChangesTo(file, ast, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        boolean hasChanged = false;
        for (ScopingNode scope : ast.getRoot().getAllContainedScopes()) {
            if (!this.removedUnusedVariablesFromScope(scope)) continue;
            hasChanged = true;
        }
        if (hasChanged) {
            this.addChangeFromModifiedAST(file, pm);
            status.addInfo("After clicking 'Continue', do the same refactoring again to make sure that all unused variables are removed from file " + file.getName() + "!");
            status.addWarning("This refactoring does not remove unused variables when their dimentions are specified on another line. I.e. real a /n/n dimention a(10) will not be removed.");
        } else {
            status.addInfo("All unused variables have been removed from file " + file.getName() + "!");
        }
    }

    private boolean removedUnusedVariablesFromScope(ScopingNode scope) throws VPGRefactoring.PreconditionFailure {
        assert (this.debug("Scope: " + scope.getClass().getName()));
        boolean hasChanged = false;
        for (Definition def : scope.getAllDefinitions()) {
            if (!def.isLocalVariable() || !def.findAllReferences(true).isEmpty()) continue;
            this.removeVariableDeclFor(def);
            hasChanged = true;
        }
        return hasChanged;
    }

    private void removeVariableDeclFor(Definition def) throws VPGRefactoring.PreconditionFailure {
        assert (this.debug("The variable [" + def.getDeclaredName() + "] was not used and will be removed."));
        ASTTypeDeclarationStmtNode declarationNode = this.getTypeDeclarationStmtNode(def.getTokenRef().findToken().getParent());
        Parser.IASTListNode<ASTEntityDeclNode> entityDeclList = declarationNode.getEntityDeclList();
        if (entityDeclList.size() == 1) {
            declarationNode.replaceWith("\n");
        } else {
            this.removeVariableDeclFromList(def, entityDeclList);
        }
    }

    private void removeVariableDeclFromList(Definition def, Parser.IASTListNode<ASTEntityDeclNode> entityDeclList) throws VPGRefactoring.PreconditionFailure {
        for (ASTEntityDeclNode decl : entityDeclList) {
            ASTObjectNameNode objectName = decl.getObjectName();
            String declName = objectName.getObjectName().getText();
            if (!declName.equals(def.getDeclaredName())) continue;
            if (entityDeclList.remove(decl)) break;
            this.fail("Sorry, could not complete the operation.");
            break;
        }
        entityDeclList.findFirstToken().setWhiteBefore(" ");
    }

    private ASTTypeDeclarationStmtNode getTypeDeclarationStmtNode(Parser.IASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ASTTypeDeclarationStmtNode) {
            return (ASTTypeDeclarationStmtNode)node;
        }
        return this.getTypeDeclarationStmtNode(node.getParent());
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    private boolean debug(String msg) {
        System.out.println(msg);
        return true;
    }
}

