/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.ASTTypeSpecNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.refactoring.infrastructure.MultipleFileFortranRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.Reindenter;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SourcePrinter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardizeStatementsRefactoring
extends MultipleFileFortranRefactoring {
    public String getName() {
        return "Standardize Statements";
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError("One of the selected files (" + file.getName() + ") cannot be parsed.");
                }
                this.makeChangesTo(file, ast, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        List<ScopingNode> scopes = ast.getRoot().getAllContainedScopes();
        for (ScopingNode scope : scopes) {
            if (scope instanceof ASTExecutableProgramNode || scope instanceof ASTDerivedTypeDefNode) continue;
            this.standardizeStmtsInScope(scope.getBody(), ast);
        }
        this.addChangeFromModifiedAST(file, pm);
    }

    private void standardizeStmtsInScope(Parser.IASTListNode<Parser.IASTNode> body, IFortranAST ast) {
        List<ASTTypeDeclarationStmtNode> typeDeclStmts = this.createTypeDeclStmtList(body);
        this.insertNewStmts(typeDeclStmts, body, ast);
        this.removeOldStmts(typeDeclStmts, body);
    }

    private List<ASTTypeDeclarationStmtNode> createTypeDeclStmtList(Parser.IASTListNode<Parser.IASTNode> body) {
        LinkedList<ASTTypeDeclarationStmtNode> statements = new LinkedList<ASTTypeDeclarationStmtNode>();
        for (Parser.IASTNode node : body) {
            if (!(node instanceof ASTTypeDeclarationStmtNode)) continue;
            this.standardizeTypeDeclStmt((ASTTypeDeclarationStmtNode)node, statements);
        }
        return statements;
    }

    private void standardizeTypeDeclStmt(ASTTypeDeclarationStmtNode typeDeclStmt, List<ASTTypeDeclarationStmtNode> statements) {
        Parser.IASTListNode<ASTEntityDeclNode> variables = typeDeclStmt.getEntityDeclList();
        int i = 0;
        while (i < variables.size()) {
            ASTTypeDeclarationStmtNode newStmt = this.createNewVariableDeclaration(typeDeclStmt, i);
            statements.add(typeDeclStmt);
            statements.add(newStmt);
            ++i;
        }
    }

    private ASTTypeDeclarationStmtNode createNewVariableDeclaration(ASTTypeDeclarationStmtNode typeDeclStmt, int i) {
        Parser.IASTListNode<ASTEntityDeclNode> variables = typeDeclStmt.getEntityDeclList();
        ASTTypeDeclarationStmtNode newStmt = (ASTTypeDeclarationStmtNode)typeDeclStmt.clone();
        if (i > 0) {
            newStmt.setTypeSpec(this.createTypeSpecNodeFrom(typeDeclStmt));
        }
        Parser.IASTListNode newVariable = (Parser.IASTListNode)variables.clone();
        LinkedList<ASTEntityDeclNode> listOfVariablesToRemove = new LinkedList<ASTEntityDeclNode>();
        int j = 0;
        while (j < variables.size()) {
            if (j != i) {
                listOfVariablesToRemove.add((ASTEntityDeclNode)newVariable.get(j));
            }
            ++j;
        }
        newVariable.removeAll(listOfVariablesToRemove);
        newStmt.setEntityDeclList(newVariable);
        String source = this.addTwoColons(newStmt);
        newStmt = (ASTTypeDeclarationStmtNode)StandardizeStatementsRefactoring.parseLiteralStatement(source);
        return newStmt;
    }

    private ASTTypeSpecNode createTypeSpecNodeFrom(ASTTypeDeclarationStmtNode typeDeclStmt) {
        ASTTypeSpecNode typeNode = new ASTTypeSpecNode();
        String type = typeDeclStmt.getTypeSpec().toString().trim();
        String[] typeWithoutComments = type.split("\n");
        type = typeWithoutComments[typeWithoutComments.length - 1].trim();
        typeNode.setIsInteger(new Token(Terminal.T_INTEGER, type));
        return typeNode;
    }

    private String addTwoColons(ASTTypeDeclarationStmtNode newStmt) {
        String source = SourcePrinter.getSourceCodeFromASTNode(newStmt);
        int position_type = newStmt.getTypeSpec().toString().length();
        String twoPoints = "";
        String source_1 = source.substring(0, position_type);
        String source_2 = source.substring(position_type, source.length());
        if (!this.containsColonColon(source_2)) {
            twoPoints = " :: ";
        }
        source = String.valueOf(source_1) + twoPoints + source_2.trim();
        return source;
    }

    private boolean containsColonColon(String s) {
        int i = 0;
        while (i < s.length() - 1) {
            char p1 = s.charAt(i);
            char p2 = s.charAt(i + 1);
            if (p1 == '!' || p2 == '!') {
                return false;
            }
            if (p1 == ':' && p2 == ':') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void insertNewStmts(List<ASTTypeDeclarationStmtNode> typeDeclStmts, Parser.IASTListNode<Parser.IASTNode> body, IFortranAST ast) {
        int i = 0;
        while (i < typeDeclStmts.size()) {
            body.insertBefore(typeDeclStmts.get(i), typeDeclStmts.get(i + 1));
            Reindenter.reindent(typeDeclStmts.get(i + 1), ast);
            i += 2;
        }
    }

    private void removeOldStmts(List<ASTTypeDeclarationStmtNode> typeDeclStmts, Parser.IASTListNode<Parser.IASTNode> body) {
        int i = 0;
        while (i < typeDeclStmts.size()) {
            ASTTypeDeclarationStmtNode delete = typeDeclStmts.get(i);
            if (body.contains(delete)) {
                delete.removeFromTree();
            }
            i += 2;
        }
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }
}

