/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring.infrastructure;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.FortranAST;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.lexer.IAccumulatingLexer;
import org.eclipse.photran.internal.core.lexer.LexerFactory;
import org.eclipse.photran.internal.core.lexer.SourceForm;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCallStmtNode;
import org.eclipse.photran.internal.core.parser.ASTContainsStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTImplicitStmtNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTUseStmtNode;
import org.eclipse.photran.internal.core.parser.ASTVarOrFnRefNode;
import org.eclipse.photran.internal.core.parser.IBodyConstruct;
import org.eclipse.photran.internal.core.parser.IExpr;
import org.eclipse.photran.internal.core.parser.IProgramUnit;
import org.eclipse.photran.internal.core.parser.ISpecificationPartConstruct;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SourcePrinter;
import org.eclipse.photran.internal.core.util.IterableWrapper;
import org.eclipse.photran.internal.core.util.Notification;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.refactorings.IResourceRefactoring;
import org.eclipse.rephraserengine.core.util.OffsetLength;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGResourceRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultipleFileFortranRefactoring
extends VPGResourceRefactoring<IFortranAST, Token, PhotranVPG>
implements IResourceRefactoring {
    protected final PhotranVPG getVPG() {
        return PhotranVPG.getInstance();
    }

    protected final void preCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        status.addWarning("C preprocessor directives are IGNORED by the refactoring engine.  Use at your own risk.");
    }

    protected final String getSourceCodeFromAST(IFortranAST ast) {
        return SourcePrinter.getSourceCodeFromAST(ast);
    }

    protected void ensureProjectHasRefactoringEnabled(RefactoringStatus status) throws VPGRefactoring.PreconditionFailure {
        if (FortranCorePlugin.inTestingMode()) {
            return;
        }
        HashSet<IFile> filesToBeRemoved = new HashSet<IFile>();
        for (IFile f : this.selectedFiles) {
            if (PhotranVPG.getInstance().doesProjectHaveRefactoringEnabled(f)) continue;
            if (f.getProject() == null) {
                status.addWarning("The file " + f.getName() + " cannot be refactored because " + "it is not inside a Fortran project.");
                filesToBeRemoved.add(f);
                continue;
            }
            status.addWarning("Please enable analysis and refactoring in the project properties for " + f.getProject().getName() + ".");
            filesToBeRemoved.add(f);
        }
        this.selectedFiles.removeAll(filesToBeRemoved);
    }

    protected void removeFixedFormFilesFrom(Collection<IFile> files, RefactoringStatus status) {
        HashSet<IFile> filesToRemove = new HashSet<IFile>();
        for (IFile file : files) {
            if (filesToRemove.contains(file) || !FortranCorePlugin.hasFixedFormContentType((IFile)file)) continue;
            status.addError("The fixed form file " + file.getName() + " will not be refactored.");
            filesToRemove.add(file);
        }
        files.removeAll(filesToRemove);
    }

    protected void removeCpreprocessedFilesFrom(Collection<IFile> files, RefactoringStatus status) {
        HashSet<IFile> filesToRemove = new HashSet<IFile>();
        for (IFile file : files) {
            if (filesToRemove.contains(file) || !FortranCorePlugin.hasCppContentType((IFile)file)) continue;
            status.addError("The C-Preprocessed file " + file.getName() + " will not be refactored.");
            filesToRemove.add(file);
        }
        files.removeAll(filesToRemove);
    }

    protected RefactoringStatusContext createContext(Token token) {
        return this.createContext(token.getTokenRef());
    }

    protected static IBodyConstruct parseLiteralStatement(String string) {
        return (IBodyConstruct)MultipleFileFortranRefactoring.parseLiteralStatementSequence(string).get(0);
    }

    protected static IBodyConstruct parseLiteralStatementNoFail(String string) {
        try {
            return MultipleFileFortranRefactoring.parseLiteralStatement(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected static IExpr parseLiteralExpression(String string) {
        return ((ASTAssignmentStmtNode)MultipleFileFortranRefactoring.parseLiteralStatement("x = " + string)).getRhs();
    }

    protected static Parser.IASTListNode<IBodyConstruct> parseLiteralStatementSequence(String string) {
        string = "program p\n" + string + "\nend program";
        return ((ASTMainProgramNode)MultipleFileFortranRefactoring.parseLiteralProgramUnit(string)).getBody();
    }

    protected static ASTContainsStmtNode createContainsStmt() {
        String string = "program p\ncontains\nsubroutine s\nend subroutine\nend program";
        return ((ASTMainProgramNode)MultipleFileFortranRefactoring.parseLiteralProgramUnit(string)).getContainsStmt();
    }

    protected static IProgramUnit parseLiteralProgramUnit(String string) {
        try {
            IAccumulatingLexer lexer = LexerFactory.createLexer(new ByteArrayInputStream(string.getBytes()), null, "(none)", SourceForm.UNPREPROCESSED_FREE_FORM, true);
            Parser parser = new Parser();
            FortranAST ast = new FortranAST(null, parser.parse(lexer), lexer.getTokenList());
            return (IProgramUnit)ast.getRoot().getProgramUnitList().get(0);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    protected static String describeToken(Token token) {
        return "\"" + token.getText() + "\" " + MultipleFileFortranRefactoring.describeTokenPos(token);
    }

    protected static String describeTokenPos(Token token) {
        return "(line " + token.getLine() + ", column " + token.getCol() + ")";
    }

    protected static Definition findUnambiguousDeclaration(Token t) {
        if (t == null) {
            return null;
        }
        List<Definition> defs = t.resolveBinding();
        if (defs.size() <= 0 || defs.size() > 1) {
            return null;
        }
        return defs.get(0);
    }

    protected static Token findEnclosingToken(IFortranAST ast, ITextSelection selection) {
        Token prevToken = null;
        for (Token token : new IterableWrapper(ast)) {
            if (OffsetLength.contains((int)token.getFileOffset(), (int)token.getLength(), (int)selection.getOffset(), (int)selection.getLength())) {
                String tokenText = token.getText();
                if (tokenText.length() == 1 && Character.isWhitespace(tokenText.charAt(0))) {
                    return prevToken;
                }
                return token;
            }
            prevToken = token;
        }
        return null;
    }

    protected static Parser.IASTNode findEnclosingNode(IFortranAST ast, ITextSelection selection) {
        Token firstToken = MultipleFileFortranRefactoring.findFirstTokenAfter(ast, selection.getOffset());
        Token lastToken = MultipleFileFortranRefactoring.findLastTokenBefore(ast, OffsetLength.getPositionPastEnd((int)selection.getOffset(), (int)selection.getLength()));
        if (firstToken == null || lastToken == null) {
            return null;
        }
        Parser.IASTNode parent = lastToken.getParent();
        while (parent != null) {
            if (MultipleFileFortranRefactoring.contains(parent, firstToken)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    protected static boolean nodeExactlyEnclosesRegion(Parser.IASTNode parent, Token firstToken, Token lastToken) {
        return parent.findFirstToken() == firstToken && parent.findLastToken() == lastToken;
    }

    protected static boolean nodeExactlyEnclosesRegion(Parser.IASTNode node, IFortranAST ast, ITextSelection selection) {
        Token firstInNode = node.findFirstToken();
        Token lastInNode = node.findLastToken();
        Token firstInSel = MultipleFileFortranRefactoring.findFirstTokenAfter(ast, selection.getOffset());
        Token lastInSel = MultipleFileFortranRefactoring.findLastTokenBefore(ast, OffsetLength.getPositionPastEnd((int)selection.getOffset(), (int)selection.getLength()));
        return firstInNode != null && lastInNode != null && firstInSel != null && lastInSel != null && firstInNode == firstInSel && lastInNode == lastInSel;
    }

    private static boolean contains(Parser.IASTNode target, Token token) {
        Parser.IASTNode node = token.getParent();
        while (node != null) {
            if (node == target) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private static Token findFirstTokenAfter(IFortranAST ast, int targetFileOffset) {
        for (Token token : new IterableWrapper(ast)) {
            if (!token.isOnOrAfterFileOffset(targetFileOffset)) continue;
            return token;
        }
        return null;
    }

    private static Token findLastTokenBefore(IFortranAST ast, int targetFileOffset) {
        Token previousToken = null;
        for (Token token : new IterableWrapper(ast)) {
            if (token.isOnOrAfterFileOffset(targetFileOffset)) {
                return previousToken;
            }
            previousToken = token;
        }
        return null;
    }

    protected static ASTProperLoopConstructNode getLoopNode(IFortranAST ast, ITextSelection selection) {
        return (ASTProperLoopConstructNode)MultipleFileFortranRefactoring.getNode(ast, selection, ASTProperLoopConstructNode.class);
    }

    protected static Parser.ASTNode getNode(IFortranAST ast, ITextSelection selection, Class<? extends Parser.ASTNode> node) {
        Token firstToken = MultipleFileFortranRefactoring.findFirstTokenAfter(ast, selection.getOffset());
        Token lastToken = MultipleFileFortranRefactoring.findLastTokenBefore(ast, selection.getOffset() + selection.getLength());
        if (firstToken == null || lastToken == null) {
            return null;
        }
        return MultipleFileFortranRefactoring.getNode(firstToken, lastToken, node);
    }

    protected static Parser.ASTNode getNode(Token firstToken, Token lastToken, Class<? extends Parser.ASTNode> node) {
        assert (firstToken != null);
        assert (lastToken != null);
        Parser.ASTNode firstTokenNode = firstToken.findNearestAncestor(node);
        Parser.ASTNode lastTokenNode = lastToken.findNearestAncestor(node);
        if (firstTokenNode == null || lastTokenNode == null || firstTokenNode != lastTokenNode) {
            return null;
        }
        return firstTokenNode;
    }

    protected static ASTProperLoopConstructNode getLoopNode(Token firstToken, Token lastToken) {
        return (ASTProperLoopConstructNode)MultipleFileFortranRefactoring.getNode(firstToken, lastToken, ASTProperLoopConstructNode.class);
    }

    protected static StatementSequence findEnclosingStatementSequence(IFortranAST ast, ITextSelection selection) {
        Token firstToken = MultipleFileFortranRefactoring.findFirstTokenAfter(ast, selection.getOffset());
        Token lastToken = MultipleFileFortranRefactoring.findLastTokenBefore(ast, selection.getOffset() + selection.getLength());
        if (firstToken == null || lastToken == null) {
            return null;
        }
        Parser.IASTListNode listContainingFirstToken = firstToken.findNearestAncestor(Parser.IASTListNode.class);
        Parser.IASTListNode listContainingLastToken = lastToken.findNearestAncestor(Parser.IASTListNode.class);
        if (listContainingFirstToken == null || listContainingLastToken == null || listContainingFirstToken != listContainingLastToken) {
            return null;
        }
        Parser.IASTListNode listContainingStmts = listContainingFirstToken;
        int startIndex = -1;
        int endIndex = -1;
        int i = 0;
        while (i < listContainingStmts.size()) {
            Parser.IASTNode node = (Parser.IASTNode)listContainingStmts.get(i);
            if (MultipleFileFortranRefactoring.contains(node, firstToken)) {
                startIndex = i;
            }
            if (MultipleFileFortranRefactoring.contains(node, lastToken)) {
                endIndex = i;
            }
            ++i;
        }
        if (startIndex < 0 || endIndex < 0 || endIndex < startIndex) {
            throw new Error("INTERNAL ERROR: Unable to locate selected statements in IASTListNode");
        }
        return new StatementSequence(listContainingStmts.findNearestAncestor(ScopingNode.class), listContainingStmts, startIndex, endIndex);
    }

    /*
     * WARNING - void declaration
     */
    protected static int findIndexToInsertTypeDeclaration(Parser.IASTListNode<? extends Parser.IASTNode> body) {
        void var1_2;
        Object var1_1 = null;
        for (Parser.IASTNode iASTNode : body) {
            if (!(iASTNode instanceof ASTUseStmtNode) && !(iASTNode instanceof ASTImplicitStmtNode)) break;
        }
        if (var1_2 instanceof ASTUseStmtNode || var1_2 instanceof ASTImplicitStmtNode) {
            return body.indexOf(var1_2) + 1;
        }
        return body.indexOf(var1_2);
    }

    /*
     * WARNING - void declaration
     */
    protected static int findIndexToInsertStatement(Parser.IASTListNode<? extends Parser.IASTNode> body) {
        void var1_2;
        Object var1_1 = null;
        for (Parser.IASTNode iASTNode : body) {
            if (!(iASTNode instanceof ISpecificationPartConstruct)) break;
        }
        if (var1_2 instanceof ISpecificationPartConstruct) {
            return body.indexOf(var1_2) + 1;
        }
        return body.indexOf(var1_2);
    }

    protected static boolean isIdentifier(Token token) {
        return token != null && token.getTerminal() == Terminal.T_IDENT;
    }

    protected static boolean isPreprocessed(Token token) {
        return token.getPreprocessorDirective() != null;
    }

    protected static boolean isValidIdentifier(String name) {
        return Pattern.matches("[A-Za-z$][A-Za-z0-9$_]*", name);
    }

    protected static boolean isBoundIdentifier(Token t) {
        return MultipleFileFortranRefactoring.isIdentifier(t) && !t.resolveBinding().isEmpty();
    }

    protected static boolean isUniquelyDefinedIdentifer(Token t) {
        return MultipleFileFortranRefactoring.isBoundIdentifier(t) && t.resolveBinding().size() == 1;
    }

    protected static void checkForConflictingBindings(IProgressMonitor pm, IConflictingBindingCallback callback, Definition definitionToCheck, Collection<PhotranTokenRef> allReferences, String ... newNames) {
        MultipleFileFortranRefactoring.checkForConflictingBindings(pm, callback, definitionToCheck, allReferences, Arrays.asList(newNames));
    }

    protected static void checkForConflictingBindings(IProgressMonitor pm, IConflictingBindingCallback callback, Definition definitionToCheck, Collection<PhotranTokenRef> allReferences, Collection<String> newNames) {
        new CheckForConflictBindings(definitionToCheck, allReferences, newNames).check(pm, callback);
    }

    protected static boolean checkIfDeclarationCanBeAddedToScope(String name, ScopingNode scope, IProgressMonitor pm) {
        try {
            IConflictingBindingCallback callback = new IConflictingBindingCallback(){

                @Override
                public void addConflictError(List<Conflict> conflictingDef) {
                    throw new Notification(Boolean.FALSE);
                }

                @Override
                public void addConflictWarning(List<Conflict> conflictingDef) {
                    throw new Notification(Boolean.FALSE);
                }

                @Override
                public void addReferenceWillChangeError(String newName, Token reference) {
                    throw new Notification(Boolean.FALSE);
                }
            };
            new CheckForConflictBindings(scope, Collections.singleton(name)).check(pm, callback);
        }
        catch (Notification n) {
            return (Boolean)n.getResult();
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CheckForConflictBindings {
        private IProgressMonitor pm = null;
        private Definition definitionToCheck = null;
        private ScopingNode scopeOfDefinitionToCheck = null;
        private Collection<String> newNames = null;
        private Collection<PhotranTokenRef> allReferences = null;

        public CheckForConflictBindings(Definition definitionToCheck, Collection<PhotranTokenRef> allReferences, Collection<String> newNames) {
            this.definitionToCheck = definitionToCheck;
            this.scopeOfDefinitionToCheck = definitionToCheck.getTokenRef().findToken().getEnclosingScope();
            this.allReferences = allReferences;
            this.newNames = newNames;
        }

        public CheckForConflictBindings(ScopingNode checkInScope, Collection<String> newNames) {
            this.definitionToCheck = null;
            this.scopeOfDefinitionToCheck = checkInScope;
            this.allReferences = Collections.emptySet();
            this.newNames = newNames;
        }

        public void check(IProgressMonitor pm, IConflictingBindingCallback callback) {
            this.pm = pm;
            this.checkForConflictingDefinitionOrShadowing(callback);
            for (PhotranTokenRef ref : this.findReferencesToShadowedDefinitions()) {
                this.checkIfReferenceBindingWillChange(callback, ref, false);
            }
            for (PhotranTokenRef ref : this.allReferences) {
                this.checkIfReferenceBindingWillChange(callback, ref, true);
            }
        }

        private void checkForConflictingDefinitionOrShadowing(IConflictingBindingCallback callback) {
            List<Conflict> conflictingDef = this.findAllPotentiallyConflictingDefinitions();
            if (!conflictingDef.isEmpty()) {
                callback.addConflictError(conflictingDef);
            }
            if (!(conflictingDef = this.findAllPotentiallyConflictingUnboundSubprogramCalls()).isEmpty()) {
                callback.addConflictWarning(conflictingDef);
            }
        }

        private List<Conflict> findAllPotentiallyConflictingDefinitions() {
            ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
            if (this.definitionToCheck != null) {
                if (this.definitionToCheck.isMainProgram() || this.definitionToCheck.isSubprogram() || this.definitionToCheck.isModule()) {
                    this.findAllPotentiallyConflictingDefinitionsInScope(conflicts, this.definitionToCheck.getTokenRef().findToken().findNearestAncestor(ScopingNode.class), false);
                }
                for (String newName : this.newNames) {
                    if (!this.definitionToCheck.isInternalSubprogramDefinition() || !this.scopeContainingInternalSubprogram().isNamed(newName)) continue;
                    conflicts.add(new Conflict(newName, this.scopeContainingInternalSubprogram().getNameToken().getTokenRef()));
                }
            }
            for (ScopingNode importingScope : this.scopeItselfAndAllScopesThatImport(this.scopeOfDefinitionToCheck)) {
                this.pm.subTask("Checking for conflicting definitions in " + importingScope.describe());
                this.findAllPotentiallyConflictingDefinitionsInScope(conflicts, importingScope, true);
            }
            return conflicts;
        }

        private ScopingNode scopeContainingInternalSubprogram() {
            return this.definitionToCheck.getTokenRef().findToken().getEnclosingScope();
        }

        private void findAllPotentiallyConflictingDefinitionsInScope(List<Conflict> conflicts, ScopingNode importingScope, boolean shouldCheckIfDefinitionImportedIntoScope) {
            for (String newName : this.newNames) {
                List<PhotranTokenRef> definitionsLocalToScope = this.collectLocalDefinitions(importingScope);
                if (this.isProgramOrSubprogramOrModuleScope(importingScope) && shouldCheckIfDefinitionImportedIntoScope) {
                    if (importingScope.isNamed(newName)) {
                        if (this.definitionToCheck == null || definitionsLocalToScope.contains(this.definitionToCheck.getTokenRef())) {
                            conflicts.add(new Conflict(newName, importingScope.getNameToken().getTokenRef()));
                        }
                    } else {
                        ScopingNode parent = importingScope.findNearestAncestor(ScopingNode.class);
                        if (parent != null && parent.isNamed(newName)) {
                            List<PhotranTokenRef> definitionsLocalToParent = this.collectLocalDefinitions(parent);
                            if (this.definitionToCheck == null || definitionsLocalToParent.contains(this.definitionToCheck.getTokenRef())) {
                                conflicts.add(new Conflict(newName, parent.getNameToken().getTokenRef()));
                            }
                        }
                    }
                }
                Token.FakeToken newNameToken = this.definitionToCheck == null ? new Token.FakeToken(this.scopeOfDefinitionToCheck, newName) : new Token.FakeToken(this.definitionToCheck.getTokenRef().findToken(), newName);
                for (PhotranTokenRef conflict : importingScope.manuallyResolveInLocalScope(newNameToken)) {
                    if (!definitionsLocalToScope.contains(conflict)) continue;
                    if (shouldCheckIfDefinitionImportedIntoScope) {
                        if (this.definitionToCheck != null && !definitionsLocalToScope.contains(this.definitionToCheck.getTokenRef())) continue;
                        conflicts.add(new Conflict(newName, conflict));
                        continue;
                    }
                    conflicts.add(new Conflict(newName, conflict));
                }
            }
        }

        private List<PhotranTokenRef> findReferencesToShadowedDefinitions() {
            LinkedList<PhotranTokenRef> referencesToShadowedDefinitions = new LinkedList<PhotranTokenRef>();
            for (String newName : this.newNames) {
                Token.FakeToken token = this.definitionToCheck == null ? new Token.FakeToken(this.scopeOfDefinitionToCheck, newName) : new Token.FakeToken(this.definitionToCheck.getTokenRef().findToken(), newName);
                List<PhotranTokenRef> shadowedDefinitions = this.scopeOfDefinitionToCheck.manuallyResolve(token);
                for (ScopingNode importingScope : this.scopeOfDefinitionToCheck.findImportingScopes()) {
                    this.pm.subTask("Checking for references to " + newName + " in " + importingScope.describe());
                    shadowedDefinitions.addAll(importingScope.manuallyResolve(token));
                }
                for (PhotranTokenRef def : shadowedDefinitions) {
                    Definition definition = PhotranVPG.getInstance().getDefinitionFor(def);
                    if (definition == null) continue;
                    referencesToShadowedDefinitions.addAll(definition.findAllReferences(false));
                }
            }
            return referencesToShadowedDefinitions;
        }

        private void checkIfReferenceBindingWillChange(IConflictingBindingCallback callback, PhotranTokenRef ref, boolean shouldReferenceRenamedDefinition) {
            block6: {
                Token reference;
                block5: {
                    this.pm.subTask("Checking for binding conflicts in " + PhotranVPG.lastSegmentOfFilename((String)ref.getFilename()));
                    reference = ref.findToken();
                    if (this.definitionToCheck == null) break block5;
                    ScopingNode scopeOfDefinitionToRename = reference.findScopeDeclaringOrImporting(this.definitionToCheck);
                    if (scopeOfDefinitionToRename == null) {
                        return;
                    }
                    for (String newName : this.newNames) {
                        for (PhotranTokenRef existingBinding : new Token.FakeToken(reference, newName).manuallyResolveBinding()) {
                            ScopingNode scopeOfExistingBinding = existingBinding.findToken().getEnclosingScope();
                            boolean willReferenceRenamedDefinition = scopeOfExistingBinding.isParentScopeOf(scopeOfDefinitionToRename);
                            if (shouldReferenceRenamedDefinition == willReferenceRenamedDefinition) continue;
                            callback.addReferenceWillChangeError(newName, reference);
                        }
                    }
                    break block6;
                }
                if (this.scopeOfDefinitionToCheck != reference.getLocalScope() && !this.scopeOfDefinitionToCheck.isParentScopeOf(reference.getLocalScope())) break block6;
                for (String newName : this.newNames) {
                    for (PhotranTokenRef existingBinding : new Token.FakeToken(reference, newName).manuallyResolveBinding()) {
                        ScopingNode scopeOfExistingBinding = existingBinding.findToken().getEnclosingScope();
                        boolean willReferenceRenamedDefinition = scopeOfExistingBinding.isParentScopeOf(this.scopeOfDefinitionToCheck);
                        if (shouldReferenceRenamedDefinition == willReferenceRenamedDefinition) continue;
                        callback.addReferenceWillChangeError(newName, reference);
                    }
                }
            }
        }

        private List<Conflict> findAllPotentiallyConflictingUnboundSubprogramCalls() {
            final ArrayList<Conflict> conflictingDef = new ArrayList<Conflict>();
            for (ScopingNode importingScope : this.scopeItselfAndAllScopesThatImport(this.scopeOfDefinitionToCheck)) {
                this.pm.subTask("Checking for subprogram binding conflicts in " + importingScope.describe());
                importingScope.accept(new Parser.GenericASTVisitor(){

                    public void visitASTVarOrFnRefNode(ASTVarOrFnRefNode node) {
                        if (node.getName() != null && node.getName().getName() != null) {
                            this.checkForConflict(node.getName().getName());
                        }
                    }

                    public void visitASTCallStmtNode(ASTCallStmtNode node) {
                        if (node.getSubroutineName() != null) {
                            this.checkForConflict(node.getSubroutineName());
                        }
                    }

                    private void checkForConflict(Token name) {
                        if (name.getLogicalFile() != null) {
                            for (String newName : CheckForConflictBindings.this.newNames) {
                                if (name == null || !name.getText().equals(newName) || !name.resolveBinding().isEmpty()) continue;
                                conflictingDef.add(new Conflict(newName, name.getTokenRef()));
                            }
                        }
                    }
                });
            }
            return conflictingDef;
        }

        private Iterable<ScopingNode> scopeItselfAndAllScopesThatImport(final ScopingNode scope) {
            if (scope == null) {
                return Collections.emptySet();
            }
            return new Iterable<ScopingNode>(){

                @Override
                public Iterator<ScopingNode> iterator() {
                    return new Iterator<ScopingNode>(scope){
                        private ScopingNode first;
                        private Iterator<ScopingNode> rest;
                        {
                            this.first = scopingNode;
                            this.rest = scopingNode.findImportingScopes().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.first != null) {
                                return true;
                            }
                            return this.rest.hasNext();
                        }

                        @Override
                        public ScopingNode next() {
                            if (this.first != null) {
                                ScopingNode result = this.first;
                                this.first = null;
                                return result;
                            }
                            return this.rest.next();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        private List<PhotranTokenRef> collectLocalDefinitions(ScopingNode importingScope) {
            ArrayList<PhotranTokenRef> definitionsLocalToScope = new ArrayList<PhotranTokenRef>();
            for (Definition def : importingScope.getAllDefinitions()) {
                if (def.isIntrinsic()) continue;
                definitionsLocalToScope.add(def.getTokenRef());
            }
            return definitionsLocalToScope;
        }

        private boolean isProgramOrSubprogramOrModuleScope(ScopingNode scope) {
            return scope instanceof ASTMainProgramNode || scope instanceof ASTFunctionSubprogramNode || scope instanceof ASTSubroutineSubprogramNode || scope instanceof ASTModuleNode;
        }
    }

    public static final class Conflict {
        public final String name;
        public final PhotranTokenRef tokenRef;

        public Conflict(String name, PhotranTokenRef tokenRef) {
            this.name = name;
            this.tokenRef = tokenRef;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IConflictingBindingCallback {
        public void addConflictError(List<Conflict> var1);

        public void addConflictWarning(List<Conflict> var1);

        public void addReferenceWillChangeError(String var1, Token var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StatementSequence {
        public final ScopingNode enclosingScope;
        public final Parser.IASTListNode<? extends Parser.IASTNode> listContainingStmts;
        public final int startIndex;
        public final int endIndex;
        public final List<Parser.IASTNode> selectedStmts;

        private StatementSequence(ScopingNode enclosingScope, Parser.IASTListNode<? extends Parser.IASTNode> body, int startIndex, int endIndex) {
            this.enclosingScope = enclosingScope;
            this.listContainingStmts = body;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.selectedStmts = new ArrayList<Parser.IASTNode>();
            int i = startIndex;
            while (i <= endIndex) {
                if (body.get(i) != null) {
                    this.selectedStmts.add((Parser.IASTNode)body.get(i));
                }
                ++i;
            }
        }

        public Parser.IASTNode firstStmt() {
            return this.selectedStmts.get(0);
        }

        public Token firstToken() {
            return this.firstStmt().findFirstToken();
        }

        public Parser.IASTNode lastStmt() {
            return this.selectedStmts.get(this.selectedStmts.size() - 1);
        }

        public Token lastToken() {
            return this.lastStmt().findLastToken();
        }
    }
}

