/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LRUCache<T, U> {
    protected final int cacheSize;
    protected Map<T, U> cache;
    protected List<T> lruKeys;

    public LRUCache(int cacheSize) {
        this.cacheSize = cacheSize;
        this.cache = new HashMap<T, U>(cacheSize);
        this.lruKeys = new LinkedList<T>();
    }

    public boolean contains(T key) {
        return this.cache.containsKey(key);
    }

    public U get(T key) {
        if (this.lruKeys.get(0) != key) {
            if (!this.lruKeys.remove(key)) {
                return null;
            }
            this.lruKeys.add(0, key);
        }
        return this.cache.get(key);
    }

    public void clear() {
        this.cache.clear();
        this.lruKeys.clear();
    }

    public void cache(T key, U value) {
        if (this.cacheIsFull()) {
            this.removeLeastRecentlyUsedFromCache();
        }
        this.cache.put(key, value);
        this.lruKeys.add(key);
    }

    private boolean cacheIsFull() {
        return this.cache.size() == this.cacheSize;
    }

    private void removeLeastRecentlyUsedFromCache() {
        T lru = this.lruKeys.remove(0);
        this.cache.remove(lru);
    }

    public void remove(T key) {
        this.lruKeys.remove(key);
        this.cache.remove(key);
    }
}

