/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.vpg.IPhotranSerializable;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.PhotranVPGSerializer;
import org.eclipse.rephraserengine.core.vpg.TokenRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotranTokenRef
extends TokenRef<Token>
implements IPhotranSerializable,
Comparable<PhotranTokenRef> {
    private static final long serialVersionUID = 1L;

    public PhotranTokenRef(String filename, int offset, int length) {
        super(filename, offset, length);
        if (filename == null) {
            throw new IllegalArgumentException();
        }
    }

    public PhotranTokenRef(IFile file, int offset, int length) {
        this(PhotranVPG.getFilenameForIFile((IFile)file), offset, length);
    }

    public PhotranTokenRef(PhotranTokenRef copyFrom) {
        super((TokenRef)copyFrom);
    }

    public IFile getFile() {
        return PhotranVPG.getIFileForFilename((String)this.getFilename());
    }

    public Token findToken() {
        try {
            return PhotranVPG.getInstance().findToken(this);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public Token findTokenOrReturnNull() {
        return PhotranVPG.getInstance().findToken(this);
    }

    public String getText() {
        return this.findToken().getText();
    }

    @Override
    public int compareTo(PhotranTokenRef that) {
        int result = this.getFilename().compareTo(that.getFilename());
        if (result == 0) {
            result = Integer.valueOf(this.getOffset()).compareTo(that.getOffset());
        }
        if (result == 0) {
            result = Integer.valueOf(this.getLength()).compareTo(that.getLength());
        }
        return result;
    }

    public static PhotranTokenRef readFrom(InputStream in) throws IOException {
        String filename = (String)PhotranVPGSerializer.deserialize(in);
        int offset = (Integer)PhotranVPGSerializer.deserialize(in);
        int length = (Integer)PhotranVPGSerializer.deserialize(in);
        return new PhotranTokenRef(filename, offset, length);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        PhotranVPGSerializer.serialize(this.getFilename(), out);
        PhotranVPGSerializer.serialize(this.getOffset(), out);
        PhotranVPGSerializer.serialize(this.getLength(), out);
    }

    @Override
    public char getSerializationCode() {
        return 'T';
    }
}

