/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.rse.core.RSEConnection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSEConnectionManager
implements IRemoteConnectionManager {
    private IFileSystem fileSystem = null;
    private final ISystemRegistry registry;
    private final Map<String, RSEConnection> connections = new HashMap<String, RSEConnection>();

    public RSEConnectionManager(ISystemRegistry registry) {
        this.registry = registry;
        try {
            this.fileSystem = EFS.getFileSystem((String)"rse");
        }
        catch (CoreException coreException) {}
    }

    public IRemoteConnection getConnection(String name) {
        this.refreshConnections();
        if (name != null) {
            return this.connections.get(name);
        }
        return null;
    }

    public IRemoteConnection[] getConnections() {
        this.refreshConnections();
        return this.connections.values().toArray(new IRemoteConnection[this.connections.size()]);
    }

    public IRemoteConnection newConnection(String name, Map<String, String> attributes) throws RemoteConnectionException {
        return null;
    }

    public void refreshConnections() {
        if (this.fileSystem != null) {
            IHost[] hosts;
            HashMap<String, RSEConnection> newConns = new HashMap<String, RSEConnection>();
            IHost[] iHostArray = hosts = this.registry.getHostsBySubSystemConfigurationCategory("shells");
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                IHost host = iHostArray[n2];
                RSEConnection conn = this.connections.get(host);
                if (conn != null || (conn = new RSEConnection(host, this.fileSystem)).initialize()) {
                    newConns.put(host.getAliasName(), conn);
                }
                ++n2;
            }
            this.connections.clear();
            this.connections.putAll(newConns);
        }
    }

    public void removeConnection(IRemoteConnection conn) {
        if (conn instanceof RSEConnection) {
            ((RSEConnection)conn).dispose();
        }
        this.connections.remove(conn.getName());
    }
}

