/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.wizards.wizardPages;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.pldt.openmp.core.OpenMPIDs;
import org.eclipse.ptp.pldt.openmp.core.OpenMPPlugin;
import org.eclipse.ptp.pldt.openmp.core.prefs.OpenMPPreferencePage;
import org.eclipse.ptp.pldt.wizards.wizardPages.AbstractProjectWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMPProjectWizardPage
extends AbstractProjectWizardPage {
    public static final String DOT = ".";
    private static final boolean traceOn = false;
    public static final boolean wizardTraceOn = false;
    private Composite composite;
    public static final String PAGE_ID = "org.eclipse.ptp.pldt.wizards.wizardPages.OpenMPProjectWizardPage";
    public static final String DO_OpenMP_INCLUDES = "doOpenMPincludes";
    public static final String INCLUDE_PATH_PROP_ID = "includePath";
    public static final String LIB_PROP_ID = "lib";
    public static final String LIBRARY_SEARCH_PATH_PROP_ID = "libPath";
    public static final String OpenMP_COMPILE_COMMAND_PROP_ID = "OpenMPCompileCommand";
    public static final String OpenMP_LINK_COMMAND_PROP_ID = "OpenMPLinkCommand";
    private String currentOpenMPIncludePath;
    private String currentLibName;
    private String currentLibPath;
    private String currentOpenMPCompileCommand;
    private String currentOpenMPLinkCommand;
    private String defaultOpenMPIncludePath;
    private String defaultOpenMPLibName;
    private String defaultOpenMPLibPath;
    private String defaultOpenMPBuildCommand;
    private Text includePathField;
    private Text libNameField;
    private Text libPathField;
    private Text openMPCompileCommandField;
    private Text openMPLinkCommandField;
    private Label includePathLabel;
    private Label libLabel;
    private Label libPathLabel;
    private Label openMPCompileCommandLabel;
    private Label openMPLinkCommandLabel;
    private Button browseButton;
    private Button browseButton2;
    private Button useDefaultsButton;
    private Button useOpenMPProjectSettingsButton;
    private static boolean defaultUseOpenMPIncludes = true;
    private Button OpenMPSampleButton;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private boolean useOpenMPProjectSettings = true;
    private String desc = "OpenMP Project Page";
    private static boolean alreadyShown;
    Map<String, String> pageData = new HashMap<String, String>();

    public OpenMPProjectWizardPage() throws CoreException {
        super("OpenMP Project Settings");
        this.prefIDincludes = OpenMPIDs.OpenMP_INCLUDES;
        this.preferenceStore = OpenMPPlugin.getDefault().getPreferenceStore();
        this.preferenceStore.getString(this.prefIDincludes);
        this.defaultOpenMPIncludePath = this.preferenceStore.getString(this.prefIDincludes);
        if (this.defaultOpenMPIncludePath.length() == 0) {
            String newIncludePath;
            this.defaultOpenMPIncludePath = newIncludePath = this.showNoPrefs("OpenMP", this.prefIDincludes);
        }
        this.setDefaultOtherNames(this.defaultOpenMPIncludePath);
        this.setCurrentOpenMPIncludePath(this.defaultOpenMPIncludePath);
        this.defaultOpenMPBuildCommand = this.preferenceStore.getString("gcc -fopenmp");
        this.setCurrentOpenMPCompileCommand(this.defaultOpenMPBuildCommand);
        this.setCurrentOpenMPLinkCommand(this.defaultOpenMPBuildCommand);
    }

    private static void showNoPrefs1() {
        if (!alreadyShown) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            StringBuffer buf = new StringBuffer("No OpenMP Preferences set; ");
            buf.append("Default project setting will be more useful if OpenMP preferences are set first. ");
            buf.append("\nUse Window > Preferences and select Parallel Language Development Tools, which may be under PTP preferences.");
            buf.append("You can cancel out of new project wizard to enter OpenMP preferences now.");
            MessageDialog.openWarning((Shell)shell, (String)"No OpenMP Preferences set", (String)buf.toString());
            alreadyShown = true;
        }
    }

    private void setDefaultOtherNames(String openMPincludePath) {
        this.defaultOpenMPLibName = "";
        this.setCurrentOpenMPLibName(this.defaultOpenMPLibName);
        String tempPath = openMPincludePath;
        int sepLoc = tempPath.indexOf(File.pathSeparatorChar);
        if (-1 != sepLoc) {
            tempPath = openMPincludePath.substring(0, sepLoc);
        }
        IPath path = Path.fromOSString((String)tempPath);
        path = path.removeLastSegments(1);
        path = path.addTrailingSeparator();
        this.defaultOpenMPLibPath = "";
        this.setCurrentOpenMPLibPath(this.defaultOpenMPLibPath);
        path = Path.fromOSString((String)openMPincludePath);
        String temp = path.toString();
        this.defaultOpenMPIncludePath = temp = this.stripTrailingSeparator(temp);
        this.setCurrentOpenMPIncludePath(this.defaultOpenMPIncludePath);
        this.setCurrentOpenMPCompileCommand(this.defaultOpenMPBuildCommand);
    }

    private void setCurrentOpenMPIncludePath(String path) {
        this.currentOpenMPIncludePath = path;
        this.pageData.put("org.eclipse.ptp.pldt.wizards.wizardPages.OpenMPProjectWizardPage.includePath", path);
    }

    private void setCurrentOpenMPLibName(String name) {
        this.currentOpenMPIncludePath = name;
        this.pageData.put("org.eclipse.ptp.pldt.wizards.wizardPages.OpenMPProjectWizardPage.lib", name);
    }

    private void setCurrentOpenMPLibPath(String path) {
        this.currentOpenMPIncludePath = path;
        this.pageData.put("org.eclipse.ptp.pldt.wizards.wizardPages.OpenMPProjectWizardPage.libPath", path);
    }

    private void setCurrentOpenMPCompileCommand(String buildCommand) {
        this.currentOpenMPCompileCommand = buildCommand;
        this.pageData.put("org.eclipse.ptp.pldt.wizards.wizardPages.OpenMPProjectWizardPage.OpenMPCompileCommand", buildCommand);
    }

    private void setCurrentOpenMPLinkCommand(String buildCommand) {
        this.currentOpenMPLinkCommand = buildCommand;
        this.pageData.put("org.eclipse.ptp.pldt.wizards.wizardPages.OpenMPProjectWizardPage.OpenMPLinkCommand", buildCommand);
    }

    public String getName() {
        return new String(String.valueOf(this.desc) + " name");
    }

    private String getPathFromPathField(Text textField) {
        URI fieldURI;
        try {
            fieldURI = new URI(textField.getText());
        }
        catch (URISyntaxException uRISyntaxException) {
            return textField.getText();
        }
        return fieldURI.getPath();
    }

    private void updateIncludePathField(String selectedPath) {
        this.includePathField.setText(selectedPath);
    }

    private void updateLibPathField(String selectedPath) {
        this.libPathField.setText(selectedPath);
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory = null;
        String dirName = this.getPathFromPathField(this.includePathField);
        DirectoryDialog dialog = new DirectoryDialog(this.includePathField.getShell());
        dialog.setMessage("OpenMP Include path:");
        dialog.setFilterPath(dirName);
        selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.updateIncludePathField(selectedDirectory);
            this.includePathField.setText(selectedDirectory);
            this.setCurrentOpenMPIncludePath(selectedDirectory);
        }
    }

    private void handleLocationBrowseButton2Pressed() {
        String selectedDirectory = null;
        String dirName = this.getPathFromPathField(this.libPathField);
        DirectoryDialog dialog = new DirectoryDialog(this.libPathField.getShell());
        dialog.setMessage("OpenMP library search path:");
        dialog.setFilterPath(dirName);
        selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.updateLibPathField(selectedDirectory);
            this.libPathField.setText(selectedDirectory);
            this.setCurrentOpenMPLibPath(selectedDirectory);
        }
    }

    private String stripTrailingSeparator(String str) {
        if (str.length() == 0) {
            return str;
        }
        char lastChar = str.charAt(str.length() - 1);
        if (lastChar == File.pathSeparatorChar) {
            String temp = str.substring(0, str.length() - 1);
            return temp;
        }
        return str;
    }

    private void createUserEntryArea(Composite composite, boolean defaultEnabled) {
        this.includePathLabel = new Label(composite, 0);
        this.includePathLabel.setText("Include path:");
        this.includePathLabel.setToolTipText("Location of OpenMP include path(s)");
        this.includePathField = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.includePathField.setLayoutData((Object)data);
        this.includePathField.setText(this.defaultOpenMPIncludePath);
        this.includePathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenMPProjectWizardPage.this.setCurrentOpenMPIncludePath(OpenMPProjectWizardPage.this.includePathField.getText());
            }
        });
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OpenMPProjectWizardPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.libLabel = new Label(composite, 0);
        this.libLabel.setText("Library name:");
        this.libLabel.setToolTipText("Library name:");
        this.libNameField = new Text(composite, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        gd.horizontalSpan = 2;
        this.libNameField.setLayoutData((Object)gd);
        this.libNameField.setText(this.defaultOpenMPLibName);
        this.libNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenMPProjectWizardPage.this.setCurrentOpenMPLibName(OpenMPProjectWizardPage.this.libNameField.getText());
            }
        });
        new Label(composite, 0).setText(" ");
        this.libPathLabel = new Label(composite, 0);
        this.libPathLabel.setText("Library search path:");
        this.libPathLabel.setToolTipText("Library name:");
        this.libPathField = new Text(composite, 2048);
        GridData gd2 = new GridData(768);
        gd2.widthHint = 250;
        gd2.horizontalSpan = 2;
        this.libPathField.setLayoutData((Object)gd2);
        this.libPathField.setText(this.defaultOpenMPLibPath);
        this.libPathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenMPProjectWizardPage.this.setCurrentOpenMPLibPath(OpenMPProjectWizardPage.this.libPathField.getText());
            }
        });
        this.browseButton2 = new Button(composite, 8);
        this.browseButton2.setText("Browse...");
        this.browseButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OpenMPProjectWizardPage.this.handleLocationBrowseButton2Pressed();
            }
        });
        this.openMPCompileCommandLabel = new Label(composite, 0);
        this.openMPCompileCommandLabel.setText("OpenMP compile command: ");
        this.openMPCompileCommandField = new Text(composite, 2048);
        GridData gd3 = new GridData(768);
        gd3.widthHint = 250;
        gd3.horizontalSpan = 2;
        this.openMPCompileCommandField.setLayoutData((Object)gd3);
        this.openMPCompileCommandField.setText(this.defaultOpenMPBuildCommand);
        this.openMPCompileCommandField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenMPProjectWizardPage.this.setCurrentOpenMPCompileCommand(OpenMPProjectWizardPage.this.openMPCompileCommandField.getText());
            }
        });
        new Label(composite, 0).setText(" ");
        this.openMPLinkCommandLabel = new Label(composite, 0);
        this.openMPLinkCommandLabel.setText("OpenMP link command: ");
        this.openMPLinkCommandField = new Text(composite, 2048);
        GridData gd4 = new GridData(768);
        gd4.widthHint = 250;
        gd4.horizontalSpan = 2;
        this.openMPLinkCommandField.setLayoutData((Object)gd3);
        this.openMPLinkCommandField.setText(this.defaultOpenMPBuildCommand);
        this.openMPLinkCommandField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenMPProjectWizardPage.this.setCurrentOpenMPLinkCommand(OpenMPProjectWizardPage.this.openMPLinkCommandField.getText());
            }
        });
        new Label(composite, 0).setText(" ");
    }

    private void createContents(Composite composite, boolean defaultEnabled) {
        int columns = 4;
        Composite group = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.useOpenMPProjectSettingsButton = new Button(group, 131104);
        this.useOpenMPProjectSettingsButton.setText("Add OpenMP project settings to this project");
        GridData gd = new GridData();
        gd.horizontalSpan = columns;
        this.useOpenMPProjectSettingsButton.setLayoutData((Object)gd);
        this.useOpenMPProjectSettingsButton.setSelection(this.useOpenMPProjectSettings);
        this.useOpenMPProjectSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenMPProjectWizardPage.this.useOpenMPProjectSettings = OpenMPProjectWizardPage.this.useOpenMPProjectSettingsButton.getSelection();
                OpenMPProjectWizardPage.this.pageData.put("org.eclipse.ptp.pldt.wizards.wizardPages.OpenMPProjectWizardPage.doOpenMPincludes", Boolean.toString(OpenMPProjectWizardPage.this.useOpenMPProjectSettings));
                OpenMPProjectWizardPage.this.useDefaultsButton.setEnabled(OpenMPProjectWizardPage.this.useOpenMPProjectSettings);
                if (OpenMPProjectWizardPage.this.OpenMPSampleButton != null) {
                    OpenMPProjectWizardPage.this.OpenMPSampleButton.setEnabled(OpenMPProjectWizardPage.this.useOpenMPProjectSettings);
                }
                if (OpenMPProjectWizardPage.this.useOpenMPProjectSettings) {
                    boolean useDefaults = OpenMPProjectWizardPage.this.useDefaultsButton.getSelection();
                    OpenMPProjectWizardPage.this.setUserAreaEnabled(!useDefaults);
                } else {
                    OpenMPProjectWizardPage.this.setUserAreaEnabled(false);
                }
            }
        });
        this.useDefaultsButton = new Button(group, 131104);
        this.useDefaultsButton.setText("Use default information");
        this.useDefaultsButton.setSelection(defaultEnabled);
        this.useDefaultsButton.setEnabled(false);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = columns;
        this.useDefaultsButton.setLayoutData((Object)buttonData);
        this.useDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaults = OpenMPProjectWizardPage.this.useDefaultsButton.getSelection();
                if (useDefaults) {
                    OpenMPProjectWizardPage.this.includePathField.setText(OpenMPProjectWizardPage.this.defaultOpenMPIncludePath);
                    OpenMPProjectWizardPage.this.setCurrentOpenMPIncludePath(OpenMPProjectWizardPage.this.defaultOpenMPIncludePath);
                    OpenMPProjectWizardPage.this.libPathField.setText(OpenMPProjectWizardPage.this.defaultOpenMPLibName);
                    OpenMPProjectWizardPage.this.setCurrentOpenMPLibName(OpenMPProjectWizardPage.this.defaultOpenMPLibName);
                    OpenMPProjectWizardPage.this.libNameField.setText(OpenMPProjectWizardPage.this.defaultOpenMPLibName);
                    OpenMPProjectWizardPage.this.setCurrentOpenMPLibName(OpenMPProjectWizardPage.this.defaultOpenMPLibName);
                    OpenMPProjectWizardPage.this.libPathField.setText(OpenMPProjectWizardPage.this.defaultOpenMPLibPath);
                    OpenMPProjectWizardPage.this.setCurrentOpenMPLibPath(OpenMPProjectWizardPage.this.defaultOpenMPLibPath);
                    OpenMPProjectWizardPage.this.openMPCompileCommandField.setText(OpenMPProjectWizardPage.this.defaultOpenMPBuildCommand);
                    OpenMPProjectWizardPage.this.setCurrentOpenMPCompileCommand(OpenMPProjectWizardPage.this.defaultOpenMPBuildCommand);
                    OpenMPProjectWizardPage.this.openMPLinkCommandField.setText(OpenMPProjectWizardPage.this.defaultOpenMPBuildCommand);
                    OpenMPProjectWizardPage.this.setCurrentOpenMPLinkCommand(OpenMPProjectWizardPage.this.defaultOpenMPBuildCommand);
                }
                OpenMPProjectWizardPage.this.setUserAreaEnabled(!useDefaults);
            }
        });
        this.createUserEntryArea(group, defaultEnabled);
        this.setUserAreaEnabled(!defaultEnabled);
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.composite.setLayoutData((Object)new GridData(1808));
        boolean defaultEnabled = true;
        this.createContents(this.composite, defaultEnabled);
    }

    public void dispose() {
        this.composite.dispose();
    }

    public Control getControl() {
        return this.composite;
    }

    public String getDescription() {
        String tmp = "Select the OpenMP include path, lib name, library search path, and build command information to be automatically be added to the new project.";
        return tmp;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        return this.getWizard().getDefaultPageImage();
    }

    public String getMessage() {
        return null;
    }

    public String getTitle() {
        return "OpenMP Project Settings";
    }

    public void performHelp() {
    }

    public void setDescription(String description) {
    }

    public void setImageDescriptor(ImageDescriptor image) {
    }

    public void setTitle(String title) {
    }

    public void setVisible(boolean visible) {
        this.composite.setVisible(visible);
    }

    protected boolean isCustomPageComplete() {
        return true;
    }

    private void setUserAreaEnabled(boolean enabled) {
        this.includePathField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.browseButton2.setEnabled(enabled);
        this.libNameField.setEnabled(enabled);
        this.libPathField.setEnabled(enabled);
        this.includePathLabel.setEnabled(enabled);
        this.libPathLabel.setEnabled(enabled);
        this.libLabel.setEnabled(enabled);
        this.openMPCompileCommandLabel.setEnabled(enabled);
        this.openMPCompileCommandField.setEnabled(enabled);
        this.openMPLinkCommandLabel.setEnabled(enabled);
        this.openMPLinkCommandField.setEnabled(enabled);
    }

    public static boolean getDefaultUseOpenMPIncludes() {
        return defaultUseOpenMPIncludes;
    }

    public Map<String, String> getPageData() {
        return this.pageData;
    }

    @Override
    protected IPreferencePage getPreferencePage() {
        if (this.preferencePage == null) {
            this.preferencePage = new OpenMPPreferencePage();
        }
        return this.preferencePage;
    }
}

