/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.FetchAttributeMetadata;
import org.eclipse.persistence.queries.FetchGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchGroupMetadata
extends ORMetadata {
    private List<FetchAttributeMetadata> m_fetchAttributes = new ArrayList<FetchAttributeMetadata>();
    private String m_name;

    public FetchGroupMetadata() {
        super("<fetch-group>");
    }

    public FetchGroupMetadata(MetadataAnnotation fetchGroup, MetadataAccessibleObject accessibleObject) {
        super(fetchGroup, accessibleObject);
        this.m_name = (String)fetchGroup.getAttribute("name");
        for (Object fetchAttribute : (Object[])fetchGroup.getAttributeArray("attributes")) {
            this.m_fetchAttributes.add(new FetchAttributeMetadata((MetadataAnnotation)fetchAttribute, accessibleObject));
        }
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof FetchGroupMetadata) {
            FetchGroupMetadata fetchGroup = (FetchGroupMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, fetchGroup.getName())) {
                return false;
            }
            return this.valuesMatch(this.m_fetchAttributes, fetchGroup.getFetchAttributes());
        }
        return false;
    }

    public List<FetchAttributeMetadata> getFetchAttributes() {
        return this.m_fetchAttributes;
    }

    public String getName() {
        return this.m_name;
    }

    public void process(ClassAccessor accessor) {
        FetchGroupManager fetchGroupManager;
        MetadataDescriptor descriptor = accessor.getDescriptor();
        if (descriptor.getClassDescriptor().hasFetchGroupManager()) {
            fetchGroupManager = descriptor.getClassDescriptor().getFetchGroupManager();
        } else {
            fetchGroupManager = new FetchGroupManager();
            descriptor.getClassDescriptor().setFetchGroupManager(fetchGroupManager);
        }
        if (fetchGroupManager.hasFetchGroup(this.m_name)) {
            accessor.getLogger().logConfigMessage("metadata_warning_ignore_mapped_superclass_fetch_group", descriptor.getJavaClass(), (Object)accessor.getJavaClass(), (Object)this.m_name);
        } else {
            FetchGroup fetchGroup = new FetchGroup();
            fetchGroup.setName(this.m_name);
            for (FetchAttributeMetadata fetchAttribute : this.m_fetchAttributes) {
                fetchGroup.addAttribute(fetchAttribute.getName());
            }
            fetchGroupManager.addFetchGroup(fetchGroup);
        }
    }

    public void setFetchAttributes(List<FetchAttributeMetadata> attributes) {
        this.m_fetchAttributes = attributes;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

