/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.core.analysis;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.pldt.common.CommonPlugin;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.analysis.PldtAstVisitor;
import org.eclipse.ptp.pldt.mpi.core.Messages;
import org.eclipse.ptp.pldt.mpi.core.MpiIDs;
import org.eclipse.ptp.pldt.mpi.core.MpiPlugin;

public class MpiCASTVisitor
extends PldtAstVisitor {
    private static final String PREFIX = "MPI_";
    private static boolean traceOn = false;

    public MpiCASTVisitor(List mpiIncludes, String fileName, boolean allowPrefixOnlyMatch, ScanReturn msr) {
        super(mpiIncludes, fileName, allowPrefixOnlyMatch, msr);
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        ARTIFACT_CALL = Messages.getString("MpiCASTVisitor.mpiCall");
        ARTIFACT_CONSTANT = Messages.getString("MpiCASTVisitor.mpiConstant");
        ARTIFACT_NAME = "MPI";
        traceOn = CommonPlugin.getTraceOn();
        if (traceOn) {
            System.out.println("MpiCASTVisitor.ctor: traceOn=" + traceOn);
        }
    }

    public int visit(IASTExpression expression) {
        if (expression instanceof IASTFunctionCallExpression) {
            IASTExpression astExpr = ((IASTFunctionCallExpression)expression).getFunctionNameExpression();
            String signature = astExpr.getRawSignature();
            if (astExpr instanceof IASTIdExpression) {
                boolean preProcUsed;
                IASTName tempFN = ((IASTIdExpression)astExpr).getName();
                IBinding tempBIND = tempFN.resolveBinding();
                String tempNAME = tempBIND.getName();
                if (traceOn) {
                    System.out.println("MCAV name: " + tempNAME + " rawsig: " + signature);
                }
                boolean bl = preProcUsed = !signature.equals(tempNAME);
                if (preProcUsed) {
                    signature = tempNAME;
                }
            }
            if (signature.startsWith(PREFIX) && astExpr instanceof IASTIdExpression) {
                IASTName funcName = ((IASTIdExpression)astExpr).getName();
                this.processFuncName(funcName, astExpr);
            }
        } else if (expression instanceof IASTLiteralExpression) {
            this.processMacroLiteral((IASTLiteralExpression)expression);
        }
        return 3;
    }

    public boolean allowIncludePathAdd() {
        boolean canAsk = this.getPreferenceStore().getBoolean("mpiPromptForOtherIncludes");
        return canAsk;
    }

    protected String getIncludesPrefID() {
        return MpiIDs.MPI_INCLUDES;
    }

    protected IPreferenceStore getPreferenceStore() {
        return MpiPlugin.getDefault().getPreferenceStore();
    }

    protected String getTypeName() {
        return ARTIFACT_NAME;
    }
}

